//////////////////////////////////////////////////////////////////////////////
// DCTO9POPTIONS.C - Option setting, save & restore
// Author   : Daniel Coulom - danielcoulom@gmail.com
// Web site : http://dcto9p.free.fr
// Created  : December 2007
//
// This file is part of DCTO9P v11.
// 
// DCTO9P v11 is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// DCTO9P v11 is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with DCTO9P v11.  If not, see <http://www.gnu.org/licenses/>.
//
//////////////////////////////////////////////////////////////////////////////

#include <SDL/SDL.h>
#include <stdio.h>
#include <string.h>
#include "dcto9pglobal.h"

FILE *fpi;        //fichier dcto9p.ini   
int language;     //0=francais 1=anglais
int frequency;    //frequence 6809 en kHz

button optionbutton[OPTIONBUTTON_MAX] = {
{"[prev]", 208,  32, 0, 0, 90}, //0x00 
{"[next]", 208,  40, 0, 0, 91}, //0x01 
{"[prev]", 208,  52, 0, 0, 90}, //0x02 
{"[next]", 208,  60, 0, 0, 91}, //0x03 
{"[prev]", 208,  72, 0, 0, 90}, //0x04 
{"[next]", 208,  80, 0, 0, 91}, //0x05
{"[prev]", 208,  92, 0, 0, 90}, //0x06 
{"[next]", 208, 100, 0, 0, 91}, //0x07
{"[prev]", 208, 112, 0, 0, 90}, //0x08 
{"[next]", 208, 120, 0, 0, 91}, //0x09
{"[prev]", 208, 132, 0, 0, 90}, //0x0a 
{"[next]", 208, 140, 0, 0, 91}, //0x0b
{"[prev]", 208, 152, 0, 0, 90}, //0x0c 
{"[next]", 208, 160, 0, 0, 91}, //0x0d
{" ",       10, 180, 0, 0, 100} //0x0e
};

extern SDL_Surface *dialogbox;
extern int xclient, yclient, vblnumbermax;
extern int k7protection; //protection k7 (0=lecture/ecriture 1=lecture seule)
extern int fdprotection; //protection fd (0=lecture/ecriture 1=lecture seule)
extern int keybpriority; //0=manettes prioritaires 1=clavier prioritaire
extern char *msg[LANG_MAX][MSG_MAX]; //messages en plusieurs langues
extern SDL_Surface *buttonsurface[][2];

extern void Drawtextbox(SDL_Surface *surf, char *string, SDL_Rect rect, int c);

//Draw option box ////////////////////////////////////////////////////////////
void Drawoptionbox()
{
 SDL_Rect rect;
 int i;
 char string[50];
 extern int dialog;
 extern void Initbuttonbackground(int n, int w, int h);
 dialog = 2;     
 //titre
 rect.x = 10; rect.w = dialogbox->w - 32;
 rect.y = 5; rect.h = 15;
 Drawtextbox(dialogbox, msg[language][29], rect, 13);
 //options
 rect.x = 10; rect.w = 194;
 rect.y = 32; rect.h = 15;
 Drawtextbox(dialogbox, msg[language][27], rect, 1); 
 sprintf(string, "Zoom %1.2f", (float)2 * xclient / XBITMAP);
 rect.y += 20;
 Drawtextbox(dialogbox, string, rect, 1); 
 sprintf(string, "%s %i%s", msg[language][28], frequency / 10, "%");
 rect.y += 20; 
 Drawtextbox(dialogbox, string, rect, 1); 
 sprintf(string, "%s %i%s", msg[language][26], 100 / vblnumbermax, "%");
 rect.y += 20; 
 Drawtextbox(dialogbox, string, rect, 1); 
 sprintf(string, "k7 %s", msg[language][(k7protection) ? 42 : 43]);
 rect.y += 20;
 Drawtextbox(dialogbox, string, rect, 1); 
 sprintf(string, "fd %s", msg[language][(fdprotection) ? 42 : 43]);
 rect.y += 20;
 Drawtextbox(dialogbox, string, rect, 1); 
 sprintf(string, "%s", msg[language][(keybpriority) ? 47 : 46]);
 rect.y += 20;
 Drawtextbox(dialogbox, string, rect, 1); 
 //ajout du texte sur le bouton
 rect.x = 2; rect.y = 2; rect.w = 210; rect.h = 16;
 Initbuttonbackground(100, 214, 20);
 Drawtextbox(buttonsurface[100][0], msg[language][38], rect, 4); 
 Drawtextbox(buttonsurface[100][1], msg[language][38], rect, 4); 
 //dessin des boutons
 for(i = 0; i < OPTIONBUTTON_MAX; i++)
 {
  rect.x = optionbutton[i].x; rect.y = optionbutton[i].y;
  SDL_BlitSurface(buttonsurface[optionbutton[i].n][0], NULL, dialogbox, &rect);
 }
}

//Initialisation des valeurs par defaut //////////////////////////////////////
void Initdefault()
{
 language = 0;          //francais
 xclient = XBITMAP;     //zoomx 2
 yclient = 2 * YBITMAP; //zoomy 2
 frequency = 1000;      //1000 kHz
 vblnumbermax = 2;      //nombre de vbl entre deux affichages 
 k7protection = 1;      //protection cassette 
 fdprotection = 1;      //protection disquette
 keybpriority = 0;      //manettes prioritaires
}

//Traitement des clics des boutons d'options /////////////////////////////////
void Optionclick()
{
 SDL_Rect rect;
 int i, x, y, step;    
 extern int xmouse, ymouse;
 extern int dialog;
 extern SDL_Rect dialogrect; 
 extern void Displayscreen();
 extern void Resizescreen(int x, int y);

 //recherche du bouton du clic
 for(i = 0; i < OPTIONBUTTON_MAX; i++)
 {
  x = dialogrect.x + optionbutton[i].x;     
  y = dialogrect.y + optionbutton[i].y;     
  if(xmouse > x) if(xmouse < (x + optionbutton[i].w))
  if(ymouse > y) if(ymouse < (y + optionbutton[i].h))
  break;
 }
 if(i >= OPTIONBUTTON_MAX) return;
 //dessin du bouton enfonce
 rect.x = optionbutton[i].x; rect.y = optionbutton[i].y;
 SDL_BlitSurface(buttonsurface[optionbutton[i].n][1], NULL, dialogbox, &rect);
 Displayscreen(); SDL_Delay(200);
 //traitement en fonction du bouton           
 switch(i)
 {
  case  0: if(--language < 0) language++;              //previous language
           SDL_WM_SetCaption(msg[language][0], NULL);
           break;
  case  1: if(++language == LANG_MAX) language--;      //next language 
           SDL_WM_SetCaption(msg[language][0], NULL);
           break;
  case  2: x = 2 * xclient / XBITMAP + 1; if(x > 4) x = 4; //zoom in
           Resizescreen(XBITMAP * x / 2, YSTATUS + YBITMAP * x);
           break;
  case  3: x = 2 * xclient / XBITMAP - 1; if(x < 1) x = 1; //zoom out
           Resizescreen(XBITMAP * x / 2, YSTATUS + YBITMAP * x);
           break;
  case  4: step = 10; frequency = frequency * 10 / 10; //faster
           if(frequency < 900) step = 100; 
           if(frequency > 1099) step = 100; 
           if(frequency > 1999) step = 1000; 
           if(frequency < 9999 - step) frequency += step;
           break;
  case  5: step = 10; frequency = frequency * 10 / 10; //slower
           if(frequency < 901) step = 100; 
           if(frequency > 1100) step = 100; 
           if(frequency > 2000) step = 1000; 
           if(frequency > 9 + step) frequency -= step;
           break;
  case  6: vblnumbermax /= 2; //more frames
           if(vblnumbermax < 1) vblnumbermax = 1;
           break;
  case  7: vblnumbermax *= 2; //less frames
           if(vblnumbermax > 64) vblnumbermax = 64;
           break;
  case  8: k7protection = 0; //unprotect k7
           break;
  case  9: k7protection = 1; //protect k7
           break;
  case 10: fdprotection = 0; //unprotect fd
           break;
  case 11: fdprotection = 1; //protect k7
           break;
  case 12: keybpriority = 0; //manettes prioritaires
           break;
  case 13: keybpriority = 1; //clavier prioritaire
           break;
  case 14: Initdefault();    //restore default values
           //Restorewindow(); //lire les commentaires de cette fonction
           Resizescreen(xclient, YSTATUS + yclient);
           break;
 } 
 if(dialog == 2) Drawoptionbox();
}

//Option setting /////////////////////////////////////////////////////////////
void Options()
{
 extern void Createdialogbox(int w, int h);
 Createdialogbox(236, 216);
 Drawoptionbox();
}     

//Option initialization //////////////////////////////////////////////////////
void Initoptions()
{
 char string[256];    
 Initdefault();
 //ouverture fichier dcto9p.ini
 fpi = fopen("dcto9p.ini", "rb+");                 //s'il existe ouverture
 if(fpi == NULL) fpi = fopen("dcto9p.ini", "wb+"); //s'il n'existe pas : creation
 fread(string, 12, 1, fpi);                       //lecture identifiant  
 if(strcmp("dcto9pini-01", string) != 0) return;
 //initialisation des options
 fread(&language, 4, 1, fpi);  //langue 
 fread(&frequency, 4, 1, fpi); //frequence 6809
 fread(&xclient, 4, 1, fpi);   //largeur ecran
 fread(&yclient, 4, 1, fpi);   //hauteur ecran
 fread(&vblnumbermax, 4, 1, fpi); 
 fread(&k7protection, 4, 1, fpi); 
 fread(&fdprotection, 4, 1, fpi); 
 fread(&keybpriority, 4, 1, fpi); 
 //controle
 if(language < 0) language = 0;
 if(language > (LANG_MAX - 1)) language = LANG_MAX - 1;
 if(frequency < 100) frequency = 100;
 if(frequency > 9000) frequency = 9000;
 if(xclient < (XBITMAP / 2)) xclient = XBITMAP / 2; 
 if(xclient > (2 * XBITMAP)) xclient = 2 * XBITMAP; 
 if(yclient < YBITMAP) yclient = YBITMAP; 
 if(yclient > (4 * YBITMAP)) yclient = 4 * YBITMAP;
 if(vblnumbermax < 1) vblnumbermax = 1;
 if(vblnumbermax > 64) vblnumbermax = 64;
 if(k7protection) k7protection = 1; 
 if(fdprotection) fdprotection = 1; 
 if(keybpriority) keybpriority = 1; 
} 

//Option save ////////////////////////////////////////////////////////////////
void Saveoptions()
{
 int i = 0;    
 fseek(fpi, 0, SEEK_SET);
 fwrite("dcto9pini-01", 12, 1, fpi);
 fwrite(&language, 4, 1, fpi);  //langue 
 fwrite(&frequency, 4, 1, fpi); //frequence 6809
 fwrite(&xclient, 4, 1, fpi);   //largeur ecran
 fwrite(&yclient, 4, 1, fpi);   //hauteur ecran
 fwrite(&vblnumbermax, 4, 1, fpi); 
 fwrite(&k7protection, 4, 1, fpi); 
 fwrite(&fdprotection, 4, 1, fpi); 
 fwrite(&keybpriority, 4, 1, fpi);
 fwrite(&i, 4, 1, fpi);         //reserve
 fwrite(&i, 4, 1, fpi);         //reserve
 fwrite(&i, 4, 1, fpi);         //reserve
 fwrite(&i, 4, 1, fpi);         //reserve
 fwrite(&i, 4, 1, fpi);         //reserve
 fclose(fpi); 
} 
