#define byte unsigned char
#define word unsigned short


#define SOUND_SAMPLE_RATE	22050
#define AUDIO_FRAME_LEN		882

#define CYCLESHORT	0
#define	CYCLELONG	1
#define CYCLENULL	-1
#define NULLBIT		0xFF


typedef struct vzFile
{
	byte	vzmagic[4];
	byte	filename[17];
	byte	ftype;
	byte	start_addrl;
	byte	start_addrh;
} VZFILE;

typedef struct WAVEHEADR
{
	char            format[4];          // RIFF
	unsigned long   fileLength;         // filelength
	char            wave_fmt[8];        // "WAVEfmt "
	unsigned long   chunkSize;          // 16 for PCM
   	unsigned short  fmt_tag;            // PCM = 1
	unsigned short  channels;           // Mono/Stereo
	unsigned long   sampleRate;			// 11025, 22050 etc
	unsigned long   ByteRate;			// SampleRate * Channels * BitsPerSample/8
	unsigned short  blk_align;			// NumChannels * BitsPerSample/8
	unsigned short  bits_per_sample;	// 8, 16 etc
	char			data[4];            // "data"
	unsigned long   data_len;           // NumSamples * NumChannels * BitsPerSample/8
} HEADER;

void WrSpeaker();
byte RdZ80(word A);
void WrZ80(word A, byte v);
byte InZ80(word P);
void OutZ80(word P, byte B);
void vtech1_floppy_remove(int id);
void InitVZ();
void LoadPrefs();
void SavePrefs();
int  PlayTape();
void RecordTape();
void WriteCassette(byte v);
void StopTape();
//void LoadVZFile(byte *fileBuffer, int fileLength, VZFILE *vzf);
void LoadVZFile(char *s);
void LoadVZBitmap(char *s);
void LoadFont(char *filespec);
void LoadMem(word startAddr, char *filespec);
int DoFrame();
void UpdateSound();
void ScanKbrd();
void DrawScreen(byte latch);
void SaveVZFile(byte *fileBuffer, unsigned long *dwFileLen, VZFILE *vzf);
int vtech1_floppy_init(int id, char *s);
void MapTape(char *s);
void MapPrinter(char *s);
void GetDisassembly(char *disText, char *regText, char *ptrText, char *hwText, char *brkText);
void Disassemble(char *disText, int startAddr, int endAddr);
void DoStep();
void SetBreakPoints(char *brkPoints);
void GetVideoBuffer(byte **bufr, int *scanline, long **palette);
void RunVZ();
int PlayResource(int sound);
void SetPrefs(char *vzprefs);
