#define end .end
#define org .org
#define equ .equ
#define byte .byte

	.org 8000h
MLSTART


;==================
; playsong,
;	play a song located at songstart
;	James the Animal Tamer
;	modified for VZ sound board by James Diffendaffer
playsong
	push	hl
	push	bc
	push	af
	
	ld	hl,songstart
playline
	ld	a,(hl)			; get wait
	inc	hl
	ld	c,a			; hold wait in .c
	ld	a,(hl)			; get number of registers
	inc	hl
	ld	b,a			; hold number of registers in .b
	or	c
	jr	z,playsongend
;-
	call	waittof			; wait top of frame, c times
	; number of registers is in .b
	; .hl points to register to change data
_reglop
	ld	a,(hl)
	inc	hl
	out	(129),a		; register select
	ld	a,(hl)
	inc	hl
	out	(128),a
	dec	b
	jr	nz,_reglop
	jr	playline
;---
playsongend
	pop	af
	pop	bc
	pop	hl
	
	ret

;==================
; waittof,
;	wait top of frame, c times
;	preserve registers
waittof
	push	af
	push	bc
	push	hl
	
	ld	b,c
	
	; address 26624 bit 7 goes low when video retrace starts
	ld	hl,6800H
_lop1
	ld	a,(hl)
	bit	7,a
	jr	z,_invblanka
	jr	nz,_lop1
_invblanka
    ld  a,(hl)
    bit 7,a
    jr  z,_invblanka

	dec	b
	jr	nz,_lop1
	
	pop	hl
	pop	bc
	pop	af
	ret

	; interrupt calls $787D in RAM
	; install our interrupt handler
_InstallInt:
	ld	hl,_IntHandler
	ld	(787EH),hl
	ld	a,0C3H			;$C3 = JP
	ld	(787DH),a
	ret

	; remove our interrupt handler
_RemoveInt:
	ld	a,0C9H			;$C9 = RET
	ld	(787DH),a
	ret

	; interrupt handler
_IntHandler:
	ret

songstart
	; rem  song
	; rem wait, number of registers to change,
	;	register number, new value
	;	register number, new value
	;	etc.
	; ends when number of registers to change is 0.
	.byte 1,4,  8,0, 9,0, 10,0, 7,56
	;-- snip
    .byte 1,3,0,221,1,1,8,15
    .byte 14,1,8,0
    .byte 1,3,0,250,1,1,8,15
    .byte 14,1,8,0
    .byte 1,6,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,125,3,2,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,246,1,2,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,151,1,5,8,15,2,221,3,1,9,15
    .byte 29,2,8,0,9,0
    .byte 1,6,0,251,1,4,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,125,3,2,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,246,1,2,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,151,1,5,8,15,2,221,3,1,9,15
    .byte 29,2,8,0,9,0
    .byte 1,6,0,251,1,4,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,125,3,2,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,246,1,2,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,151,1,5,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,1,8,0
    .byte 1,7,0,56,1,2,8,15,9,0,2,236,3,5,9,15
    .byte 14,1,8,0
    .byte 1,3,0,89,1,2,8,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 29,2,8,0,9,0
    .byte 1,3,0,246,1,2,8,15
    .byte 29,1,8,0
    .byte 1,3,0,236,1,5,8,15
    .byte 29,1,8,0
    .byte 1,3,0,221,1,1,8,15
    .byte 14,1,8,0
    .byte 1,3,0,250,1,1,8,15
    .byte 14,1,8,0
    .byte 1,6,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 13,1,9,0
    .byte 1,3,2,125,3,2,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,56,3,2,9,15
    .byte 13,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,151,1,5,8,15,2,221,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,203,1,2,8,15,2,123,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,251,1,4,8,15,2,62,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,83,1,3,8,15,2,123,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,187,1,3,8,15,2,221,3,1,9,15
    .byte 29,2,8,0,9,0
    .byte 1,6,0,244,1,3,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,1,8,0
    .byte 1,7,0,56,1,2,8,15,9,0,2,112,3,4,9,15
    .byte 14,1,8,0
    .byte 1,3,0,125,1,2,8,15
    .byte 14,1,8,0
    .byte 1,7,0,56,1,2,8,15,9,0,2,246,3,2,9,15
    .byte 14,1,8,0
    .byte 1,3,0,250,1,1,8,15
    .byte 14,1,8,0
    .byte 1,7,0,221,1,1,8,15,9,0,2,151,3,5,9,15
    .byte 14,1,8,0
    .byte 1,3,0,169,1,1,8,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,203,1,2,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,251,1,4,8,15,2,62,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,83,1,3,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,187,1,3,8,15,2,123,3,1,9,15
    .byte 29,1,8,0
    .byte 1,7,0,221,1,1,8,15,9,0,2,244,3,3,9,15
    .byte 14,1,8,0
    .byte 1,3,0,250,1,1,8,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,125,3,2,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,246,1,2,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,151,1,5,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,203,1,2,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,251,1,4,8,15,2,62,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,83,1,3,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,187,1,3,8,15,2,221,3,1,9,15
    .byte 29,2,8,0,9,0
    .byte 1,6,0,244,1,3,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,1,8,0
    .byte 1,7,0,56,1,2,8,15,9,0,2,112,3,4,9,15
    .byte 14,1,8,0
    .byte 1,3,0,125,1,2,8,15
    .byte 14,1,8,0
    .byte 1,7,0,56,1,2,8,15,9,0,2,246,3,2,9,15
    .byte 14,1,8,0
    .byte 1,3,0,125,1,2,8,15
    .byte 14,1,8,0
    .byte 1,7,0,89,1,2,8,15,9,0,2,236,3,5,9,15
    .byte 14,1,8,0
    .byte 1,3,0,250,1,1,8,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,151,1,5,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,1,8,0
    .byte 1,7,0,56,1,2,8,15,9,0,2,236,3,5,9,15
    .byte 14,1,8,0
    .byte 1,3,0,125,1,2,8,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 29,2,8,0,9,0
    .byte 1,3,0,221,1,1,8,15
    .byte 14,1,8,0
    .byte 1,3,0,250,1,1,8,15
    .byte 14,1,8,0
    .byte 1,6,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,125,3,2,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,151,1,5,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,203,1,2,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,251,1,4,8,15,2,62,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,83,1,3,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,187,1,3,8,15,2,221,3,1,9,15
    .byte 28,2,8,0,9,0
    .byte 1,6,0,244,1,3,8,15,2,221,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 13,1,9,0
    .byte 1,3,2,125,3,2,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,151,1,5,8,15,2,221,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,203,1,2,8,15,2,123,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,251,1,4,8,15,2,62,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,83,1,3,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,187,1,3,8,15,2,123,3,1,9,15
    .byte 28,2,8,0,9,0
    .byte 1,6,0,244,1,3,8,15,2,221,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,125,3,2,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,151,1,5,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,203,1,2,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,251,1,4,8,15,2,62,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,83,1,3,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,187,1,3,8,15,2,221,3,1,9,15
    .byte 29,2,8,0,9,0
    .byte 1,6,0,244,1,3,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,125,3,2,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,246,1,2,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,125,3,2,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,236,1,5,8,15,2,89,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,151,1,5,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,1,8,0
    .byte 1,7,0,56,1,2,8,15,9,0,2,236,3,5,9,15
    .byte 14,1,8,0
    .byte 1,3,0,125,1,2,8,15
    .byte 14,1,8,0
    .byte 1,7,0,56,1,2,8,15,9,0,2,112,3,4,9,15
    .byte 29,2,8,0,9,0
    .byte 30,6,0,83,1,3,8,15,2,101,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,123,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,56,1,2,8,15,2,169,3,1,9,15
    .byte 14,1,8,0
    .byte 1,4,9,0,2,125,3,2,9,15
    .byte 15,6,0,251,1,4,8,15,4,62,5,1,10,15
    .byte 14,1,10,0
    .byte 1,4,9,0,2,101,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,244,1,3,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,1,8,0
    .byte 1,7,0,123,1,1,8,15,9,0,2,187,3,3,9,15
    .byte 14,1,8,0
    .byte 1,3,0,169,1,1,8,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,187,1,3,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,62,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,83,1,3,8,15,2,101,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,123,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,56,1,2,8,15,2,169,3,1,9,15
    .byte 14,1,8,0
    .byte 1,3,0,125,1,2,8,15
    .byte 14,1,9,0
    .byte 1,6,2,236,3,5,9,15,4,123,5,1,10,15
    .byte 14,2,8,0,10,0
    .byte 1,3,0,169,1,1,8,15
    .byte 13,2,8,0,9,0
    .byte 1,9,0,179,1,4,8,15,2,246,3,2,9,15,4,221,5,1
    .byte     10,15
    .byte 13,1,10,0
    .byte 1,3,4,250,5,1,10,15
    .byte 13,3,8,0,9,0,10,0
    .byte 1,6,0,112,1,4,8,15,2,221,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,56,1,2,8,15,2,246,3,2,9,15
    .byte 13,1,8,0
    .byte 1,3,0,125,1,2,8,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 28,2,8,0,9,0
    .byte 1,3,0,123,1,1,8,15
    .byte 13,1,8,0
    .byte 1,3,0,62,1,1,8,15
    .byte 13,1,8,0
    .byte 1,6,0,83,1,3,8,15,2,101,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,123,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,56,1,2,8,15,2,169,3,1,9,15
    .byte 13,1,8,0
    .byte 1,4,9,0,2,125,3,2,9,15
    .byte 14,6,0,251,1,4,8,15,4,62,5,1,10,15
    .byte 13,2,9,0,10,0
    .byte 1,3,2,101,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,244,1,3,8,15,2,123,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,187,1,3,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,244,1,3,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,112,1,4,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,123,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,169,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,221,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,151,1,5,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,203,1,2,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,236,1,5,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,89,3,2,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 30,2,8,0,9,0
    .byte 32,6,0,83,1,3,8,15,2,101,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,123,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,56,1,2,8,15,2,169,3,1,9,15
    .byte 14,1,8,0
    .byte 1,4,9,0,2,125,3,2,9,15
    .byte 15,6,0,251,1,4,8,15,4,62,5,1,10,15
    .byte 14,1,10,0
    .byte 1,4,9,0,2,101,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,244,1,3,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,1,8,0
    .byte 1,7,0,123,1,1,8,15,9,0,2,187,3,3,9,15
    .byte 14,1,8,0
    .byte 1,3,0,169,1,1,8,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,187,1,3,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,62,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,83,1,3,8,15,2,101,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,123,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,56,1,2,8,15,2,169,3,1,9,15
    .byte 14,1,8,0
    .byte 1,3,0,125,1,2,8,15
    .byte 14,1,9,0
    .byte 1,6,2,236,3,5,9,15,4,123,5,1,10,15
    .byte 14,2,8,0,10,0
    .byte 1,3,0,169,1,1,8,15
    .byte 13,2,8,0,9,0
    .byte 1,9,0,179,1,4,8,15,2,246,3,2,9,15,4,221,5,1
    .byte     10,15
    .byte 13,1,10,0
    .byte 1,3,4,250,5,1,10,15
    .byte 13,3,8,0,9,0,10,0
    .byte 1,6,0,112,1,4,8,15,2,221,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,56,1,2,8,15,2,246,3,2,9,15
    .byte 13,1,8,0
    .byte 1,3,0,125,1,2,8,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 29,2,8,0,9,0
    .byte 1,3,0,123,1,1,8,15
    .byte 13,1,8,0
    .byte 1,3,0,62,1,1,8,15
    .byte 13,1,8,0
    .byte 1,6,0,83,1,3,8,15,2,101,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,123,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,56,1,2,8,15,2,169,3,1,9,15
    .byte 14,1,8,0
    .byte 1,3,0,125,1,2,8,15
    .byte 14,1,9,0
    .byte 1,6,2,251,3,4,9,15,4,62,5,1,10,15
    .byte 13,2,8,0,10,0
    .byte 1,3,0,101,1,1,8,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,244,1,3,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,187,1,3,8,15,2,123,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,244,1,3,8,15,2,123,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,112,1,4,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,123,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,169,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,221,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,151,1,5,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,203,1,2,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,236,1,5,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,89,3,2,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 30,2,8,0,9,0
    .byte 32,3,0,221,1,1,8,15
    .byte 14,1,8,0
    .byte 1,3,0,250,1,1,8,15
    .byte 14,1,8,0
    .byte 1,6,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,125,3,2,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,246,1,2,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,151,1,5,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,203,1,2,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,251,1,4,8,15,2,62,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,83,1,3,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,1,9,0
    .byte 1,7,8,0,0,187,1,3,8,15,2,221,3,1,9,15
    .byte 28,2,8,0,9,0
    .byte 1,6,0,244,1,3,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,1,8,0
    .byte 1,7,0,56,1,2,8,15,9,0,2,112,3,4,9,15
    .byte 14,1,8,0
    .byte 1,3,0,125,1,2,8,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,151,1,5,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,203,1,2,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,251,1,4,8,15,2,62,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,83,1,3,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,187,1,3,8,15,2,123,3,1,9,15
    .byte 28,2,8,0,9,0
    .byte 1,6,0,244,1,3,8,15,2,221,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 13,1,9,0
    .byte 1,3,2,125,3,2,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,151,1,5,8,15,2,221,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 14,2,8,0,9,0
    .byte 1,6,0,203,1,2,8,15,2,123,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,251,1,4,8,15,2,62,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,101,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,83,1,3,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,187,1,3,8,15,2,221,3,1,9,15
    .byte 28,2,8,0,9,0
    .byte 1,6,0,244,1,3,8,15,2,221,3,1,9,15
    .byte 13,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,112,1,4,8,15,2,56,3,2,9,15
    .byte 13,1,9,0
    .byte 1,3,2,125,3,2,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,56,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,125,3,2,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,236,1,5,8,15,2,89,3,2,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,246,1,2,8,15,2,123,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,169,3,1,9,15
    .byte 13,2,8,0,9,0
    .byte 1,6,0,151,1,5,8,15,2,221,3,1,9,15
    .byte 14,1,9,0
    .byte 1,3,2,250,3,1,9,15
    .byte 14,1,8,0
    .byte 1,7,0,56,1,2,8,15,9,0,2,236,3,5,9,15
    .byte 14,1,8,0
    .byte 1,3,0,125,1,2,8,15
    .byte 14,1,8,0
    .byte 1,7,0,56,1,2,8,15,9,0,2,112,3,4,9,15
    .byte 30,2,8,0,9,0
    ;-- unsnip
    .byte 1,3,  8,0, 9,0, 10,0
    .byte 0,0
;=== end of song

MLEND

	

	.end

