program pintest;

type
  Tabc = string[3];

const
  pins: array[1..40] of Tabc =
    ({1}  #$78#0#0,   #0#0#0,
     {3}  #$F8#0#$80, #$F8#$01#0,
     {5}  #$F8#0#$40, #$F8#$02#0,
     {7}  #$F8#0#$20, #$F8#$04#0,
     {9}  #$F8#0#$10, #$F8#$08#0,
     {11} #$F8#0#$08, #$F8#$10#0,
     {13} #$F8#0#$04, #$F8#$20#0,
     {15} #$F8#0#$02, #$F8#$40#0,
     {17} #$F8#0#$01, #$F8#$80#0,
     {19} #0#0#0,     #0#0#0,
     {21} #0#0#0,     #0#0#0,
     {23} #$D8#0#0,   #0#0#0,
     {25} #$B8#0#0,   #0#0#0,
     {27} #0#0#0,     #0#0#0,
     {29} #0#0#0,     #0#0#0,
     {31} #0#0#0,     #0#0#0,
     {33} #$FA#0#0,   #0#0#0,
     {35} #$F9#0#0,   #$FC#0#0,
     {37} #$F0#0#0,   #$E8#0#0,
     {39} #0#0#0,     #0#0#0);
  pin_zero_all:string[3]=#$F8#0#0;

  ide_8255_lsb=$F602;
  ide_8255_msb=$F601;
  ide_8255_ctl=$F600;
  cfg_8255    =$F603;

procedure ClrScr;
begin
  write(#$1F);
end;

procedure DrawSocket;
var ii:integer;
begin
  GotoXy(18,1); WriteLn('+-----+');
  for ii:=1 to 20 do
     WriteLn('                -|',ii*2-1:2,' ',ii*2:2,'|-');
  Writeln('                 +-----+');
end;

procedure Set8255abc(abc: Tabc);
begin
  MEM[ide_8255_ctl]:=ord(abc[1]);
  MEM[ide_8255_msb]:=ord(abc[2]);
  MEM[ide_8255_lsb]:=ord(abc[3]);
end;

var i,j: integer;
    ch: char;

begin
  MEM[cfg_8255]:=$80;                    { all 8255 ports to output }
  ClrScr;
  write('IDE (port F600) pin test   ');
  DrawSocket;
  GotoXY(1,3);  write('Press any key');
  GotoXY(1,5);  write('<esc> - Exit');
  i:=1;
  j:=0;
  repeat
    repeat
      ch:=#0;
      Set8255abc(pin_zero_all);
      if j=1 then
      begin
        j:=0;
        GotoXY(26-(i mod 2)*10, (i+3) div 2);
        if pins[i]=#0#0#0 then Write('?')
        else
        begin
          Write('0');
          Set8255abc(pin_zero_all);
        end;
      end
      else
      begin
        j:=1;
        GotoXY(26-(i mod 2)*10, (i+3) div 2);
        if pins[i]=#0#0#0 then Write('!')
        else
        begin
          Write('1');
          Set8255abc(pins[i]);
        end;
      end;
      if keypressed then read(kbd, ch)
      else begin
        Delay(250);
        if keypressed then read(kbd, ch)
        else begin
          Delay(250);
          if keypressed then read(kbd, ch)
          else begin
            Delay(250);
            if keypressed then read(kbd, ch)
            else Delay(250);
          end;
        end;
      end;
    until ch<>#0;
    GotoXY(26-(i mod 2)*10, (i+3) div 2); Write(' ');
    i:=i+1;
  until (i>40)or(ch=#27);
end.

