// pokejump.bs by freQvibez & BeRo

#define hexout(desc, dec) print(desc, ": $", inttohex(dec), "\r\n");

stdcall void OpcodeTrap(int Immediate) {}

struct CPUReg { int a; int x; int y; int s; int p; int pc; int halted; };

void main() {
    AllocConsole();
    int i=0, j=0;
    CPUReg cpu;
    SetSpeedThrottling(1);
    while (!ShouldExit()) {
        if (i < (0x138 * 100))
            i++;

        if ((i>=(0x138 * 100)) && (j++>(0x138*50))) {
            j = 0;

            Poke(0x1000, 0xee);         // INC $d020
            Poke(0x1001, 0x20);
            Poke(0x1002, 0xd0);
            Poke(0x1003, 0x40);         // RTI

            GetCPU(&cpu.a, &cpu.x, &cpu.y, &cpu.s, &cpu.p, &cpu.pc, &cpu.halted);
            Push(cpu.pc >> 8 & 0xff);   // hi
            Push(cpu.pc & 0xff);        // lo
            Push(cpu.p);                // flags

            GetCPU(&cpu.a, &cpu.x, &cpu.y, &cpu.s, &cpu.p, &cpu.pc, &cpu.halted);
            cpu.pc = 0x1000;
            cpu.p = (cpu.p | 4) & 0xef;
            SetCPU(cpu.a, cpu.x, cpu.y, cpu.s, cpu.p, cpu.pc, cpu.halted);

            GetCPU(&cpu.a, &cpu.x, &cpu.y, &cpu.s, &cpu.p, &cpu.pc, &cpu.halted);
            hexout("pc", cpu.pc);
            hexout("sp", cpu.s);
        }
        EmulateLine();
    }
    FreeConsole();
}
