uniform sampler2D texture;
float2 rcpres;
float CurrentEye;
float CurrentBrightness;

//Use these to modify the behaviour of the shader
static const float BloomScale = 0.60;
static const float HDRScale = -0.9;
static const float HDRAdjust = 0.25;

//Uncomment these settings and comment out the ones above for super bright bloom
//static const float BloomScale = 1.5;
//static const float HDRScale = -1.5;
//static const float HDRAdjust = 0.05;

float2 PixelKernelH[13] = {
  {-6, 0},
  {-5, 0},
  {-4, 0},
  {-3, 0},
  {-2, 0},
  {-1, 0},
  { 0, 0},
  { 1, 0},
  { 2, 0},
  { 3, 0},
  { 4, 0},
  { 5, 0},
  { 6, 0},
};

float2 PixelKernelV[13] = {
  {0, -6},
  {0, -5},
  {0, -4},
  {0, -3},
  {0, -2},
  {0, -1},
  {0,  0},
  {0,  1},
  {0,  2},
  {0,  3},
  {0,  4},
  {0,  5},
  {0,  6},
};

static const float BlurWeights[13] = {
  0.002216,
  0.008764,
  0.026995,
  0.064759,
  0.120985,
  0.176033,
  0.199471,
  0.176033,
  0.120985,
  0.064759,
  0.026995,
  0.008764,
  0.002216,
};

void main(void) {
  // Fetch the regular RGB texel color from the texture
  float4 color = texture2D(texture, gl_TexCoord[0].xy);

  //color += saturate(texture2D(texture, gl_TexCoord[0].xy) - (CurrentEye + 0.1)); //Uncomment this line for retina burn
  float4 adjust = (color-CurrentEye)-HDRAdjust;
  color = saturate((adjust*adjust*adjust*adjust*adjust)*8);

  color *= 1+((CurrentEye - 0.5)*HDRScale);
  //color *= 1+((CurrentBrightness - CurrentEye)*2);  //Uncomment this line for abrubt brightness changes

  float4 color2=0;
  for (int i = 0; i < 13; i++) {    
    color2 += texture2D(texture, gl_TexCoord[0].xy + (PixelKernelH[i]*rcpres))* BlurWeights[i];
    color2 += texture2D(texture, gl_TexCoord[0].xy + (PixelKernelV[i]*rcpres))* BlurWeights[i];
  }
  color2 *= BloomScale;

  gl_FragColor = saturate(color + color2);
}
