uniform sampler2D texture;

float NumTiles = 256.0;
float Threshhold = 0.15;
float3 EdgeColor = {0.7, 0.7, 0.7};

void main(void) {
  float size = 1.0/NumTiles;
  float2 Pbase = gl_TexCoord[0].xy - fmod(gl_TexCoord[0].xy, size.xx);
  float2 PCenter = Pbase + (size/2.0).xx;
  float2 st = (gl_TexCoord[0].xy - Pbase)/size;
  float4 c1 = (float4)0;
  float4 c2 = (float4)0;
  float4 invOff = float4((1-EdgeColor),1);
  if (st.x > st.y) {c1 = invOff;}
  float threshholdB = 1.0 - Threshhold;
  if (st.x > threshholdB) {c2 = c1;}
  if (st.y > threshholdB) {c2 = c1;}
  float4 cBottom = c2;
  c1 = (float4)0;
  c2 = (float4)0;
  if (st.x > st.y) {c1 = invOff;}
  if (st.x < Threshhold) {c2 = c1;}
  if (st.y < Threshhold) {c2 = c1;}
  float4 cTop = c2;
  float4 tileColor = texture2D(texture, PCenter);

  gl_FragColor = tileColor + cTop - cBottom;
}
