uniform sampler2D texture;

float Opacity = 1.0;

void main(void) {
  float4 base = texture2D(texture, gl_TexCoord[0].xy);
  float3 lumCoeff = float3(0.25,0.65,0.1);
  float lum = dot(lumCoeff,base.rgb);
  float3 blend = lum.rrr;
  float L = min(1,max(0,10*(lum- 0.45)));
  float3 result1 = 2.0f * base.rgb * blend;
  float3 result2 = 1.0f - 2.0f*(1.0f-blend)*(1.0f-base.rgb);
  float3 newColor = lerp(result1,result2,L);
  float A2 = Opacity * base.a;
  float3 mixRGB = A2 * newColor.rgb;
  mixRGB += ((1.0f-A2) * base.rgb);

  gl_FragColor = float4(mixRGB,base.a);
}
