uniform sampler2D texture;

float2 Cel = 0.0003;

float2 PixelKernel[6] = {
    {  1,0.5},
    {0.5,  1},
    {  1,0.5},
    {0.5, -1},
    { -1,0.5},
    {0.5, -1},
};

float4 LuminanceConv = {-0.2125, -0.7154, -0.0721, 0.0000};

void main(void) {
  float4 Orig = texture2D(texture, gl_TexCoord[0].xy);
  float4 Sum = 0;
  for(int i=0; i<6; i++)
    Sum += (abs(Orig - texture2D(texture, gl_TexCoord[0].xy + (PixelKernel[i]*Cel)))- 0.5f)* 1.2 + 0.5f;
 
  gl_FragColor = saturate( dot( LuminanceConv, Sum ) ) * 1.1;
}
