uniform sampler2D texture;

void main(void) {
  // Fetch the regular RGB texel color from the texture
  float4 color = texture2D(texture, gl_TexCoord[0].xy);

  float r = radians(0.0);
  float c = cos(r);
  float s = sin(r);
  float2 nuv = 1.0*(gl_TexCoord[0].xy - float2(0.5,0.5));
  nuv = float2(c*nuv.x-s*nuv.y, c*nuv.y+s*nuv.x);
  nuv += float2(0.5+0.003,0.5+0.003);
  float4 texCol0 = texture2D(texture, gl_TexCoord[0].xy);
  float4 texCol1 = texture2D(texture, nuv);
  float3 result = saturate(texCol0.rgb - 1.0*(texCol1.rgb));

  gl_FragColor = float4(result,texCol0.a);
}
