uniform sampler2D texture;

float Desat = 0.5;
float Toned = 1.0;
float3 LightColor = {1.0, 0.9, 0.5};
float3 DarkColor = {0.2, 0.05, 0.0};

void main(void) {
  float3 scnColor = LightColor * texture2D(texture, gl_TexCoord[0].xy).xyz;
  float3 grayXfer = float3(0.3,0.59,0.11);
  float gray = dot(grayXfer,scnColor);
  float3 muted = lerp(scnColor,gray.xxx,Desat);
  float3 sepia = lerp(DarkColor,LightColor,gray);
  float3 result = lerp(muted,sepia,Toned);

  gl_FragColor = float4(result,1);
}
