/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import jpcsp.Allegrex.compiler.CodeInstruction;
import jpcsp.Allegrex.compiler.CodeSequence;
import jpcsp.Allegrex.compiler.CompilerContext;
import org.objectweb.asm.MethodVisitor;

public class SequenceCodeInstruction
extends CodeInstruction {
    private CodeSequence codeSequence;

    public SequenceCodeInstruction(CodeSequence codeSequence) {
        this.codeSequence = codeSequence;
        this.setAddress(codeSequence.getStartAddress());
        CodeInstruction firstInstruction = codeSequence.getInstructions().get(0);
        this.setBranchTarget(firstInstruction.isBranchTarget());
        this.setBranching(firstInstruction.isBranching());
        this.setBranchingTo(firstInstruction.getBranchingTo());
    }

    public CodeSequence getCodeSequence() {
        return this.codeSequence;
    }

    @Override
    public int getEndAddress() {
        return this.codeSequence.getEndAddress();
    }

    @Override
    public int getLength() {
        return this.codeSequence.getLength();
    }

    @Override
    public void compile(CompilerContext context, MethodVisitor mv) {
        this.startCompile(context, mv);
        context.visitCall(context.getCodeBlock().getStartAddress(), this.getMethodName(context));
    }

    @Override
    public boolean hasFlags(int flags) {
        return false;
    }

    public String getMethodName(CompilerContext context) {
        return context.getStaticExecMethodName() + Integer.toHexString(this.codeSequence.getStartAddress());
    }

    @Override
    public String toString() {
        return String.format("0x%X - %s", this.codeSequence.getStartAddress(), this.codeSequence.toString());
    }
}

