/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Debugger.ElfHeaderInfo;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.HLE.modules.scePopsMan;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.NIDMapper;
import jpcsp.format.DeferredStub;
import jpcsp.format.DeferredVStub32;
import jpcsp.format.DeferredVStubHI16;
import jpcsp.format.DeferredVstubLO16;
import jpcsp.format.Elf32;
import jpcsp.format.Elf32EntHeader;
import jpcsp.format.Elf32ProgramHeader;
import jpcsp.format.Elf32Relocate;
import jpcsp.format.Elf32SectionHeader;
import jpcsp.format.Elf32StubHeader;
import jpcsp.format.PBP;
import jpcsp.format.PSF;
import jpcsp.format.PSP;
import jpcsp.format.PSPModuleInfo;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemorySection;
import jpcsp.memory.MemorySections;
import jpcsp.settings.Settings;
import jpcsp.util.HLEUtilities;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class Loader {
    private static Loader instance;
    private static Logger log;
    public static final int SCE_MAGIC = 1162040190;
    public static final int PSP_MAGIC = 0x50535000;
    public static final int EDAT_MAGIC = 0x54414445;
    public static final int FIRMWAREVERSION_HOMEBREW = 999;
    public static final int FORMAT_UNKNOWN = 0;
    public static final int FORMAT_ELF = 1;
    public static final int FORMAT_PRX = 2;
    public static final int FORMAT_PBP = 4;
    public static final int FORMAT_SCE = 8;
    public static final int FORMAT_PSP = 16;

    public static Loader getInstance() {
        if (instance == null) {
            instance = new Loader();
        }
        return instance;
    }

    private Loader() {
    }

    public SceModule LoadModule(String pspfilename, ByteBuffer f, TPointer baseAddress, int mpidText, int mpidData, boolean analyzeOnly, boolean allocMem, boolean fromSyscall, boolean isSignChecked) throws IOException {
        SceModule module;
        block17: {
            int currentOffset;
            block16: {
                block15: {
                    module = new SceModule(false);
                    currentOffset = f.position();
                    module.fileFormat = 0;
                    module.pspfilename = pspfilename;
                    module.mpidtext = mpidText;
                    module.mpiddata = mpidData;
                    if (module.pspfilename != null && !module.pspfilename.contains(":")) {
                        module.pspfilename = "ms0:" + module.pspfilename;
                    }
                    if (f.capacity() - f.position() == 0) {
                        log.error((Object)"LoadModule: no data.");
                        return module;
                    }
                    f.position(currentOffset);
                    if (!this.LoadPBP(f, module, baseAddress, analyzeOnly, allocMem, fromSyscall)) break block15;
                    currentOffset = f.position();
                    if (currentOffset != f.limit()) break block16;
                    break block17;
                }
                if (!fromSyscall) {
                    this.loadPSF(module, analyzeOnly, allocMem, fromSyscall);
                }
            }
            if (module.psf != null) {
                log.info((Object)String.format("PBP meta data:%s%s", System.lineSeparator(), module.psf));
                if (!fromSyscall) {
                    if (module.psf.isLikelyHomebrew()) {
                        Emulator.getInstance().setFirmwareVersion(999);
                    } else {
                        Emulator.getInstance().setFirmwareVersion(module.psf.getString("PSP_SYSTEM_VER"));
                    }
                    Modules.SysMemUserForUserModule.setMemory64MB(module.psf.getNumeric("MEMSIZE") == 1);
                }
            }
            f.position(currentOffset);
            if (!this.LoadSPRX(f, module, baseAddress, analyzeOnly, allocMem, fromSyscall, isSignChecked)) {
                f.position(currentOffset);
                if (!this.LoadSCE(f, module, baseAddress, analyzeOnly, allocMem, fromSyscall, isSignChecked)) {
                    f.position(currentOffset);
                    if (!this.LoadPSP(f, module, baseAddress, analyzeOnly, allocMem, fromSyscall, isSignChecked)) {
                        f.position(currentOffset);
                        if (this.LoadELF(f, module, baseAddress, analyzeOnly, allocMem, fromSyscall)) {
                            if (!fromSyscall) {
                                Emulator.getInstance().setFirmwareVersion(999);
                            }
                        } else {
                            f.position(currentOffset);
                            this.LoadUNK(f, module, baseAddress, analyzeOnly, allocMem, fromSyscall);
                        }
                    }
                }
            }
        }
        if (!analyzeOnly) {
            this.patchModule(module);
        }
        if (analyzeOnly) {
            module.free();
        }
        return module;
    }

    private void loadPSF(SceModule module, boolean analyzeOnly, boolean allocMem, boolean fromSyscall) {
        File[] eboot;
        if (module.psf != null) {
            return;
        }
        String filetoload = module.pspfilename;
        if (filetoload.startsWith("ms0:")) {
            filetoload = filetoload.replace("ms0:", "ms0");
        }
        File metapbp = null;
        File pbpfile = new File(filetoload);
        if (pbpfile.getParentFile() == null || pbpfile.getParentFile().getParentFile() == null) {
            return;
        }
        File metadir = new File(pbpfile.getParentFile().getParentFile().getPath() + File.separatorChar + "%" + pbpfile.getParentFile().getName());
        if (metadir.exists() && (eboot = metadir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                return arg0.getName().equalsIgnoreCase("eboot.pbp");
            }
        })).length > 0) {
            metapbp = eboot[0];
        }
        if ((metadir = new File(pbpfile.getParentFile().getParentFile().getPath() + File.separatorChar + pbpfile.getParentFile().getName() + "%")).exists() && (eboot = metadir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                return arg0.getName().equalsIgnoreCase("eboot.pbp");
            }
        })).length > 0) {
            metapbp = eboot[0];
        }
        if (metapbp != null) {
            try {
                RandomAccessFile raf = new RandomAccessFile(metapbp, "r");
                FileChannel roChannel = raf.getChannel();
                MappedByteBuffer readbuffer = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)roChannel.size());
                PBP meta = new PBP(readbuffer);
                module.psf = meta.readPSF(readbuffer);
                raf.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            File[] psffile = pbpfile.getParentFile().listFiles(new FileFilter(){

                @Override
                public boolean accept(File arg0) {
                    return arg0.getName().equalsIgnoreCase("param.sfo");
                }
            });
            if (psffile != null && psffile.length > 0) {
                try {
                    RandomAccessFile raf = new RandomAccessFile(psffile[0], "r");
                    FileChannel roChannel = raf.getChannel();
                    MappedByteBuffer readbuffer = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)roChannel.size());
                    module.psf = new PSF();
                    module.psf.read(readbuffer);
                    raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean LoadPBP(ByteBuffer f, SceModule module, TPointer baseAddress, boolean analyzeOnly, boolean allocMem, boolean fromSyscall) throws IOException {
        PBP pbp = new PBP(f);
        if (pbp.isValid()) {
            module.fileFormat |= 4;
            if (pbp.getOffsetParam() > 0) {
                module.psf = pbp.readPSF(f);
            }
            if (Settings.getInstance().readBool("emu.pbpunpack")) {
                PBP.unpackPBP(f);
            }
            ElfHeaderInfo.PbpInfo = pbp.toString();
            f.position(pbp.getOffsetPspData());
            return true;
        }
        return false;
    }

    private boolean LoadSPRX(ByteBuffer f, SceModule module, TPointer baseAddress, boolean analyzeOnly, boolean allocMem, boolean fromSyscall, boolean isSignChecked) throws IOException {
        int magicPSP = Utilities.readWord(f);
        int magicEDAT = Utilities.readWord(f);
        if (magicPSP == 0x50535000 && magicEDAT == 0x54414445) {
            log.warn((Object)"Encrypted file detected! (.PSPEDAT)");
            f.position(144);
            this.LoadPSP(f.slice(), module, baseAddress, analyzeOnly, allocMem, fromSyscall, isSignChecked);
            return true;
        }
        return false;
    }

    private boolean LoadSCE(ByteBuffer f, SceModule module, TPointer baseAddress, boolean analyzeOnly, boolean allocMem, boolean fromSyscall, boolean isSignChecked) throws IOException {
        int magic = Utilities.readWord(f);
        if (magic == 1162040190) {
            int size = Utilities.readWord(f);
            f.position(f.position() + size - 8);
            return this.LoadPSP(f, module, baseAddress, analyzeOnly, allocMem, fromSyscall, isSignChecked);
        }
        return false;
    }

    private boolean LoadPSP(ByteBuffer f, SceModule module, TPointer baseAddress, boolean analyzeOnly, boolean allocMem, boolean fromSyscall, boolean isSignChecked) throws IOException {
        String updaterVer;
        PSP psp = new PSP(f);
        if (!psp.isValid()) {
            return false;
        }
        module.fileFormat |= 0x10;
        byte[] key = scePopsMan.readEbootKeys(module.pspfilename);
        if (module.psf != null && (updaterVer = module.psf.getString("UPDATER_VER")) != null) {
            Emulator.getInstance().setFirmwareVersion(updaterVer);
        }
        long start = System.currentTimeMillis();
        ByteBuffer decryptedPrx = psp.decrypt(f, isSignChecked, key);
        long end = System.currentTimeMillis();
        if (decryptedPrx == null) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Called crypto engine for PRX (duration=%d ms)", end - start));
        }
        return this.LoadELF(decryptedPrx, module, baseAddress, analyzeOnly, allocMem, fromSyscall);
    }

    private boolean LoadELF(ByteBuffer f, SceModule module, TPointer baseAddress, boolean analyzeOnly, boolean allocMem, boolean fromSyscall) throws IOException {
        int elfOffset = f.position();
        Elf32 elf = new Elf32(f);
        if (elf.getHeader().isValid()) {
            module.fileFormat |= 1;
            if (!elf.getHeader().isMIPSExecutable()) {
                log.error((Object)"Loader NOT a MIPS executable");
                return false;
            }
            if (elf.isKernelMode()) {
                module.mpidtext = 1;
                module.mpiddata = 1;
                if (!analyzeOnly && baseAddress.getAddress() == 0x8804000) {
                    baseAddress.setAddress(0x8000000 + Utilities.alignUp(ThreadManForUser.INTERNAL_THREAD_ADDRESS_SIZE, 255));
                }
            }
            if (elf.getHeader().isPRXDetected()) {
                log.debug((Object)"Loader: Relocation required (PRX)");
                module.fileFormat |= 2;
            } else if (elf.getHeader().requiresRelocation()) {
                log.info((Object)"Loader: Relocation required (ELF)");
            } else {
                if (baseAddress.getAddress() > 0x8900000) {
                    log.warn((Object)"Loader: Probably trying to load PBP ELF while another PBP ELF is already loaded");
                }
                baseAddress.setAddress(0);
            }
            module.baseAddress = baseAddress.getAddress();
            module.entry_addr = elf.getHeader().getE_entry() == -1 ? -1 : baseAddress.getAddress() + elf.getHeader().getE_entry();
            module.loadAddressLow = baseAddress.isNotNull() ? baseAddress.getAddress() : MemoryMap.END_USERSPACE;
            module.loadAddressHigh = baseAddress.getAddress();
            this.LoadELFProgram(f, module, baseAddress, elf, elfOffset, analyzeOnly);
            this.LoadELFSections(f, module, baseAddress, elf, elfOffset, analyzeOnly);
            if (module.loadAddressLow > module.loadAddressHigh) {
                log.error((Object)String.format("Incorrect ELF module address: loadAddressLow=0x%08X, loadAddressHigh=0x%08X", module.loadAddressLow, module.loadAddressHigh));
                module.loadAddressHigh = module.loadAddressLow;
            }
            if (!analyzeOnly) {
                if (elf.getHeader().requiresRelocation()) {
                    this.relocateFromHeaders(f, module, baseAddress, elf, elfOffset);
                }
                this.LoadELFModuleInfo(f, module, baseAddress, elf, elfOffset, analyzeOnly);
                if (allocMem) {
                    this.LoadELFReserveMemory(module);
                }
                this.LoadELFImports(module, baseAddress);
                this.LoadELFExports(module, baseAddress);
                Managers.modules.addModule(module);
                this.ProcessUnresolvedImports(module, baseAddress, fromSyscall);
                this.LoadELFDebuggerInfo(f, module, baseAddress, elf, elfOffset, fromSyscall);
                if (module.text_addr == 0) {
                    for (Elf32ProgramHeader phdr : elf.getProgramHeaderList()) {
                        if (module.text_addr != 0 && phdr.getP_vaddr() >= module.text_addr) continue;
                        module.text_addr = phdr.getP_vaddr();
                        if (phdr.getP_align() <= 0) continue;
                        module.text_addr = Utilities.alignDown(module.text_addr, phdr.getP_align() - 1);
                    }
                }
                if (baseAddress.getMemory() == Emulator.getMemory()) {
                    module.write(baseAddress.getMemory(), module.address);
                }
            } else {
                this.LoadELFModuleInfo(f, module, baseAddress, elf, elfOffset, analyzeOnly);
                if (elf.getHeader().requiresRelocation()) {
                    this.LoadSDKVersion(f, module, elf, elfOffset);
                }
            }
            return true;
        }
        log.debug((Object)"Loader: Not a ELF");
        return false;
    }

    private boolean LoadUNK(ByteBuffer f, SceModule module, TPointer baseAddress, boolean analyzeOnly, boolean allocMem, boolean fromSyscall) throws IOException {
        byte m0 = f.get();
        byte m1 = f.get();
        byte m2 = f.get();
        byte m3 = f.get();
        if (m0 == 67 && m1 == 73 && m2 == 83 && m3 == 79) {
            log.info((Object)"This is not an executable file!");
            log.info((Object)"Try using the Load UMD menu item");
        } else if (m0 == 0 && m1 == 80 && m2 == 83 && m3 == 70) {
            log.info((Object)"This is not an executable file!");
        } else {
            boolean handled = false;
            if (f.limit() >= 32774) {
                f.position(32768);
                byte[] id = new byte[6];
                f.get(id);
                if ((char)id[1] == 'C' && (char)id[2] == 'D' && (char)id[3] == '0' && (char)id[4] == '0' && (char)id[5] == '1') {
                    log.info((Object)"This is not an executable file!");
                    log.info((Object)"Try using the Load UMD menu item");
                    handled = true;
                }
            }
            if (!handled) {
                log.info((Object)"Unrecognized file format");
                log.info((Object)String.format("File magic %02X %02X %02X %02X", m0, m1, m2, m3));
                if (log.isDebugEnabled()) {
                    byte[] buffer = new byte[336];
                    buffer[0] = m0;
                    buffer[1] = m1;
                    buffer[2] = m2;
                    buffer[3] = m3;
                    f.get(buffer, 4, buffer.length - 4);
                    log.debug((Object)String.format("File header: %s", Utilities.getMemoryDump(buffer, 0, buffer.length)));
                }
            }
        }
        return false;
    }

    private void LoadELFProgram(ByteBuffer f, SceModule module, TPointer baseAddress, Elf32 elf, int elfOffset, boolean analyzeOnly) throws IOException {
        List<Elf32ProgramHeader> programHeaderList = elf.getProgramHeaderList();
        Memory mem = baseAddress.getMemory();
        module.text_size = 0;
        module.data_size = 0;
        module.bss_size = 0;
        int i = 0;
        for (Elf32ProgramHeader phdr : programHeaderList) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("ELF Program Header: %s", phdr.toString()));
            }
            if ((long)phdr.getP_type() == 1L) {
                int fileOffset = phdr.getP_offset();
                int memOffset = baseAddress.getAddress() + phdr.getP_vaddr();
                if (!Memory.isAddressGood(memOffset) && !Memory.isAddressGood(memOffset = phdr.getP_vaddr())) {
                    log.warn((Object)String.format("Program header has invalid memory offset 0x%08X!", memOffset));
                }
                int fileLen = phdr.getP_filesz();
                int memLen = phdr.getP_memsz();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("PH#%d: loading program 0x%08X-0x%08X", i, memOffset, memOffset + memLen));
                    log.debug((Object)String.format("PH#%d:\n%s", i, phdr));
                }
                f.position(elfOffset + fileOffset);
                if (f.position() + fileLen > f.limit()) {
                    int newLen = f.limit() - f.position();
                    log.warn((Object)String.format("PH#%d: program overflow clamping len %08X to %08X", i, fileLen, newLen));
                    fileLen = newLen;
                }
                if (!analyzeOnly) {
                    if (memLen > fileLen) {
                        mem.memset(memOffset + fileLen, (byte)0, memLen - fileLen);
                    }
                    if (((memOffset | fileLen | f.position()) & 3) == 0) {
                        ByteOrder order = f.order();
                        f.order(ByteOrder.LITTLE_ENDIAN);
                        IntBuffer intBuffer = f.asIntBuffer();
                        TPointer destAddr = new TPointer(baseAddress.getMemory(), memOffset);
                        if (RuntimeContext.hasMemoryInt(destAddr)) {
                            intBuffer.get(RuntimeContext.getMemoryInt(), (memOffset & 0x1FFFFFFF) >> 2, fileLen >> 2);
                        } else {
                            int[] buffer = new int[fileLen >> 2];
                            intBuffer.get(buffer);
                            Utilities.writeInt32(destAddr, fileLen, buffer, 0);
                        }
                        f.order(order);
                        f.position(f.position() + fileLen);
                    } else {
                        mem.copyToMemory(memOffset, f, fileLen);
                    }
                }
                if (memOffset < module.loadAddressLow) {
                    module.loadAddressLow = memOffset;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("PH#%d: new loadAddressLow %08X", i, module.loadAddressLow));
                    }
                }
                if (memOffset + memLen > module.loadAddressHigh) {
                    module.loadAddressHigh = memOffset + memLen;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("PH#%d: new loadAddressHigh %08X", i, module.loadAddressHigh));
                    }
                }
                module.segmentaddr[module.nsegment] = memOffset;
                module.segmentsize[module.nsegment] = memLen;
                ++module.nsegment;
                if ((phdr.getP_flags() & 1) != 0) {
                    module.text_size += fileLen;
                } else {
                    module.data_size += fileLen;
                }
                if (fileLen < memLen) {
                    module.bss_size += memLen - fileLen;
                }
            }
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("PH alloc consumption %08X (mem %08X)", module.loadAddressHigh - module.loadAddressLow, module.bss_size));
        }
    }

    private void LoadELFSections(ByteBuffer f, SceModule module, TPointer baseAddress, Elf32 elf, int elfOffset, boolean analyzeOnly) throws IOException {
        List<Elf32SectionHeader> sectionHeaderList = elf.getSectionHeaderList();
        Memory mem = baseAddress.getMemory();
        module.text_addr = baseAddress.getAddress();
        for (Elf32SectionHeader shdr : sectionHeaderList) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("ELF Section Header: %s", shdr.toString()));
            }
            int memOffset = shdr.getSh_addr(baseAddress);
            int len = shdr.getSh_size();
            int flags = shdr.getSh_flags();
            if (flags != 0 && Memory.isAddressGood(memOffset)) {
                boolean read = (flags & 2) != 0;
                boolean write = (flags & 1) != 0;
                boolean execute = (flags & 4) != 0;
                MemorySection memorySection = new MemorySection(memOffset, len, read, write, execute);
                MemorySections.getInstance().addMemorySection(memorySection);
            }
            if ((flags & 2) == 0) continue;
            switch (shdr.getSh_type()) {
                case 1: {
                    if (len == 0) {
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)String.format("%s: ignoring zero-length type 1 section %08X", shdr.getSh_namez(), memOffset));
                        break;
                    }
                    if (!Memory.isAddressGood(memOffset)) {
                        log.error((Object)String.format("Section header (type 1) has invalid memory offset 0x%08X!", memOffset));
                        break;
                    }
                    if (memOffset < module.loadAddressLow) {
                        log.warn((Object)String.format("%s: section allocates more than program %08X - %08X", shdr.getSh_namez(), memOffset, memOffset + len));
                        module.loadAddressLow = memOffset;
                    }
                    if (memOffset + len > module.loadAddressHigh) {
                        log.warn((Object)String.format("%s: section allocates more than program %08X - %08X", shdr.getSh_namez(), memOffset, memOffset + len));
                        module.loadAddressHigh = memOffset + len;
                    }
                    if ((flags & 1) != 0) {
                        if (!log.isTraceEnabled()) break;
                        log.trace((Object)String.format("Section Header as data, len=0x%08X, data_size=0x%08X", len, module.data_size));
                        break;
                    }
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)String.format("Section Header as text, len=0x%08X, text_size=0x%08X", len, module.text_size));
                    break;
                }
                case 8: {
                    if (len == 0) {
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)String.format("%s: ignoring zero-length type 8 section %08X", shdr.getSh_namez(), memOffset));
                        break;
                    }
                    if (!Memory.isAddressGood(memOffset)) {
                        log.error((Object)String.format("Section header (type 8) has invalid memory offset 0x%08X!", memOffset));
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("%s: clearing section %08X - %08X (len %08X)", shdr.getSh_namez(), memOffset, memOffset + len, len));
                    }
                    if (!analyzeOnly) {
                        mem.memset(memOffset, (byte)0, len);
                    }
                    if (memOffset < module.loadAddressLow) {
                        module.loadAddressLow = memOffset;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("%s: new loadAddressLow %08X (+%08X)", shdr.getSh_namez(), module.loadAddressLow, len));
                        }
                    }
                    if (memOffset + len <= module.loadAddressHigh) break;
                    module.loadAddressHigh = memOffset + len;
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)String.format("%s: new loadAddressHigh %08X (+%08X)", shdr.getSh_namez(), module.loadAddressHigh, len));
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Storing module info: text addr 0x%08X, text_size 0x%08X, data_size 0x%08X, bss_size 0x%08X", module.text_addr, module.text_size, module.data_size, module.bss_size));
        }
    }

    private void LoadELFReserveMemory(SceModule module) {
        int address;
        int size;
        int partition;
        SysMemUserForUser.SysMemInfo info;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Reserving 0x%X bytes at 0x%08X for module '%s'", module.loadAddressHigh - module.loadAddressLow, module.loadAddressLow, module.pspfilename));
        }
        if ((info = Modules.SysMemUserForUserModule.malloc(partition = module.mpidtext > 0 ? module.mpidtext : 2, module.modname, 2, size = module.loadAddressHigh - (address = module.loadAddressLow & 0xFFFFFF00), address)) == null || info.addr != (address & 0x1FFFFFFF)) {
            log.warn((Object)String.format("Failed to properly reserve memory consumed by module %s at address 0x%08X, size 0x%X: allocated %s", module.modname, address, size, info));
        }
        module.addAllocatedMemory(info);
    }

    private void LoadELFModuleInfo(ByteBuffer f, SceModule module, TPointer baseAddress, Elf32 elf, int elfOffset, boolean analyzeOnly) throws IOException {
        Elf32ProgramHeader phdr = elf.getProgramHeader(0);
        Elf32SectionHeader shdr = elf.getSectionHeader(".rodata.sceModuleInfo");
        int moduleInfoAddr = 0;
        int moduleInfoFileOffset = -1;
        if (!elf.getHeader().isPRXDetected() && shdr == null) {
            if (analyzeOnly) {
                moduleInfoFileOffset = phdr.getP_paddr() & 0x1FFFFFFF;
            } else {
                log.warn((Object)"ELF is not PRX, but has no section headers!");
                moduleInfoAddr = phdr.getP_vaddr() + (phdr.getP_paddr() & 0x1FFFFFFF) - phdr.getP_offset();
                log.warn((Object)("Manually locating ModuleInfo at address: 0x" + Integer.toHexString(moduleInfoAddr)));
            }
        } else if (elf.getHeader().isPRXDetected()) {
            if (analyzeOnly) {
                moduleInfoFileOffset = phdr.getP_paddr() & 0x1FFFFFFF;
            } else {
                moduleInfoAddr = baseAddress.getAddress() + (phdr.getP_paddr() & 0x1FFFFFFF) - phdr.getP_offset();
            }
        } else if (shdr != null) {
            moduleInfoAddr = shdr.getSh_addr(baseAddress);
        }
        if (moduleInfoAddr != 0) {
            PSPModuleInfo moduleInfo = new PSPModuleInfo();
            moduleInfo.read(baseAddress.getMemory(), moduleInfoAddr);
            module.copy(moduleInfo);
        } else if (moduleInfoFileOffset >= 0) {
            PSPModuleInfo moduleInfo = new PSPModuleInfo();
            f.position(moduleInfoFileOffset);
            moduleInfo.read(f);
            module.copy(moduleInfo);
        } else {
            log.error((Object)"ModuleInfo not found!");
            return;
        }
        if (!analyzeOnly) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Found ModuleInfo at 0x%08X, name:'%s', version: %04X, attr: 0x%08X, gp: 0x%08X", moduleInfoAddr, module.modname, module.version, module.attribute, module.gp_value));
            }
            if ((module.attribute & 0x1000) != 0) {
                log.debug((Object)"Kernel mode module detected");
            }
            if ((module.attribute & 0x800) != 0) {
                log.debug((Object)"VSH mode module detected");
            }
        }
    }

    private void relocateFromBuffer(ByteBuffer f, SceModule module, TPointer baseAddress, Elf32 elf, int RelCount, boolean pspRelocationFormat) throws IOException {
        Elf32Relocate rel = new Elf32Relocate();
        int AHL = 0;
        LinkedList<Integer> deferredHi16 = new LinkedList<Integer>();
        Memory mem = baseAddress.getMemory();
        for (int i = 0; i < RelCount; ++i) {
            int phBaseOffset;
            int phOffset;
            rel.read(f);
            int R_OFFSET = rel.getR_offset();
            int R_TYPE = rel.getR_info() & 0xFF;
            if (pspRelocationFormat) {
                int OFS_BASE = rel.getR_info() >> 8 & 0xFF;
                int ADDR_BASE = rel.getR_info() >> 16 & 0xFF;
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Relocation #%d type=%d, Offset PH#%d, Base Offset PH#%d, Offset 0x%08X", i, R_TYPE, OFS_BASE, ADDR_BASE, R_OFFSET));
                }
                phOffset = elf.getProgramHeader(OFS_BASE).getP_vaddr();
                phBaseOffset = elf.getProgramHeader(ADDR_BASE).getP_vaddr();
            } else {
                phOffset = 0;
                phBaseOffset = 0;
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Relocation #%d type=%d, Symbol 0x%06X, Offset 0x%08X", i, R_TYPE, rel.getR_info() >> 8, R_OFFSET));
                }
            }
            int data_addr = baseAddress.getAddress() + R_OFFSET + phOffset;
            int data = Utilities.readUnaligned32(mem, data_addr);
            long result = 0L;
            int word32 = data & 0xFFFFFFFF;
            int targ26 = data & 0x3FFFFFF;
            int hi16 = data & 0xFFFF;
            int lo16 = data & 0xFFFF;
            int A = 0;
            int S = baseAddress.getAddress() + phBaseOffset;
            switch (R_TYPE) {
                case 0: {
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)String.format("R_MIPS_NONE addr=0x%08X", data_addr));
                    break;
                }
                case 1: {
                    data = data & 0xFFFF0000 | data + S & 0xFFFF;
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)String.format("R_MIPS_16 addr=0x%08X before=0x%08X after=0x%08X", data_addr, word32, data));
                    break;
                }
                case 2: {
                    data += S;
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)String.format("R_MIPS_32 addr=0x%08X before=0x%08X after=0x%08X", data_addr, word32, data));
                    break;
                }
                case 4: {
                    A = targ26;
                    result = (A << 2) + S >> 2;
                    data &= 0xFC000000;
                    data |= (int)(result & 0x3FFFFFFL);
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)String.format("R_MIPS_26 addr=0x%08X before=0x%08X after=0x%08X", data_addr, word32, data));
                    break;
                }
                case 5: {
                    A = hi16;
                    AHL = A << 16;
                    deferredHi16.add(data_addr);
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)String.format("R_MIPS_HI16 addr=0x%08X", data_addr));
                    break;
                }
                case 6: {
                    A = lo16;
                    AHL &= 0xFFFF0000;
                    result = (AHL |= A & 0xFFFF) + S;
                    data &= 0xFFFF0000;
                    data = (int)((long)data | result & 0xFFFFL);
                    Iterator it = deferredHi16.iterator();
                    while (it.hasNext()) {
                        int data_addr2 = (Integer)it.next();
                        int data2 = Utilities.readUnaligned32(mem, data_addr2);
                        result = ((data2 & 0xFFFF) << 16) + A + S;
                        if ((A & 0x8000) != 0) {
                            result -= 65536L;
                        }
                        if ((result & 0x8000L) != 0L) {
                            result += 65536L;
                        }
                        data2 &= 0xFFFF0000;
                        data2 |= (int)(result >> 16 & 0xFFFFL);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("R_MIPS_HILO16 addr=0x%08X before=0x%08X after=0x%08X", data_addr2, Utilities.readUnaligned32(mem, data_addr2), data2));
                        }
                        Utilities.writeUnaligned32(mem, data_addr2, data2);
                        it.remove();
                    }
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)String.format("R_MIPS_LO16 addr=0x%08X before=0x%08X after=0x%08X", data_addr, word32, data));
                    break;
                }
                case 7: {
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)String.format("R_MIPS_GPREL16 addr=0x%08X before=0x%08X after=0x%08X", data_addr, word32, data));
                    break;
                }
                default: {
                    log.warn((Object)String.format("Unhandled relocation type %d at 0x%08X", R_TYPE, data_addr));
                }
            }
            Utilities.writeUnaligned32(mem, data_addr, data);
        }
    }

    private static String getRTypeName(int R_TYPE) {
        String[] names = new String[]{"R_MIPS_NONE", "R_MIPS_16", "R_MIPS_32", "R_MIPS_26", "R_MIPS_HI16", "R_MIPS_LO16", "R_MIPS_J26", "R_MIPS_JAL26"};
        if (R_TYPE < 0 || R_TYPE >= names.length) {
            return String.format("%d", R_TYPE);
        }
        return names[R_TYPE];
    }

    private void relocateFromBufferA1(ByteBuffer f, SceModule module, Elf32 elf, TPointer baseAddress, int programHeaderNumber, int size) throws IOException {
        Memory mem = baseAddress.getMemory();
        short R_OFFSET = 0;
        int R_BASE = 0;
        int OFS_BASE = 0;
        int lo16 = 0;
        int r = 0;
        int end = f.position() + size;
        Utilities.readUByte(f);
        Utilities.readUByte(f);
        int fbits = Utilities.readUByte(f);
        int flagShift = 0;
        int flagMask = (1 << fbits) - 1;
        int sbits = programHeaderNumber < 3 ? 1 : 2;
        int segmentShift = fbits;
        int segmentMask = (1 << sbits) - 1;
        int tbits = Utilities.readUByte(f);
        int typeShift = fbits + sbits;
        int typeMask = (1 << tbits) - 1;
        int[] flags = new int[Utilities.readUByte(f)];
        flags[0] = flags.length;
        for (int j = 1; j < flags.length; ++j) {
            flags[j] = Utilities.readUByte(f);
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)String.format("R_FLAG(%d bits) 0x%X -> 0x%X", fbits, j, flags[j]));
        }
        int[] types = new int[Utilities.readUByte(f)];
        types[0] = types.length;
        for (int j = 1; j < types.length; ++j) {
            types[j] = Utilities.readUByte(f);
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)String.format("R_TYPE(%d bits) 0x%X -> 0x%X", tbits, j, types[j]));
        }
        if ("flash0:/kd/loadcore.prx".equals(module.pspfilename) || "flash0:/kd/sysmem.prx".equals(module.pspfilename)) {
            int[] rebootTypeRemapping = new int[]{0, 3, 6, 7, 1, 2, 4, 5};
            for (int i = 1; i < types.length; ++i) {
                types[i] = rebootTypeRemapping[types[i]];
            }
        }
        int pos = f.position();
        int R_TYPE_OLD = types.length;
        while (pos < end) {
            int R_CMD = Utilities.readUHalf(f);
            pos += 2;
            int flagIndex = R_CMD >> flagShift & flagMask;
            int R_FLAG = flags[flagIndex];
            int S = R_CMD >> segmentShift & segmentMask;
            int typeIndex = R_CMD >> typeShift & typeMask;
            int R_TYPE = types[typeIndex];
            if ((R_FLAG & 1) == 0) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Relocation 0x%04X, R_FLAG=0x%02X(%d), S=%d, rest=0x%X", R_CMD, R_FLAG, flagIndex, S, R_CMD >> fbits + sbits));
                }
                OFS_BASE = S;
                if ((R_FLAG & 6) == 0) {
                    R_BASE = R_CMD >> fbits + sbits;
                    continue;
                }
                if ((R_FLAG & 6) == 4) {
                    R_BASE = Utilities.readUWord(f);
                    pos += 4;
                    continue;
                }
                log.warn((Object)"PH Relocation type 0x700000A1: Invalid size flag!");
                R_BASE = 0;
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Relocation 0x%04X, R_FLAG=0x%02X(%d), S=%d, %s(%d), rest=0x%X", R_CMD, R_FLAG, flagIndex, S, Loader.getRTypeName(R_TYPE), typeIndex, R_CMD >> fbits + tbits + sbits));
            }
            int ADDR_BASE = S;
            int phBaseOffset = baseAddress.getAddress() + elf.getProgramHeader(ADDR_BASE).getP_vaddr();
            if ((R_FLAG & 6) == 0) {
                R_OFFSET = (short)R_CMD;
                R_OFFSET = (short)(R_OFFSET >> fbits + tbits + sbits);
                R_BASE += R_OFFSET;
            } else if ((R_FLAG & 6) == 2) {
                R_OFFSET = (short)(R_CMD << 16 >> fbits + tbits + sbits);
                R_OFFSET = (short)(R_OFFSET & 0xFFFF0000);
                R_OFFSET = (short)(R_OFFSET | Utilities.readUHalf(f));
                pos += 2;
                R_BASE += R_OFFSET;
            } else if ((R_FLAG & 6) == 4) {
                R_BASE = Utilities.readUWord(f);
                pos += 4;
            } else {
                log.warn((Object)"PH Relocation type 0x700000A1: Invalid relocation size flag!");
            }
            if ((R_FLAG & 0x38) == 0) {
                lo16 = 0;
            } else if ((R_FLAG & 0x38) == 8) {
                if ((R_TYPE_OLD ^ 4) != 0) {
                    lo16 = 0;
                }
            } else if ((R_FLAG & 0x38) == 16) {
                lo16 = Utilities.readUHalf(f);
                lo16 = (short)lo16;
                pos += 2;
            } else if ((R_FLAG & 0x38) == 24) {
                log.warn((Object)"PH Relocation type 0x700000A1: Invalid lo16 setup!");
            } else {
                log.warn((Object)"PH Relocation type 0x700000A1: Invalid lo16 setup!");
            }
            int data_addr = R_BASE + baseAddress.getAddress() + elf.getProgramHeader(OFS_BASE).getP_vaddr();
            int data = Utilities.readUnaligned32(mem, data_addr);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Relocation #%d type=%d, Offset PH#%d, Base Offset PH#%d, Offset 0x%08X", r, R_TYPE, OFS_BASE, ADDR_BASE, (int)R_OFFSET));
            }
            int previousData = data;
            switch (R_TYPE) {
                case 0: {
                    break;
                }
                case 2: {
                    data += phBaseOffset;
                    break;
                }
                case 3: {
                    data = data & 0xFC000000 | (data & 0x3FFFFFF) + (phBaseOffset >>> 2) & 0x3FFFFFF;
                    break;
                }
                case 6: {
                    data = 0x8000000 | (data & 0x3FFFFFF) + (phBaseOffset >>> 2) & 0x3FFFFFF;
                    break;
                }
                case 7: {
                    data = 0xC000000 | (data & 0x3FFFFFF) + (phBaseOffset >>> 2) & 0x3FFFFFF;
                    break;
                }
                case 4: {
                    int hi16 = (data << 16) + lo16 + phBaseOffset;
                    if ((hi16 & 0x8000) == 32768) {
                        hi16 += 65536;
                    }
                    data = data & 0xFFFF0000 | hi16 >>> 16;
                    break;
                }
                case 1: 
                case 5: {
                    data = data & 0xFFFF0000 | (short)data + phBaseOffset & 0xFFFF;
                    break;
                }
            }
            if (previousData != data) {
                Utilities.writeUnaligned32(mem, data_addr, data);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Relocation at 0x%08X: 0x%08X -> 0x%08X", data_addr, previousData, data));
                }
            }
            ++r;
            R_TYPE_OLD = R_TYPE;
        }
    }

    private boolean mustRelocate(Elf32 elf, Elf32SectionHeader shdr) {
        Elf32SectionHeader relatedShdr;
        if (shdr.getSh_type() == 0x700000A0) {
            return true;
        }
        return shdr.getSh_type() == 9 && (relatedShdr = elf.getSectionHeader(shdr.getSh_info())) != null && relatedShdr.getSh_flags() != 0;
    }

    private void relocateFromHeaders(ByteBuffer f, SceModule module, TPointer baseAddress, Elf32 elf, int elfOffset) throws IOException {
        int i = 0;
        for (Elf32ProgramHeader phdr : elf.getProgramHeaderList()) {
            if (phdr.getP_type() == 0x700000A0) {
                int RelCount = phdr.getP_filesz() / Elf32Relocate.sizeof();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("PH#%d: relocating %d entries", i, RelCount));
                }
                f.position(elfOffset + phdr.getP_offset());
                this.relocateFromBuffer(f, module, baseAddress, elf, RelCount, true);
                return;
            }
            if (phdr.getP_type() == 1879048353) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Type 0x700000A1 PH#%d: relocating A1 entries, size=0x%X", i, phdr.getP_filesz()));
                }
                f.position(elfOffset + phdr.getP_offset());
                this.relocateFromBufferA1(f, module, elf, baseAddress, i, phdr.getP_filesz());
                return;
            }
            ++i;
        }
        for (Elf32SectionHeader shdr : elf.getSectionHeaderList()) {
            if (!this.mustRelocate(elf, shdr)) continue;
            int RelCount = shdr.getSh_size() / Elf32Relocate.sizeof();
            if (log.isDebugEnabled()) {
                log.debug((Object)(shdr.getSh_namez() + ": relocating " + RelCount + " entries"));
            }
            f.position(elfOffset + shdr.getSh_offset());
            this.relocateFromBuffer(f, module, baseAddress, elf, RelCount, shdr.getSh_type() != 9);
        }
    }

    private boolean isPopsLoader(SceModule module) throws IOException {
        if (module.pspfilename.endsWith("EBOOT.PBP") && ("complex".equals(module.modname) || "simple".equals(module.modname))) {
            for (DeferredStub deferredStub : module.unresolvedImports) {
                if (deferredStub.getNid() != 699661092 || !"scePopsMan".equals(deferredStub.getModuleName())) continue;
                return true;
            }
        }
        return false;
    }

    private void ProcessUnresolvedImports(SceModule sourceModule, TPointer baseAddress, boolean fromSyscall) throws IOException {
        Memory mem = baseAddress.getMemory();
        NIDMapper nidMapper = NIDMapper.getInstance();
        int numberoffailedNIDS = 0;
        int numberofmappedNIDS = 0;
        if (this.isPopsLoader(sourceModule)) {
            Modules.scePopsManModule.loadOnDemand(sourceModule);
        }
        for (SceModule module : Managers.modules.values()) {
            ++module.importFixupAttempts;
            Iterator<DeferredStub> it = module.unresolvedImports.iterator();
            while (it.hasNext()) {
                DeferredStub deferredStub = it.next();
                String moduleName = deferredStub.getModuleName();
                int nid = deferredStub.getNid();
                int importAddress = deferredStub.getImportAddress();
                int exportAddress = nidMapper.getAddressByNid(nid, moduleName);
                if (exportAddress != 0) {
                    deferredStub.resolve(mem, exportAddress);
                    it.remove();
                    sourceModule.resolvedImports.add(deferredStub);
                    ++numberofmappedNIDS;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Mapped import at 0x%08X to export at 0x%08X [0x%08X] (attempt %d)", importAddress, exportAddress, nid, module.importFixupAttempts));
                    continue;
                }
                if (nid == 0) {
                    log.warn((Object)String.format("Ignoring import at 0x%08X [0x%08X] (attempt %d)", importAddress, nid, module.importFixupAttempts));
                    it.remove();
                    mem.write32(importAddress + 4, 4129);
                    continue;
                }
                int code = nidMapper.getSyscallByNid(nid, moduleName);
                if (code >= 0) {
                    int returnInstruction = 65011720;
                    int syscallInstruction = 0xC | (code & 0xFFFFF) << 6;
                    if (mem.read32(importAddress) == 0) {
                        mem.write32(importAddress, returnInstruction);
                    }
                    mem.write32(importAddress + 4, syscallInstruction);
                    it.remove();
                    ++numberofmappedNIDS;
                    if (!fromSyscall || !log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Mapped import at 0x%08X to syscall 0x%05X [0x%08X] (attempt %d)", importAddress, code, nid, module.importFixupAttempts));
                    continue;
                }
                if (nidMapper.isHideAllSyscalls()) continue;
                log.warn((Object)String.format("Failed to map import at 0x%08X [0x%08X] Module '%s'(attempt %d)", importAddress, nid, moduleName, module.importFixupAttempts));
                ++numberoffailedNIDS;
            }
        }
        log.info((Object)(numberofmappedNIDS + " NIDS mapped"));
        if (numberoffailedNIDS > 0) {
            log.info((Object)(numberoffailedNIDS + " remaining unmapped NIDS"));
        }
    }

    private void LoadELFImports(SceModule module, TPointer baseAddress) throws IOException {
        Memory mem = baseAddress.getMemory();
        int stubHeadersAddress = module.stub_top;
        int stubHeadersEndAddress = module.stub_top + module.stub_size;
        int i = 0;
        while (stubHeadersAddress < stubHeadersEndAddress) {
            Elf32StubHeader stubHeader = new Elf32StubHeader(mem, stubHeadersAddress);
            if (stubHeader.getSize() <= 0) {
                log.warn((Object)("Skipping dummy entry with size " + stubHeader.getSize()));
                stubHeadersAddress += Elf32StubHeader.sizeof() / 2;
            } else {
                String moduleName = Memory.isAddressGood(stubHeader.getOffsetModuleName()) ? Utilities.readStringNZ(stubHeader.getOffsetModuleName(), 64) : module.modname;
                stubHeader.setModuleNamez(moduleName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Processing Import #%d: %s", i, stubHeader.toString()));
                }
                if (stubHeader.hasVStub()) {
                    int vStub;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("'%s': Header with VStub has size %d: %s", stubHeader.getModuleNamez(), stubHeader.getSize(), Utilities.getMemoryDump(stubHeadersAddress, stubHeader.getSize() * 4, 4, 16)));
                    }
                    if ((vStub = stubHeader.getVStub()) != 0) {
                        int vStubSize = stubHeader.getVStubSize();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("VStub has size %d: %s", vStubSize, Utilities.getMemoryDump(vStub, vStubSize * 8, 4, 16)));
                        }
                        IMemoryReader vstubReader = MemoryReader.getMemoryReader(mem, vStub, vStubSize * 8, 4);
                        for (int j = 0; j < vStubSize; ++j) {
                            int reloc;
                            int relocAddr = vstubReader.readNext();
                            int nid = vstubReader.readNext();
                            IMemoryReader relocReader = MemoryReader.getMemoryReader(mem, relocAddr, 4);
                            while ((reloc = relocReader.readNext()) != 0) {
                                int opcode = reloc >>> 26;
                                int address = (reloc & 0x3FFFFFF) << 2;
                                DeferredStub deferredStub = null;
                                switch (opcode) {
                                    case 5: {
                                        deferredStub = new DeferredVStubHI16(module, stubHeader.getModuleNamez(), address, nid);
                                        break;
                                    }
                                    case 6: {
                                        deferredStub = new DeferredVstubLO16(module, stubHeader.getModuleNamez(), address, nid);
                                        break;
                                    }
                                    case 2: {
                                        deferredStub = new DeferredVStub32(module, stubHeader.getModuleNamez(), address, nid);
                                        break;
                                    }
                                    default: {
                                        log.warn((Object)String.format("Unknown Vstub relocation nid 0x%08X, reloc=0x%08X", nid, reloc));
                                    }
                                }
                                if (deferredStub == null) continue;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)String.format("Vstub reloc %s", deferredStub));
                                }
                                module.unresolvedImports.add(deferredStub);
                            }
                        }
                    }
                }
                stubHeadersAddress += stubHeader.getSize() * 4;
                if (!Memory.isAddressGood(stubHeader.getOffsetNid()) || !Memory.isAddressGood(stubHeader.getOffsetText())) {
                    log.warn((Object)String.format("Incorrect s_nid or s_text address in StubHeader #%d: %s", i, stubHeader.toString()));
                } else {
                    IMemoryReader nidReader = MemoryReader.getMemoryReader(mem, stubHeader.getOffsetNid(), stubHeader.getImports() * 4, 4);
                    for (int j = 0; j < stubHeader.getImports(); ++j) {
                        int nid = nidReader.readNext();
                        int importAddress = stubHeader.getOffsetText() + j * 8;
                        DeferredStub deferredStub = new DeferredStub(module, stubHeader.getModuleNamez(), importAddress, nid);
                        deferredStub.unresolve(mem);
                    }
                }
            }
            ++i;
        }
        if (module.unresolvedImports.size() > 0 && log.isInfoEnabled()) {
            log.info((Object)String.format("Found %d unresolved imports", module.unresolvedImports.size()));
        }
    }

    private int getOffsetFromRelocation(ByteBuffer f, Elf32 elf, int elfOffset, int relocationOffset, int relocationSize, int position) throws IOException {
        int relocationCount = relocationSize / Elf32Relocate.sizeof();
        f.position(elfOffset + relocationOffset);
        Elf32Relocate rel = new Elf32Relocate();
        for (int i = 0; i < relocationCount; ++i) {
            rel.read(f);
            int R_TYPE = rel.getR_info() & 0xFF;
            if (R_TYPE != 2) continue;
            int OFS_BASE = rel.getR_info() >> 8 & 0xFF;
            int ADDR_BASE = rel.getR_info() >> 16 & 0xFF;
            int relocationPosition = rel.getR_offset() + elf.getProgramHeader(OFS_BASE).getP_vaddr();
            if (relocationPosition != position) continue;
            return elf.getProgramHeader(ADDR_BASE).getP_offset();
        }
        return -1;
    }

    private int getOffsetFromRelocationA1(ByteBuffer f, SceModule module, Elf32 elf, int elfOffset, int programHeaderNumber, int relocationOffset, int relocationSize, int position) throws IOException {
        short R_OFFSET = 0;
        int R_BASE = 0;
        int pos = elfOffset + relocationOffset;
        int end = pos + relocationSize;
        f.position(pos + 2);
        int fbits = Utilities.readUByte(f);
        int flagShift = 0;
        int flagMask = (1 << fbits) - 1;
        int sbits = programHeaderNumber < 3 ? 1 : 2;
        int segmentShift = fbits;
        int segmentMask = (1 << sbits) - 1;
        int tbits = Utilities.readUByte(f);
        int typeShift = fbits + sbits;
        int typeMask = (1 << tbits) - 1;
        int[] flags = new int[Utilities.readUByte(f)];
        flags[0] = flags.length;
        for (int j = 1; j < flags.length; ++j) {
            flags[j] = Utilities.readUByte(f);
        }
        int[] types = new int[Utilities.readUByte(f)];
        types[0] = types.length;
        for (int j = 1; j < types.length; ++j) {
            types[j] = Utilities.readUByte(f);
        }
        if ("flash0:/kd/loadcore.prx".equals(module.pspfilename) || "flash0:/kd/sysmem.prx".equals(module.pspfilename)) {
            int[] rebootTypeRemapping = new int[]{0, 3, 6, 7, 1, 2, 4, 5};
            for (int i = 1; i < types.length; ++i) {
                types[i] = rebootTypeRemapping[types[i]];
            }
        }
        pos = f.position();
        while (pos < end) {
            int R_CMD = Utilities.readUHalf(f);
            pos += 2;
            int flagIndex = R_CMD >> flagShift & flagMask;
            int R_FLAG = flags[flagIndex];
            int S = R_CMD >> segmentShift & segmentMask;
            int typeIndex = R_CMD >> typeShift & typeMask;
            int R_TYPE = types[typeIndex];
            if ((R_FLAG & 1) == 0) {
                if ((R_FLAG & 6) == 0) {
                    R_BASE = R_CMD >> fbits + sbits;
                    continue;
                }
                if ((R_FLAG & 6) == 4) {
                    R_BASE = Utilities.readUWord(f);
                    pos += 4;
                    continue;
                }
                R_BASE = 0;
                continue;
            }
            int ADDR_BASE = S;
            if ((R_FLAG & 6) == 0) {
                R_OFFSET = (short)R_CMD;
                R_OFFSET = (short)(R_OFFSET >> fbits + tbits + sbits);
                R_BASE += R_OFFSET;
            } else if ((R_FLAG & 6) == 2) {
                R_OFFSET = (short)(R_CMD << 16 >> fbits + tbits + sbits);
                R_OFFSET = (short)(R_OFFSET & 0xFFFF0000);
                R_OFFSET = (short)(R_OFFSET | Utilities.readUHalf(f));
                pos += 2;
                R_BASE += R_OFFSET;
            } else if ((R_FLAG & 6) == 4) {
                R_BASE = Utilities.readUWord(f);
                pos += 4;
            }
            if ((R_FLAG & 0x38) == 16) {
                Utilities.readUHalf(f);
                pos += 2;
            }
            if (R_TYPE != 2 || R_BASE != position) continue;
            return elf.getProgramHeader(ADDR_BASE).getP_offset();
        }
        return -1;
    }

    private int getOffsetFromRelocation(ByteBuffer f, SceModule module, Elf32 elf, int elfOffset, int position) throws IOException {
        int offset;
        int i = 0;
        for (Elf32ProgramHeader phdr : elf.getProgramHeaderList()) {
            if (phdr.getP_type() == 0x700000A0 ? (offset = this.getOffsetFromRelocation(f, elf, elfOffset, phdr.getP_offset(), phdr.getP_filesz(), position)) >= 0 : phdr.getP_type() == 1879048353 && (offset = this.getOffsetFromRelocationA1(f, module, elf, elfOffset, i, phdr.getP_offset(), phdr.getP_filesz(), position)) >= 0) {
                return offset;
            }
            ++i;
        }
        for (Elf32SectionHeader shdr : elf.getSectionHeaderList()) {
            if (shdr.getSh_type() != 0x700000A0 || (offset = this.getOffsetFromRelocation(f, elf, elfOffset, shdr.getSh_offset(), shdr.getSh_size(), position)) < 0) continue;
            return offset;
        }
        return 0;
    }

    private void LoadSDKVersion(ByteBuffer f, SceModule module, Elf32 elf, int elfOffset) throws IOException {
        int entHeadersOffset = elfOffset + elf.getProgramHeader(0).getP_offset();
        int entHeadersAddress = module.ent_top;
        int entHeadersEndAddress = module.ent_top + module.ent_size;
        while (entHeadersAddress < entHeadersEndAddress) {
            int j;
            f.position(entHeadersOffset + entHeadersAddress);
            Elf32EntHeader entHeader = new Elf32EntHeader(f);
            entHeadersAddress = entHeader.getSize() <= 0 ? (entHeadersAddress += Elf32EntHeader.sizeof() / 2) : (entHeader.getSize() > 4 ? (entHeadersAddress += entHeader.getSize() * 4) : (entHeadersAddress += Elf32EntHeader.sizeof()));
            int functionCount = entHeader.getFunctionCount();
            int variableCount = entHeader.getVariableCount();
            int nidAddr = entHeader.getOffsetResident();
            int exportAddr = nidAddr + (functionCount + variableCount) * 4;
            int variableTableAddr = exportAddr + functionCount * 4;
            int[] variableNids = new int[variableCount];
            f.position(entHeadersOffset + nidAddr + functionCount * 4);
            for (int j2 = 0; j2 < variableCount; ++j2) {
                variableNids[j2] = Utilities.readUWord(f);
            }
            int[] variableTable = new int[variableCount];
            for (j = 0; j < variableCount; ++j) {
                int pos = variableTableAddr + j * 4;
                int offset = this.getOffsetFromRelocation(f, module, elf, elfOffset, pos);
                f.position(entHeadersOffset + pos);
                variableTable[j] = Utilities.readUWord(f) + offset;
            }
            block6: for (j = 0; j < variableCount; ++j) {
                switch (variableNids[j]) {
                    case 297366790: {
                        f.position(elfOffset + variableTable[j]);
                        module.moduleVersion = Utilities.readUWord(f);
                        if (!log.isDebugEnabled()) continue block6;
                        log.debug((Object)String.format("Found sdkVersion=0x%08X", module.moduleVersion));
                    }
                }
            }
        }
    }

    private void LoadELFExports(SceModule module, TPointer baseAddress) throws IOException {
        NIDMapper nidMapper = NIDMapper.getInstance();
        Memory mem = baseAddress.getMemory();
        int entHeadersAddress = module.ent_top;
        int entHeadersEndAddress = module.ent_top + module.ent_size;
        int entCount = 0;
        int i = 0;
        while (entHeadersAddress < entHeadersEndAddress) {
            Elf32EntHeader entHeader = new Elf32EntHeader(mem, entHeadersAddress);
            if (entHeader.getSize() <= 0) {
                log.warn((Object)("Skipping dummy entry with size " + entHeader.getSize()));
                entHeadersAddress += Elf32EntHeader.sizeof() / 2;
            } else {
                int exportAddress;
                int j;
                String moduleName = Memory.isAddressGood(entHeader.getOffsetModuleName()) ? Utilities.readStringNZ(entHeader.getOffsetModuleName(), 64) : module.modname;
                entHeader.setModuleNamez(moduleName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Processing header #%d at 0x%08X: %s", i, entHeadersAddress, entHeader.toString()));
                }
                if (entHeader.getSize() > 4) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("'%s': Header has size %d: %s", entHeader.getModuleNamez(), entHeader.getSize(), Utilities.getMemoryDump(entHeadersAddress, entHeader.getSize() * 4, 4, 16)));
                    }
                    entHeadersAddress += entHeader.getSize() * 4;
                } else {
                    entHeadersAddress += Elf32EntHeader.sizeof();
                }
                int functionCount = entHeader.getFunctionCount();
                int variableCount = entHeader.getVariableCount();
                int nidAddr = entHeader.getOffsetResident();
                IMemoryReader nidReader = MemoryReader.getMemoryReader(mem, nidAddr, (functionCount + variableCount) * 4, 4);
                int exportAddr = nidAddr + (functionCount + variableCount) * 4;
                IMemoryReader exportReader = MemoryReader.getMemoryReader(mem, exportAddr, functionCount * 4, 4);
                if ((entHeader.getAttr() & 0x8000) == 0) {
                    for (j = 0; j < functionCount; ++j) {
                        int nid = nidReader.readNext();
                        exportAddress = exportReader.readNext();
                        if ((!Memory.isAddressGood(exportAddress) || (entHeader.getAttr() & 0x4000) == 16384) && !module.pspfilename.startsWith("ms0:") && !module.pspfilename.startsWith("disc0:/PSP_GAME/SYSDIR/EBOOT.") && !module.pspfilename.startsWith("flash0:")) continue;
                        nidMapper.addModuleNid(module, moduleName, nid, exportAddress, false);
                        ++entCount;
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)String.format("Export found at 0x%08X [0x%08X]", exportAddress, nid));
                    }
                } else {
                    block16: for (j = 0; j < functionCount; ++j) {
                        int nid = nidReader.readNext();
                        exportAddress = exportReader.readNext();
                        switch (nid) {
                            case -701322021: {
                                module.module_start_func = exportAddress;
                                if (!log.isDebugEnabled()) continue block16;
                                log.debug((Object)String.format("module_start found: nid=0x%08X, function=0x%08X", nid, exportAddress));
                                continue block16;
                            }
                            case -823633604: {
                                module.module_stop_func = exportAddress;
                                if (!log.isDebugEnabled()) continue block16;
                                log.debug((Object)String.format("module_stop found: nid=0x%08X, function=0x%08X", nid, exportAddress));
                                continue block16;
                            }
                            case 788942758: {
                                module.module_reboot_before_func = exportAddress;
                                if (!log.isDebugEnabled()) continue block16;
                                log.debug((Object)String.format("module_reboot_before found: nid=0x%08X, function=0x%08X", nid, exportAddress));
                                continue block16;
                            }
                            case -1376704699: {
                                module.module_reboot_phase_func = exportAddress;
                                if (!log.isDebugEnabled()) continue block16;
                                log.debug((Object)String.format("module_reboot_phase found: nid=0x%08X, function=0x%08X", nid, exportAddress));
                                continue block16;
                            }
                            case -747353120: {
                                module.module_bootstart_func = exportAddress;
                                if (!log.isDebugEnabled()) continue block16;
                                log.debug((Object)String.format("module_bootstart found: nid=0x%08X, function=0x%08X", nid, exportAddress));
                                continue block16;
                            }
                            default: {
                                if (!Memory.isAddressGood(exportAddress) || (entHeader.getAttr() & 0x4000) == 16384) continue block16;
                                nidMapper.addModuleNid(module, moduleName, nid, exportAddress, false);
                                ++entCount;
                                if (!log.isDebugEnabled()) continue block16;
                                log.debug((Object)String.format("Export found at 0x%08X [0x%08X]", exportAddress, nid));
                            }
                        }
                    }
                }
                int variableTableAddr = exportAddr + functionCount * 4;
                IMemoryReader variableReader = MemoryReader.getMemoryReader(mem, variableTableAddr, variableCount * 4, 4);
                block17: for (int j2 = 0; j2 < variableCount; ++j2) {
                    int nid = nidReader.readNext();
                    int variableAddr = variableReader.readNext();
                    switch (nid) {
                        case -266505305: {
                            if (!log.isDebugEnabled()) continue block17;
                            log.debug((Object)String.format("module_info found: nid=0x%08X, addr=0x%08X", nid, variableAddr));
                            continue block17;
                        }
                        case 259794796: {
                            module.module_start_thread_priority = mem.read32(variableAddr + 4);
                            module.module_start_thread_stacksize = mem.read32(variableAddr + 8);
                            module.module_start_thread_attr = mem.read32(variableAddr + 12);
                            if (!log.isDebugEnabled()) continue block17;
                            log.debug((Object)String.format("module_start_thread_parameter found: nid=0x%08X, priority=%d, stacksize=%d, attr=0x%08X", nid, module.module_start_thread_priority, module.module_start_thread_stacksize, module.module_start_thread_attr));
                            continue block17;
                        }
                        case -821246313: {
                            module.module_stop_thread_priority = mem.read32(variableAddr + 4);
                            module.module_stop_thread_stacksize = mem.read32(variableAddr + 8);
                            module.module_stop_thread_attr = mem.read32(variableAddr + 12);
                            if (!log.isDebugEnabled()) continue block17;
                            log.debug((Object)String.format("module_stop_thread_parameter found: nid=0x%08X, priority=%d, stacksize=%d, attr=0x%08X", nid, module.module_stop_thread_priority, module.module_stop_thread_stacksize, module.module_stop_thread_attr));
                            continue block17;
                        }
                        case -185325155: {
                            module.module_reboot_before_thread_priority = mem.read32(variableAddr + 4);
                            module.module_reboot_before_thread_stacksize = mem.read32(variableAddr + 8);
                            module.module_reboot_before_thread_attr = mem.read32(variableAddr + 12);
                            if (!log.isDebugEnabled()) continue block17;
                            log.debug((Object)String.format("module_reboot_before_thread_parameter found: nid=0x%08X, priority=%d, stacksize=%d, attr=0x%08X", nid, module.module_reboot_before_thread_priority, module.module_reboot_before_thread_stacksize, module.module_reboot_before_thread_attr));
                            continue block17;
                        }
                        case 297366790: {
                            module.moduleVersion = mem.read32(variableAddr);
                            if (!log.isDebugEnabled()) continue block17;
                            log.debug((Object)String.format("module_sdk_version found: nid=0x%08X, sdkVersion=0x%08X", nid, module.moduleVersion));
                            continue block17;
                        }
                        default: {
                            if (Memory.isAddressGood(variableAddr) && (entHeader.getAttr() & 0x4000) != 16384) {
                                nidMapper.addModuleNid(module, moduleName, nid, variableAddr, true);
                                ++entCount;
                                if (!log.isDebugEnabled()) continue block17;
                                log.debug((Object)String.format("Export found at 0x%08X [0x%08X]", variableAddr, nid));
                                continue block17;
                            }
                            log.warn((Object)String.format("Unknown variable entry found: nid=0x%08X, addr=0x%08X", nid, variableAddr));
                        }
                    }
                }
            }
            ++i;
        }
        if (entCount > 0 && log.isInfoEnabled()) {
            log.info((Object)String.format("Found %d exports", entCount));
        }
    }

    private void LoadELFDebuggerInfo(ByteBuffer f, SceModule module, TPointer baseAddress, Elf32 elf, int elfOffset, boolean fromSyscall) throws IOException {
        Elf32SectionHeader shdr = elf.getSectionHeader(".init");
        if (shdr != null) {
            module.initsection[0] = shdr.getSh_addr(baseAddress);
            module.initsection[1] = shdr.getSh_size();
        }
        if ((shdr = elf.getSectionHeader(".fini")) != null) {
            module.finisection[0] = shdr.getSh_addr(baseAddress);
            module.finisection[1] = shdr.getSh_size();
        }
        if ((shdr = elf.getSectionHeader(".sceStub.text")) != null) {
            module.stubtextsection[0] = shdr.getSh_addr(baseAddress);
            module.stubtextsection[1] = shdr.getSh_size();
        }
        if (!fromSyscall) {
            ElfHeaderInfo.ElfInfo = elf.getElfInfo();
            ElfHeaderInfo.ProgInfo = elf.getProgInfo();
            ElfHeaderInfo.SectInfo = elf.getSectInfo();
        }
    }

    private void patchModule(SceModule module) {
        Memory mem = Emulator.getMemory();
        if ("vsh_module".equals(module.modname)) {
            Utilities.patch(mem, module, 74416, 1348468960, HLEUtilities.NOP());
            Utilities.patch(mem, module, 73816, 339738683, HLEUtilities.NOP());
            Utilities.patch(mem, module, 73824, 339738681, HLEUtilities.NOP());
        }
        if ("sceNpCommerce2".equals(module.modname)) {
            Utilities.patch(mem, module, 42392, 115, 0);
            Utilities.patch(mem, module, 14944, 604438971, 604438608);
        }
        if ("sceNpCore".equals(module.modname)) {
            Utilities.patchRemoveStringChar(mem, module, 3408, 115);
        }
        if ("sceNpService".equals(module.modname)) {
            Utilities.patch(mem, module, 67420, 115, 0);
        }
        if ("sceVshNpInstaller_Module".equals(module.modname)) {
            Utilities.patchRemoveStringChar(mem, module, 94096, 115);
            Utilities.patchRemoveStringChar(mem, module, 94144, 115);
            Utilities.patchRemoveStringChar(mem, module, 94192, 115);
            Utilities.patchRemoveStringChar(mem, module, 94240, 115);
            Utilities.patchRemoveStringChar(mem, module, 94308, 115);
        }
        if ("marlindownloader".equals(module.modname)) {
            Utilities.patchRemoveStringChar(mem, module, 18120, 115);
        }
        if ("sceVshStoreBrowser_Module".equals(module.modname)) {
            Utilities.patchRemoveStringChar(mem, module, 369220, 115);
            Utilities.patchRemoveStringChar(mem, module, 369368, 115);
        }
        if ("sceGameUpdate_Library".equals(module.modname)) {
            Utilities.patchRemoveStringChar(mem, module, 12484, 115);
        }
        if ("sceMemlmd".equals(module.modname)) {
            Utilities.patch(mem, module, 6124, 0xE000000, HLEUtilities.MOVE(2, 0), -33554432);
            SysMemUserForUser.SysMemInfo dummyArea = Modules.SysMemUserForUserModule.malloc(1, "patch-sceMemlmd", 0, 256, 0);
            Utilities.patch(mem, module, 9408, -1077935584, dummyArea.addr);
            Utilities.patch(mem, module, 9428, -1077935488, dummyArea.addr);
            Utilities.patch(mem, module, 9432, -1077933568, dummyArea.addr);
            Utilities.patch(mem, module, 9436, -1077935296, dummyArea.addr);
            Utilities.patch(mem, module, 7420, 666763232, HLEUtilities.JR());
            Utilities.patch(mem, module, 7424, 1006764032, HLEUtilities.MOVE(2, 0), -65536);
            Utilities.patch(mem, module, 5140, 4460587, HLEUtilities.ADDIU(2, 0, 1));
            Utilities.patch(mem, module, 4824, -1874657280, HLEUtilities.ADDIU(3, 0, 1));
            Utilities.patch(mem, module, 4900, -1874460672, HLEUtilities.ADDIU(6, 0, 0));
        }
        if ("sceModuleManager".equals(module.modname)) {
            Utilities.patch(mem, module, 12492, 604176416, 604176400);
        }
        if ("sceLoaderCore".equals(module.modname)) {
            Utilities.patch(mem, module, 18076, 364969888, HLEUtilities.NOP());
            Utilities.patch(mem, module, 17736, 2081382980, HLEUtilities.NOP());
            Utilities.patch(mem, module, 17744, 350224428, 268435500);
            Utilities.patch(mem, module, 15704, 281083838, HLEUtilities.NOP());
        }
        Modules.scePopsManModule.patchModule(mem, module);
    }

    static {
        log = Logger.getLogger((String)"loader");
    }
}

