/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler.nativeCode;

import jpcsp.Allegrex.compiler.nativeCode.AbstractNativeCodeSequence;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.sound.Utils;

public class SoundMix
extends AbstractNativeCodeSequence {
    public static void mixStereoInMemory(int inAddrReg, int inOutAddrReg, int countReg, int leftVolumeFReg, int rightVolumeFReg) {
        int inAddr = SoundMix.getRegisterValue(inAddrReg);
        int inOutAddr = SoundMix.getRegisterValue(inOutAddrReg);
        int count = SoundMix.getRegisterValue(countReg);
        float inLeftVolume = SoundMix.getFRegisterValue(leftVolumeFReg);
        float inRightVolume = SoundMix.getFRegisterValue(rightVolumeFReg);
        Utils.mixStereoInMemory(inAddr, inOutAddr, count, inLeftVolume, inRightVolume);
    }

    public static void mixStereoInMemory(int inAddrReg, int inOutAddrReg, int countReg, int maxCountAddrReg, int leftVolumeFReg, int rightVolumeFReg) {
        int inAddr = SoundMix.getRegisterValue(inAddrReg);
        int inOutAddr = SoundMix.getRegisterValue(inOutAddrReg);
        int count = SoundMix.getRegisterValue(countReg);
        int maxCount = SoundMix.read32(SoundMix.getRegisterValue(maxCountAddrReg));
        float inLeftVolume = SoundMix.getFRegisterValue(leftVolumeFReg);
        float inRightVolume = SoundMix.getFRegisterValue(rightVolumeFReg);
        Utils.mixStereoInMemory(inAddr, inOutAddr, maxCount - count, inLeftVolume, inRightVolume);
    }

    public static void mixMonoToStereo(int leftChannelAddrReg, int rightChannelAddrReg, int stereoChannelAddrReg, int lengthReg, int lengthStep) {
        int leftChannelAddr = SoundMix.getRegisterValue(leftChannelAddrReg);
        int rightChannelAddr = SoundMix.getRegisterValue(rightChannelAddrReg);
        int stereoChannelAddr = SoundMix.getRegisterValue(stereoChannelAddrReg);
        int length = SoundMix.getRegisterValue(lengthReg) * lengthStep;
        IMemoryReader leftChannelReader = SoundMix.getMemoryReader(leftChannelAddr, length, 2);
        IMemoryReader rightChannelReader = SoundMix.getMemoryReader(rightChannelAddr, length, 2);
        IMemoryWriter stereoChannelWriter = SoundMix.getMemoryWriter(stereoChannelAddr, length << 1, 2);
        for (int i = 0; i < length; i += 2) {
            int left = leftChannelReader.readNext();
            int right = rightChannelReader.readNext();
            stereoChannelWriter.writeNext(left);
            stereoChannelWriter.writeNext(right);
        }
        stereoChannelWriter.flush();
    }
}

