/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.IOException;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.State;
import jpcsp.filesystems.umdiso.ISectorDevice;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.scheduler.Scheduler;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceUmdMan
extends HLEModule {
    public static Logger log = Modules.getLogger("sceUmdMan");
    protected SysMemUserForUser.SysMemInfo dummyAreaInfo;
    protected TPointer dummyArea;
    protected SysMemUserForUser.SysMemInfo dummyUmdDriveInfo;
    protected TPointer dummyUmdDrive;

    protected ISectorDevice getSectorDevice() {
        UmdIsoReader iso = Modules.sceUmdUserModule.getIsoReader();
        if (iso == null) {
            return null;
        }
        return iso.getSectorDevice();
    }

    @HLEUnimplemented
    @HLEFunction(nid=1709356000, version=660)
    public int sceUmdMan_65E2B3E0() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1206040280, version=150)
    public int sceUmdManGetUmdDrive(int unknown) {
        if (this.dummyUmdDriveInfo == null) {
            int size = 36;
            this.dummyUmdDriveInfo = Modules.SysMemUserForUserModule.malloc(1, "sceUmdManGetUmdDrive", 0, 36, 0);
            if (this.dummyUmdDriveInfo == null) {
                return -1;
            }
            this.dummyUmdDrive = new TPointer(Memory.getInstance(), this.dummyUmdDriveInfo.addr);
            this.dummyUmdDrive.clear(36);
        }
        return this.dummyUmdDrive.getAddress();
    }

    @HLEUnimplemented
    @HLEFunction(nid=1015829053, version=150)
    public int sceUmdMan_3C8C523D(int wantedStatus, TPointer callback, TPointer callbackArg) {
        if (this.getSectorDevice() != null && (wantedStatus == 32 || wantedStatus == 16)) {
            TriggerCallbackAction triggerCallbackAction = new TriggerCallbackAction(wantedStatus, callback.getAddress(), callbackArg.getAddress(), 0);
            Emulator.getScheduler().addAction(Scheduler.getNow() + 1000L, triggerCallbackAction);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=973450300, version=150)
    public boolean sceUmdMan_3A05AC3C() {
        return false;
    }

    @HLEUnimplemented
    @HLEFunction(nid=231264877, version=150)
    public int sceUmdManWaitSema() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1626312845, version=150)
    public int sceUmdManPollSema() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1331413593, version=150)
    public int sceUmdManSignalSema() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-216169976, version=150)
    public int sceUmdMan_F31D8208() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1696200913, version=150)
    public int sceUmdMan_6519F8D1(int timeout) {
        int alarmUid = 0;
        return alarmUid;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-479106795, version=150)
    public int sceUmdMan_E3716915(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer umdDrive, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=12, usage=BufferInfo.Usage.in) TPointer lbaParameters, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=2048, usage=BufferInfo.Usage.out) TPointer readBuffer1, int readSize, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.previousParameter, usage=BufferInfo.Usage.out) TPointer readBuffer2, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=2048, usage=BufferInfo.Usage.out) TPointer readBuffer3, int flags) {
        ISectorDevice sectorDevice;
        int sectorNumber = lbaParameters.getValue32(0);
        int unknown1 = lbaParameters.getValue32(4);
        short unknown2 = lbaParameters.getValue16(8);
        byte unknown3 = lbaParameters.getValue8(10);
        byte unknown4 = lbaParameters.getValue8(11);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceUmdMan_E3716915 LBA parameters: sectorNumber=0x%X, unknown1=0x%X, unknown2=0x%X, unknown3=0x%X, unknown4=0x%X", sectorNumber, unknown1, (int)unknown2, (int)unknown3, (int)unknown4));
        }
        if ((sectorDevice = this.getSectorDevice()) == null) {
            log.warn((Object)String.format("sceUmdMan_E3716915 no SectorDevice available", new Object[0]));
            return -1;
        }
        int totalReadSize = 0;
        if ((flags & 1) != 0) {
            totalReadSize += 2048;
        }
        if ((flags & 2) != 0) {
            totalReadSize += readSize;
        }
        if ((flags & 4) != 0) {
            totalReadSize += 2048;
        }
        int totalReadSectors = Utilities.alignUp(totalReadSize, 2047) / 2048;
        byte[] dataBuffer = new byte[totalReadSectors * 2048];
        try {
            sectorDevice.readSectors(sectorNumber, totalReadSectors, dataBuffer, 0);
        }
        catch (IOException e) {
            log.error((Object)e);
            return -1;
        }
        int dataBufferOffset = 0;
        if ((flags & 1) != 0) {
            readBuffer1.setArray(0, dataBuffer, dataBufferOffset, 2048);
            dataBufferOffset += 2048;
        }
        if ((flags & 2) != 0) {
            readBuffer2.setArray(0, dataBuffer, dataBufferOffset, readSize);
            dataBufferOffset += readSize;
        }
        if ((flags & 4) != 0) {
            readBuffer3.setArray(0, dataBuffer, dataBufferOffset, 2048);
            dataBufferOffset += 2048;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1889431605, version=150)
    public int sceUmdMan_709E7035(int alarmUid) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-783843293, version=150)
    public int sceUmdMan_D1478023() {
        int numSectors;
        ISectorDevice sectorDevice = this.getSectorDevice();
        if (sectorDevice == null) {
            log.warn((Object)String.format("sceUmdMan_D1478023 no SectorDevice available", new Object[0]));
            return -1;
        }
        try {
            numSectors = sectorDevice.getNumSectors();
        }
        catch (IOException e) {
            log.warn((Object)String.format("sceUmdMan_D1478023 IO error %s", e));
            return -1;
        }
        if (this.dummyAreaInfo == null) {
            this.dummyAreaInfo = Modules.SysMemUserForUserModule.malloc(1, "sceUmdMan_D1478023", 0, 120, 0);
            if (this.dummyAreaInfo == null) {
                return -1;
            }
            this.dummyArea = new TPointer(Memory.getInstance(), this.dummyAreaInfo.addr);
        }
        this.dummyArea.setValue8(100, (byte)18);
        this.dummyArea.setValue8(101, (byte)52);
        this.dummyArea.setValue8(102, (byte)86);
        this.dummyArea.setValue8(103, (byte)120);
        this.dummyArea.setValue32(108, 0x11111111);
        this.dummyArea.setValue32(112, numSectors);
        this.dummyArea.setValue32(116, numSectors);
        return this.dummyArea.getAddress();
    }

    @HLEUnimplemented
    @HLEFunction(nid=1337529251, version=150)
    public int sceUmdManGetIntrStateFlag() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1879588550, version=150)
    public int sceUmdMan_8FF7C13A() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=750687643, version=150)
    public int sceUmdExecReqSenseCmd(TPointer unknown, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.out) TPointer resultAddr, int resultSize) {
        if (resultSize < 18) {
            return -1;
        }
        boolean mediumPresent = this.getSectorDevice() != null;
        resultAddr.clear(resultSize);
        resultAddr.setUnsignedValue8(0, 128);
        resultAddr.setUnsignedValue8(1, 0);
        if (mediumPresent) {
            resultAddr.setUnsignedValue8(2, 0);
        } else {
            resultAddr.setUnsignedValue8(2, 2);
        }
        resultAddr.setUnalignedValue32(3, 0);
        resultAddr.setUnsignedValue8(7, 10);
        resultAddr.setUnalignedValue32(8, 0);
        if (mediumPresent) {
            resultAddr.setUnsignedValue8(12, 0);
            resultAddr.setUnsignedValue8(13, 0);
        } else {
            resultAddr.setUnsignedValue8(12, 58);
            resultAddr.setUnsignedValue8(13, 2);
        }
        resultAddr.setUnsignedValue8(14, 0);
        resultAddr.setUnsignedValue8(15, 0);
        resultAddr.setUnsignedValue8(16, 0);
        resultAddr.setUnsignedValue8(17, 0);
        if (!mediumPresent && "MSTKUPDATE".equals(State.discId)) {
            resultAddr.setUnsignedValue8(2, 9);
            resultAddr.setUnsignedValue8(12, 2);
            resultAddr.setUnsignedValue8(13, 0);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-925812742, version=150)
    public int sceUmdMan_C8D137FA(TPointer unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=753473713, version=150)
    public int sceUmdMan_2CE918B1() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1487707895, version=150)
    public int sceUmdMan_A7536109(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-411439889, version=150)
    public int sceUmdManGetInquiry(int unknown, int outputBufferLength, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.previousParameter, usage=BufferInfo.Usage.out) TPointer outputBuffer) {
        outputBuffer.clear(outputBufferLength);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1843496067, version=150)
    public int sceUmdMan_driver_921E7B7D() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1929456111, version=150)
    public int sceUmdManStart(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=530251764, version=150)
    public int sceUmdManMediaPresent(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-747448589, version=150)
    public int sceUmdMan_driver_D372D6F3(TPointer driveInformationAddress) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=349386780, version=150)
    public int sceUmdExecTestCmd() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=454664979, version=150)
    public int sceUmdExecInquiryCmd() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=222208515, version=150)
    public int sceUmdManTerm() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-892137435, version=150)
    public int sceUmdManStop() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1936384307, version=150)
    public int sceUmdManLPNNegateWakeup() {
        return 0;
    }

    private static class TriggerCallbackAction
    implements IAction {
        private int status;
        private int callback;
        private int callbackArg;
        private int argument3;

        public TriggerCallbackAction(int status, int callback, int callbackArg, int argument3) {
            this.status = status;
            this.callback = callback;
            this.callbackArg = callbackArg;
            this.argument3 = argument3;
        }

        @Override
        public void execute() {
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            Modules.ThreadManForUserModule.executeCallback(thread, this.callback, null, true, this.status, this.callbackArg, this.argument3);
        }
    }
}

