/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MMIOHandlerA7F00000
extends MMIOHandlerBase {
    public static Logger log = Logger.getLogger((String)"0xA7F00000");
    private static final int STATE_VERSION = 0;
    private int unknown00;
    private int unknown20;

    public MMIOHandlerA7F00000(int baseAddress) {
        super(baseAddress);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.unknown00 = stream.readInt();
        this.unknown20 = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.unknown00);
        stream.writeInt(this.unknown20);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.unknown00 = 0;
        this.unknown20 = 0;
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = this.unknown00;
                break;
            }
            case 32: {
                value = this.unknown20;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                this.unknown00 = value;
                break;
            }
            case 32: {
                this.unknown20 = value;
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }
}

