/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import java.util.HashMap;
import jpcsp.HLE.VFS.FakeVirtualFileSystem;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.VFS.local.LocalVirtualFileSystem;
import jpcsp.HLE.VFS.xmb.XmbVirtualFileSystem;
import jpcsp.settings.Settings;

public class VirtualFileSystemManager {
    protected HashMap<String, IVirtualFileSystem> virtualFileSystems = new HashMap();
    private IVirtualFileSystem xmbVfs;

    public VirtualFileSystemManager() {
        FakeVirtualFileSystem.getInstance().registerAllFakeVirtualFiles(this);
    }

    public void register(String name, IVirtualFileSystem vfs) {
        this.virtualFileSystems.put(name, vfs);
    }

    public void unregister(String name) {
        this.virtualFileSystems.remove(name);
    }

    public IVirtualFileSystem getVirtualFileSystem(String absoluteFileName, StringBuilder localFileName) {
        IVirtualFileSystem vfs = this.virtualFileSystems.get(absoluteFileName);
        if (vfs != null) {
            if (localFileName != null) {
                localFileName.setLength(0);
                localFileName.append(absoluteFileName);
            }
            return vfs;
        }
        int colon = absoluteFileName.indexOf(58);
        if (colon < 0) {
            return null;
        }
        String name = absoluteFileName.substring(0, colon);
        name = name.toLowerCase();
        if (localFileName != null) {
            localFileName.setLength(0);
            localFileName.append(absoluteFileName.substring(colon + 1));
            this.normalizeLocalFileName(localFileName);
            if ("ms0".equals(name) && localFileName.toString().startsWith("PSP/GAME")) {
                if (this.xmbVfs == null) {
                    this.xmbVfs = new XmbVirtualFileSystem(new LocalVirtualFileSystem(Settings.getInstance().getDirectoryMapping("ms0"), true));
                }
                return this.xmbVfs;
            }
        }
        return this.virtualFileSystems.get(name);
    }

    private void normalizeLocalFileName(StringBuilder localFileName) {
        int dotIndex;
        int parentIndex;
        int dotDotIndex;
        while ((dotDotIndex = localFileName.indexOf("/../")) >= 0 && (parentIndex = localFileName.lastIndexOf("/", dotDotIndex - 1)) >= 0) {
            localFileName.delete(parentIndex, dotDotIndex + 3);
        }
        if (localFileName.length() >= 3 && localFileName.lastIndexOf("/..") == localFileName.length() - 3) {
            if (localFileName.length() <= 3) {
                localFileName.setLength(0);
            } else {
                int parentIndex2 = localFileName.lastIndexOf("/", localFileName.length() - 4);
                if (parentIndex2 < 0) {
                    localFileName.setLength(0);
                } else {
                    localFileName.setLength(parentIndex2);
                }
            }
        }
        while ((dotIndex = localFileName.indexOf("/./")) >= 0) {
            localFileName.delete(dotIndex, dotIndex + 2);
        }
        if (localFileName.length() >= 2 && localFileName.lastIndexOf("/.") == localFileName.length() - 2) {
            localFileName.setLength(localFileName.length() - 2);
        }
        if (localFileName.length() > 0 && localFileName.charAt(0) == '/') {
            localFileName.deleteCharAt(0);
        }
        if (localFileName.length() > 0 && localFileName.charAt(localFileName.length() - 1) == '/') {
            localFileName.setLength(localFileName.length() - 1);
        }
    }

    public static String getFileNameLastPart(String fileName) {
        int lastSepIndex;
        if (fileName != null && (lastSepIndex = fileName.lastIndexOf(47)) >= 0) {
            fileName = fileName.substring(lastSepIndex + 1);
        }
        return fileName;
    }
}

