/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.anim;

import jpcsp.format.rco.ObjectField;
import jpcsp.format.rco.anim.AbstractAnimAction;
import jpcsp.format.rco.anim.BaseAnim;
import jpcsp.format.rco.object.BasePositionObject;
import jpcsp.format.rco.type.FloatType;
import jpcsp.format.rco.type.IntType;
import jpcsp.format.rco.type.ObjectType;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;

public class MoveToAnim
extends BaseAnim {
    @ObjectField(order=1)
    public ObjectType ref;
    @ObjectField(order=2)
    public FloatType duration;
    @ObjectField(order=3)
    public IntType accelMode;
    @ObjectField(order=4)
    public FloatType x;
    @ObjectField(order=5)
    public FloatType y;
    @ObjectField(order=6)
    public FloatType z;

    @Override
    protected long doPlayReference(BasePositionObject object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("MoveToAnim play %s on %s", this.toString(), object));
        }
        MoveToAnim.getScheduler().addAction(new MoveToAnimAction(this.duration.getIntValue(), object));
        return 0L;
    }

    @Override
    protected long doPlay(VSMXBaseObject object) {
        return this.doPlayReference(this.ref);
    }

    private class MoveToAnimAction
    extends AbstractAnimAction {
        private BasePositionObject positionObject;
        private float startX;
        private float startY;
        private float startZ;

        public MoveToAnimAction(int duration, BasePositionObject positionObject) {
            super(duration);
            this.positionObject = positionObject;
            this.startX = positionObject.animX;
            this.startY = positionObject.animY;
            this.startZ = positionObject.animZ;
        }

        @Override
        protected void anim(float step) {
            this.positionObject.animX = MoveToAnimAction.interpolate(this.startX, MoveToAnim.this.x.getFloatValue(), step);
            this.positionObject.animY = MoveToAnimAction.interpolate(this.startY, MoveToAnim.this.y.getFloatValue(), step);
            this.positionObject.animZ = MoveToAnimAction.interpolate(this.startZ, MoveToAnim.this.z.getFloatValue(), step);
            this.positionObject.onDisplayUpdated();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("MoveToAnim '%s' from (%f,%f,%f) to (%f,%f,%f)", this.positionObject.getName(), Float.valueOf(this.startX), Float.valueOf(this.startY), Float.valueOf(this.startZ), Float.valueOf(this.positionObject.animX), Float.valueOf(this.positionObject.animY), Float.valueOf(this.positionObject.animZ)));
            }
        }
    }
}

