/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules.sceAtrac3plus;
import jpcsp.HLE.modules.sceSasCore;
import jpcsp.Memory;
import jpcsp.sound.ISampleSource;
import org.apache.log4j.Logger;

public class SampleSourceAtrac3
implements ISampleSource {
    private Logger log = sceSasCore.log;
    private final sceAtrac3plus.AtracID id;
    private final int maxSamples;
    private final int buffer;
    private int sampleIndex;
    private int currentSampleIndex;
    private int bufferedSamples;
    private final Memory mem;

    public SampleSourceAtrac3(sceAtrac3plus.AtracID id) {
        this.id = id;
        this.maxSamples = id.getMaxSamples();
        id.createInternalBuffer(this.maxSamples * 4);
        this.buffer = id.getInternalBuffer().addr;
        this.sampleIndex = 0;
        this.bufferedSamples = 0;
        this.currentSampleIndex = -1;
        this.mem = Memory.getInstance();
    }

    private void decode() {
        int result = this.id.decodeData(this.buffer, TPointer32.NULL);
        if (result == -2140995548) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("SampleSourceAtrac3 decodeData returned 0x%08X", result));
            }
            this.bufferedSamples = 0;
        } else if (result < 0) {
            this.log.error((Object)String.format("SampleSourceAtrac3 decodeData returned 0x%08X", result));
            this.bufferedSamples = 0;
        } else {
            this.bufferedSamples = this.id.getCodec().getNumberOfSamples();
        }
        if (!this.id.getInputBuffer().isFileEnd()) {
            int requestedSize = Math.min(this.id.getInputFileSize() - this.id.getInputBuffer().getFilePosition(), this.id.getInputBuffer().getMaxSize());
            this.id.setContextDecodeResult(0, requestedSize);
        } else {
            this.id.setContextDecodeResult(0, 0);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("SampleSourceAtrac3 decode: bufferedSamples=%d, currentSample=%d, endSample=%d", this.bufferedSamples, this.currentSampleIndex, this.id.getAtracEndSample()));
        }
        this.sampleIndex = 0;
    }

    @Override
    public int getNextSample() {
        if (this.sampleIndex >= this.bufferedSamples) {
            if (this.isEnded()) {
                return 0;
            }
            this.decode();
            if (this.bufferedSamples <= 0) {
                return 0;
            }
        }
        int sample = this.mem.read32(this.buffer + (this.sampleIndex << 2));
        ++this.currentSampleIndex;
        ++this.sampleIndex;
        return sample;
    }

    @Override
    public void resetToStart() {
        this.currentSampleIndex = 0;
        this.id.setPlayPosition(0);
    }

    @Override
    public boolean isEnded() {
        return this.currentSampleIndex >= this.id.getAtracEndSample();
    }
}

