/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.tls.TlsUtils;

public class TlsMac {
    private long seqNo;
    private HMac mac;

    protected TlsMac(Digest digest, byte[] byArray, int n, int n2) {
        this.mac = new HMac(digest);
        KeyParameter keyParameter = new KeyParameter(byArray, n, n2);
        this.mac.init(keyParameter);
        this.seqNo = 0L;
    }

    protected int getSize() {
        return this.mac.getMacSize();
    }

    protected byte[] calculateMac(short s, byte[] byArray, int n, int n2) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            TlsUtils.writeUint64(this.seqNo++, byteArrayOutputStream);
            TlsUtils.writeUint8(s, byteArrayOutputStream);
            TlsUtils.writeVersion(byteArrayOutputStream);
            TlsUtils.writeUint16(n2, byteArrayOutputStream);
            byteArrayOutputStream.write(byArray, n, n2);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            this.mac.update(byArray2, 0, byArray2.length);
            byte[] byArray3 = new byte[this.mac.getMacSize()];
            this.mac.doFinal(byArray3, 0);
            this.mac.reset();
            return byArray3;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Internal error during mac calculation");
        }
    }
}

