/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import jpcsp.format.RCO;
import jpcsp.format.rco.IDisplay;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXNativeObject;
import jpcsp.format.rco.vsmx.objects.BaseNativeObject;
import org.apache.log4j.Logger;

public class Display
extends JComponent {
    private static final long serialVersionUID = 5488196052725313236L;
    private static final Logger log = RCO.log;
    private List<IDisplay> objects = new LinkedList<IDisplay>();
    private IDisplay focus;
    private float moviePlayerWidth = 854.0f;
    private float moviePlayerHeight = 480.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.objects.size() > 0 && log.isTraceEnabled()) {
            log.trace((Object)String.format("Starting to paint Display with %d objects, focus=%s", this.objects.size(), this.focus));
            log.trace((Object)String.format("display %dx%d", this.getWidth(), this.getHeight()));
        }
        List<IDisplay> list = this.objects;
        synchronized (list) {
            for (IDisplay object : this.objects) {
                this.paint(g, object);
            }
        }
    }

    private void paint(Graphics g, IDisplay object) {
        int cx = object.getX();
        int cy = object.getY();
        int width = object.getWidth();
        int height = object.getHeight();
        int x = cx - width / 2;
        int y = cy + height / 2;
        BufferedImage image = object.getAnimImage();
        float displayWidth = this.getWidth();
        float displayHeight = this.getHeight();
        x = Math.round((float)x / (this.moviePlayerWidth / 2.0f) * (displayWidth / 2.0f) + displayWidth / 2.0f);
        y = Math.round((float)(-y) / (this.moviePlayerHeight / 2.0f) * (displayHeight / 2.0f) + displayHeight / 2.0f);
        width = Math.round((float)width / (this.moviePlayerWidth / displayWidth));
        height = Math.round((float)height / (this.moviePlayerWidth / displayWidth));
        float alpha = object.getAlpha();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("paint at (%d,%d) %dx%d alpha=%f - image=%dx%d, object=%s", x, y, width, height, Float.valueOf(alpha), image == null ? 0 : image.getWidth(), image == null ? 0 : image.getHeight(), object));
        }
        if (image != null) {
            if (g instanceof Graphics2D) {
                AlphaComposite ac = AlphaComposite.getInstance(10, alpha);
                ((Graphics2D)g).setComposite(ac);
            }
            g.drawImage(image, x, y, x + width - 1, y + height - 1, 0, 0, image.getWidth() - 1, image.getHeight() - 1, null);
        } else {
            g.setColor(Color.BLACK);
            g.drawRect(x, y, width, height);
        }
        if (this.focus == object) {
            g.setColor(Color.RED);
            g.drawRect(x, y, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IDisplay object) {
        List<IDisplay> list = this.objects;
        synchronized (list) {
            this.objects.add(object);
        }
    }

    public void add(BaseNativeObject object) {
        if (object instanceof IDisplay) {
            this.add((IDisplay)((Object)object));
        }
    }

    public void add(VSMXBaseObject object) {
        if (object instanceof VSMXNativeObject) {
            this.add(((VSMXNativeObject)object).getObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IDisplay object) {
        List<IDisplay> list = this.objects;
        synchronized (list) {
            this.objects.remove(object);
        }
    }

    public void remove(BaseNativeObject object) {
        if (object instanceof IDisplay) {
            this.remove((IDisplay)((Object)object));
        }
    }

    public void remove(VSMXBaseObject object) {
        if (object instanceof VSMXNativeObject) {
            this.remove(((VSMXNativeObject)object).getObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeResource() {
        List<IDisplay> list = this.objects;
        synchronized (list) {
            this.objects.clear();
        }
        this.focus = null;
    }

    public void setFocus(IDisplay focus) {
        if (this.focus != focus) {
            this.focus = focus;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Display.setFocus %s", focus));
            }
            this.repaint();
        }
    }

    public void setFocus(BaseNativeObject focus) {
        if (focus instanceof IDisplay) {
            this.setFocus((IDisplay)((Object)focus));
        }
    }

    public void setFocus(VSMXBaseObject focus) {
        if (focus instanceof VSMXNativeObject) {
            this.setFocus(((VSMXNativeObject)focus).getObject());
        }
    }
}

