/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx.interpreter;

import jpcsp.format.rco.vsmx.INativeFunction;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXInterpreter;
import jpcsp.format.rco.vsmx.interpreter.VSMXNativeFunction;
import jpcsp.format.rco.vsmx.interpreter.VSMXNativeObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXObject;
import jpcsp.format.rco.vsmx.objects.NativeFunctionFactory;

public class VSMXReference
extends VSMXBaseObject {
    private VSMXObject refObject;
    private String refProperty;
    private int refIndex;

    public VSMXReference(VSMXInterpreter interpreter, VSMXObject refObject, String refProperty) {
        super(interpreter);
        this.refObject = refObject;
        this.refProperty = refProperty;
    }

    public VSMXReference(VSMXInterpreter interpreter, VSMXObject refObject, int refIndex) {
        super(interpreter);
        this.refObject = refObject;
        this.refIndex = refIndex;
    }

    public void assign(VSMXBaseObject value) {
        if (this.refProperty == null) {
            this.refObject.setPropertyValue(this.refIndex, value.getValue());
        } else {
            this.refObject.setPropertyValue(this.refProperty, value.getValue());
        }
    }

    public String getRefProperty() {
        if (this.refProperty == null) {
            return Integer.toString(this.refIndex);
        }
        return this.refProperty;
    }

    protected VSMXBaseObject getRef() {
        return this.getRef(0);
    }

    protected VSMXBaseObject getRef(int numberOfArguments) {
        if (this.refProperty == null) {
            return this.refObject.getPropertyValue(this.refIndex);
        }
        if (!this.refObject.hasPropertyValue(this.refProperty) && this.refObject instanceof VSMXNativeObject) {
            VSMXNativeObject nativeObject = (VSMXNativeObject)this.refObject;
            INativeFunction nativeFunction = NativeFunctionFactory.getInstance().getNativeFunction(nativeObject, this.refProperty, numberOfArguments);
            if (nativeFunction != null) {
                return new VSMXNativeFunction(this.interpreter, nativeFunction);
            }
        }
        return this.refObject.getPropertyValue(this.refProperty);
    }

    @Override
    public VSMXBaseObject getValue() {
        return this.getRef();
    }

    @Override
    public VSMXBaseObject getValueWithArguments(int numberOfArguments) {
        return this.getRef(numberOfArguments);
    }

    @Override
    public float getFloatValue() {
        return this.getRef().getFloatValue();
    }

    @Override
    public int getIntValue() {
        return this.getRef().getIntValue();
    }

    @Override
    public boolean getBooleanValue() {
        return this.getRef().getBooleanValue();
    }

    @Override
    public String getStringValue() {
        return this.getRef().getStringValue();
    }

    @Override
    public boolean equals(VSMXBaseObject value) {
        return this.getRef().equals(value);
    }

    @Override
    public VSMXBaseObject getPropertyValue(String name) {
        return this.getRef().getPropertyValue(name);
    }

    @Override
    public void setPropertyValue(String name, VSMXBaseObject value) {
        this.getRef().setPropertyValue(name, value);
    }

    @Override
    public void deletePropertyValue(String name) {
        this.getRef().deletePropertyValue(name);
    }

    @Override
    public void setFloatValue(float value) {
        this.getRef().setFloatValue(value);
    }

    @Override
    public String typeOf() {
        return this.getRef().typeOf();
    }

    @Override
    public String getClassName() {
        return this.getRef().getClassName();
    }

    @Override
    public String toString() {
        if (this.refProperty == null) {
            return String.format("@OBJ[%d]=%s", this.refIndex, this.getRef());
        }
        return String.format("@OBJ.%s=%s", this.refProperty, this.getRef());
    }
}

