/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.adhoc;

import jpcsp.HLE.modules.sceNet;
import jpcsp.network.adhoc.AdhocMessage;
import jpcsp.network.adhoc.MatchingObject;

public abstract class AdhocMatchingEventMessage
extends AdhocMessage {
    private int event;
    private MatchingObject matchingObject;

    public AdhocMatchingEventMessage(MatchingObject matchingObject, int event) {
        this.event = event;
        this.matchingObject = matchingObject;
    }

    public AdhocMatchingEventMessage(MatchingObject matchingObject, int event, int address, int length, byte[] toMacAddress) {
        super(address, length, toMacAddress);
        this.event = event;
        this.matchingObject = matchingObject;
    }

    public AdhocMatchingEventMessage(MatchingObject matchingObject, byte[] message, int length) {
        super(message, length);
        this.matchingObject = matchingObject;
    }

    public int getEvent() {
        return this.event;
    }

    protected void setEvent(int event) {
        this.event = event;
    }

    protected MatchingObject getMatchingObject() {
        return this.matchingObject;
    }

    public void processOnReceive(int macAddr, int optData, int optLen) {
        if (this.event < 100) {
            this.matchingObject.notifyCallbackEvent(this.getEvent(), macAddr, optLen, optData);
        }
    }

    public void processOnSend(int macAddr, int optData, int optLen) {
    }

    @Override
    public String toString() {
        return String.format("%s[id=0x%X, fromMacAddress=%s, toMacAddress=%s, event=%d, dataLength=%d]", this.getClass().getSimpleName(), this.getId(), sceNet.convertMacAddressToString(this.fromMacAddress), sceNet.convertMacAddressToString(this.toMacAddress), this.getEvent(), this.getDataLength());
    }
}

