/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import jpcsp.Emulator;
import jpcsp.filesystems.umdiso.BufferedFileSectorDevice;
import jpcsp.filesystems.umdiso.CSOFileSectorDevice;
import jpcsp.filesystems.umdiso.IBrowser;
import jpcsp.filesystems.umdiso.ISOFileSectorDevice;
import jpcsp.filesystems.umdiso.ISectorDevice;
import jpcsp.filesystems.umdiso.PBPFileSectorDevice;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.filesystems.umdiso.iso9660.Iso9660Directory;
import jpcsp.filesystems.umdiso.iso9660.Iso9660File;
import jpcsp.filesystems.umdiso.iso9660.Iso9660Handler;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;

public class UmdIsoReader
implements IBrowser {
    public static final int startSector = 16;
    public static final int startSectorJoliet = 17;
    private static final int headerLength = 24;
    private ISectorDevice sectorDevice;
    private IBrowser browser;
    private final HashMap<String, Iso9660File> fileCache = new HashMap();
    private final HashMap<String, Iso9660Directory> dirCache = new HashMap();
    private int numSectors;
    private static boolean doIsoBuffering = false;
    private boolean hasJolietExtension;
    private boolean isPBP;

    public UmdIsoReader(String umdFilename) throws IOException, FileNotFoundException {
        this.init(umdFilename, doIsoBuffering);
    }

    public UmdIsoReader(String umdFilename, boolean doIsoBuffering) throws IOException, FileNotFoundException {
        this.init(umdFilename, doIsoBuffering);
    }

    private void init(String umdFilename, boolean doIsoBuffering) throws IOException, FileNotFoundException {
        this.isPBP = false;
        if (umdFilename == null && doIsoBuffering) {
            this.sectorDevice = null;
        } else {
            RandomAccessFile fileReader = new RandomAccessFile(umdFilename, "r");
            byte[] header = new byte[24];
            fileReader.seek(0L);
            fileReader.read(header);
            fileReader.seek(0L);
            if (header[0] == 67 && header[1] == 73 && header[2] == 83 && header[3] == 79) {
                this.sectorDevice = new CSOFileSectorDevice(fileReader, header);
            } else if (header[0] == 0 && header[1] == 80 && header[2] == 66 && header[3] == 80) {
                this.sectorDevice = new PBPFileSectorDevice(fileReader);
                this.isPBP = true;
            } else {
                this.sectorDevice = new ISOFileSectorDevice(fileReader);
            }
        }
        if (doIsoBuffering) {
            String tmp = Settings.getInstance().getTmpDirectory();
            this.sectorDevice = new BufferedFileSectorDevice(new RandomAccessFile(tmp + "umdbuffer.toc", "rw"), new RandomAccessFile(tmp + "umdbuffer.iso", "rw"), this.sectorDevice);
        }
        this.numSectors = this.sectorDevice.getNumSectors();
        this.setBrowser();
        if (this.browser == null && !this.hasIsoHeader()) {
            throw new IOException(String.format("Unsupported file format or corrupted file '%s'.", umdFilename));
        }
    }

    public UmdIsoReader(ISectorDevice sectorDevice) throws IOException {
        this.sectorDevice = sectorDevice;
        this.numSectors = sectorDevice.getNumSectors();
        this.setBrowser();
    }

    private void setBrowser() {
        this.browser = this.sectorDevice instanceof IBrowser ? (IBrowser)((Object)this.sectorDevice) : null;
    }

    public void close() throws IOException {
        this.sectorDevice.close();
    }

    private boolean hasIsoHeader() throws IOException {
        if (this.numSectors <= 0) {
            return false;
        }
        UmdIsoFile f = new UmdIsoFile(this, 16, 2048L, null, null);
        byte[] header = new byte[6];
        int length = f.read(header);
        f.close();
        if (length < header.length) {
            return false;
        }
        if (header[1] != 67 || header[2] != 68 || header[3] != 48 || header[4] != 48 || header[5] != 49) {
            return false;
        }
        this.hasJolietExtension = false;
        f = new UmdIsoFile(this, 17, 2048L, null, null);
        length = f.read(header);
        f.close();
        if (length == header.length && header[0] == 2 && header[1] == 67 && header[2] == 68 && header[3] == 48 && header[4] == 48 && header[5] == 49) {
            this.hasJolietExtension = true;
        }
        return true;
    }

    public boolean hasJolietExtension() {
        return this.hasJolietExtension;
    }

    public int getNumSectors() {
        return this.numSectors;
    }

    public ISectorDevice getSectorDevice() {
        return this.sectorDevice;
    }

    public int readSectors(int sectorNumber, int numberSectors, byte[] buffer, int offset) throws IOException {
        if (sectorNumber < 0 || sectorNumber + numberSectors > this.numSectors) {
            Arrays.fill(buffer, offset, offset + numberSectors * 2048, (byte)0);
            Emulator.log.warn((Object)String.format("Sectors start=%d, end=%d out of ISO (numSectors=%d)", sectorNumber, sectorNumber + numberSectors, this.numSectors));
            return numberSectors;
        }
        return this.sectorDevice.readSectors(sectorNumber, numberSectors, buffer, offset);
    }

    public void readSector(int sectorNumber, byte[] buffer, int offset) throws IOException {
        if (sectorNumber < 0 || sectorNumber >= this.numSectors) {
            Arrays.fill(buffer, offset, offset + 2048, (byte)0);
            Emulator.log.warn((Object)String.format("Sector number %d out of ISO (numSectors=%d)", sectorNumber, this.numSectors));
            return;
        }
        this.sectorDevice.readSector(sectorNumber, buffer, offset);
    }

    public byte[] readSector(int sectorNumber) throws IOException {
        return this.readSector(sectorNumber, null);
    }

    public byte[] readSector(int sectorNumber, byte[] buffer) throws IOException {
        if (buffer == null || buffer.length != 2048) {
            buffer = new byte[2048];
        }
        this.readSector(sectorNumber, buffer, 0);
        return buffer;
    }

    private int removePath(String[] path, int index, int length) {
        if (index < 0 || index >= length) {
            return length;
        }
        for (int i = index + 1; i < length; ++i) {
            path[i - 1] = path[i];
        }
        return length - 1;
    }

    private Iso9660File getFileEntry(String filePath) throws IOException, FileNotFoundException {
        int index;
        String parentDirectory;
        Iso9660Directory dir;
        Iso9660File info = this.fileCache.get(filePath);
        if (info != null) {
            return info;
        }
        int parentDirectoryIndex = filePath.lastIndexOf(47);
        if (parentDirectoryIndex >= 0 && (dir = this.dirCache.get(parentDirectory = filePath.substring(0, parentDirectoryIndex))) != null && (info = dir.getEntryByIndex(index = dir.getFileIndex(filePath.substring(parentDirectoryIndex + 1)))) != null) {
            this.fileCache.put(filePath, info);
            return info;
        }
        Iso9660Directory dir2 = new Iso9660Handler(this);
        String[] path = filePath.split("[\\/]");
        int pathLength = path.length;
        int i = 0;
        while (i < pathLength) {
            if (path[i].equals(".")) {
                pathLength = this.removePath(path, i, pathLength);
                continue;
            }
            if (path[i].equals("..")) {
                pathLength = this.removePath(path, i, pathLength);
                pathLength = this.removePath(path, i - 1, pathLength);
                continue;
            }
            ++i;
        }
        for (i = 0; i < pathLength; ++i) {
            int index2 = ((Iso9660Directory)dir2).getFileIndex(path[i]);
            info = ((Iso9660Directory)dir2).getEntryByIndex(index2);
            if (!this.isDirectory(info)) continue;
            dir2 = new Iso9660Directory(this, info.getLBA(), info.getSize());
            StringBuilder dirPath = new StringBuilder(path[0]);
            for (int j = 1; j <= i; ++j) {
                dirPath.append("/").append(path[j]);
            }
            this.dirCache.put(dirPath.toString(), dir2);
        }
        if (info != null) {
            this.fileCache.put(filePath, info);
        }
        return info;
    }

    public UmdIsoFile getFile(String filePath) throws IOException, FileNotFoundException {
        Date timestamp;
        long fileLength;
        int fileStart;
        if (this.numSectors == 0) {
            throw new FileNotFoundException(filePath);
        }
        String fileName = null;
        if (filePath != null && filePath.startsWith("sce_lbn")) {
            filePath = filePath.substring(7);
            int sep = filePath.indexOf("_size");
            fileStart = (int)Utilities.parseHexLong(filePath.substring(0, sep), true);
            fileLength = Utilities.parseHexLong(filePath.substring(sep + 5), true);
            timestamp = new Date();
            fileName = null;
            if (fileStart < 0 || fileStart >= this.numSectors) {
                throw new IOException("File '" + filePath + "': Invalid Start Sector");
            }
        } else if (filePath != null && filePath.length() == 0) {
            fileStart = 0;
            fileLength = (long)this.numSectors * 2048L;
            timestamp = new Date();
        } else {
            Iso9660File info = this.getFileEntry(filePath);
            if (info != null && this.isDirectory(info)) {
                info = null;
            }
            if (info == null) {
                throw new FileNotFoundException("File '" + filePath + "' not found or not a file.");
            }
            fileStart = info.getLBA();
            fileLength = info.getSize();
            timestamp = info.getTimestamp();
            fileName = info.getFileName();
        }
        return new UmdIsoFile(this, fileStart, fileLength, timestamp, fileName);
    }

    public boolean hasFile(String filePath) {
        try {
            UmdIsoFile umdIsoFile = this.getFile(filePath);
            if (umdIsoFile != null) {
                umdIsoFile.close();
                return true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public String[] listDirectory(String filePath) throws IOException, FileNotFoundException {
        Iso9660Directory dir = null;
        if (filePath.length() == 0) {
            dir = new Iso9660Handler(this);
        } else {
            Iso9660File info = this.getFileEntry(filePath);
            if (info != null && this.isDirectory(info)) {
                dir = new Iso9660Directory(this, info.getLBA(), info.getSize());
            }
        }
        if (dir == null) {
            throw new FileNotFoundException("File '" + filePath + "' not found or not a directory.");
        }
        return ((Iso9660Directory)dir).getFileList();
    }

    public int getFileProperties(String filePath) throws IOException, FileNotFoundException {
        if (filePath.length() == 0) {
            return 2;
        }
        Iso9660File info = this.getFileEntry(filePath);
        if (info == null) {
            throw new FileNotFoundException("File '" + filePath + "' not found.");
        }
        return info.getProperties();
    }

    public boolean isDirectory(String filePath) throws IOException, FileNotFoundException {
        return (this.getFileProperties(filePath) & 2) == 2;
    }

    public boolean isDirectory(Iso9660File file) {
        return (file.getProperties() & 2) == 2;
    }

    private String getFileNameRecursive(int fileStartSector, String path, String[] files) throws FileNotFoundException, IOException {
        for (String file : files) {
            String filePath = path + "/" + file;
            Iso9660File info = null;
            if (path.length() == 0) {
                filePath = file;
            } else {
                info = this.getFileEntry(filePath);
                if (info != null && info.getLBA() == fileStartSector) {
                    return filePath;
                }
            }
            if (info != null && !this.isDirectory(info) || file.equals(".") || file.equals("\u0001")) continue;
            try {
                String[] childFiles = this.listDirectory(filePath);
                String fileName = this.getFileNameRecursive(fileStartSector, filePath, childFiles);
                if (fileName == null) continue;
                return fileName;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getFileName(int fileStartSector) {
        try {
            String[] files = this.listDirectory("");
            return this.getFileNameRecursive(fileStartSector, "", files);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public long dumpIndexRecursive(PrintWriter out, String path, String[] files) throws IOException {
        long size = 0L;
        for (String file : files) {
            Iso9660File info;
            String filePath = path + "/" + file;
            int fileStart = 0;
            long fileLength = 0L;
            if (path.length() == 0) {
                filePath = file;
            }
            if ((info = this.getFileEntry(filePath)) != null) {
                fileStart = info.getLBA();
                fileLength = info.getSize();
                size += fileLength + 2047L & 0xFFFFFFFFFFFFF800L;
            }
            if (file.equals(".") || file.equals("\u0001")) continue;
            if (info == null || this.isDirectory(info)) {
                out.println(String.format("D %08X %10d %s", fileStart, fileLength, filePath));
                String[] childFiles = this.listDirectory(filePath);
                size += this.dumpIndexRecursive(out, filePath, childFiles);
                continue;
            }
            out.println(String.format("  %08X %10d %s", fileStart, fileLength, filePath));
        }
        return size;
    }

    public void dumpIndexFile(String filename) throws IOException, FileNotFoundException {
        PrintWriter out = new PrintWriter(new FileOutputStream(filename));
        out.println("  Start    Size       Name");
        String[] files = this.listDirectory("");
        long totalSize = this.dumpIndexRecursive(out, "", files);
        long imageSize = (long)this.numSectors * 2048L;
        out.println(String.format("Total Size %10d", totalSize));
        out.println(String.format("Image Size %10d", imageSize));
        out.println(String.format("Missing    %10d (%d sectors)", imageSize - totalSize, (long)this.numSectors - totalSize / 2048L));
        out.close();
    }

    public static void setDoIsoBuffering(boolean doIsoBuffering) {
        UmdIsoReader.doIsoBuffering = doIsoBuffering;
    }

    private byte[] readFile(String fileName) throws IOException {
        int length;
        byte[] buffer;
        if (!this.hasFile(fileName)) {
            return null;
        }
        UmdIsoFile file = this.getFile(fileName);
        int read = file.read(buffer = new byte[length = (int)file.length()]);
        if (read < 0) {
            return null;
        }
        if (read < length) {
            byte[] newBuffer = new byte[read];
            System.arraycopy(buffer, 0, newBuffer, 0, read);
            buffer = newBuffer;
        }
        return buffer;
    }

    @Override
    public byte[] readParamSFO() throws IOException {
        if (this.browser != null) {
            return this.browser.readParamSFO();
        }
        return this.readFile("PSP_GAME/PARAM.SFO");
    }

    @Override
    public byte[] readIcon0() throws IOException {
        if (this.browser != null) {
            return this.browser.readIcon0();
        }
        return this.readFile("PSP_GAME/ICON0.PNG");
    }

    @Override
    public byte[] readIcon1() throws IOException {
        if (this.browser != null) {
            return this.browser.readIcon1();
        }
        return this.readFile("PSP_GAME/ICON1.PNG");
    }

    @Override
    public byte[] readPic0() throws IOException {
        if (this.browser != null) {
            return this.browser.readPic0();
        }
        return this.readFile("PSP_GAME/PIC0.PNG");
    }

    @Override
    public byte[] readPic1() throws IOException {
        if (this.browser != null) {
            return this.browser.readPic1();
        }
        return this.readFile("PSP_GAME/PIC1.PNG");
    }

    @Override
    public byte[] readSnd0() throws IOException {
        if (this.browser != null) {
            return this.browser.readSnd0();
        }
        return this.readFile("PSP_GAME/SND0.AT3");
    }

    @Override
    public byte[] readPspData() throws IOException {
        if (this.browser != null) {
            return this.browser.readPspData();
        }
        return null;
    }

    @Override
    public byte[] readPsarData() throws IOException {
        if (this.browser != null) {
            return this.browser.readPsarData();
        }
        return null;
    }

    public boolean isPBP() {
        return this.isPBP;
    }
}

