/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.Memory;
import jpcsp.format.DeferredStub;

public class DeferredVStub32
extends DeferredStub {
    private boolean hasSavedValue;
    private int savedValue;

    public DeferredVStub32(SceModule sourceModule, String moduleName, int importAddress, int nid) {
        super(sourceModule, moduleName, importAddress, nid);
    }

    @Override
    public void resolve(Memory mem, int address) {
        if (!this.hasSavedValue) {
            this.savedValue = mem.read32(this.getImportAddress());
            this.hasSavedValue = true;
        }
        int value = mem.read32(this.getImportAddress());
        mem.write32(this.getImportAddress(), value += address);
        this.invalidate(this.getImportAddress(), 4);
    }

    @Override
    public void unresolve(Memory mem) {
        if (this.hasSavedValue) {
            mem.write32(this.getImportAddress(), this.savedValue);
            this.invalidate(this.getImportAddress(), 4);
        }
        if (this.sourceModule != null) {
            this.sourceModule.unresolvedImports.add(this);
        }
    }

    @Override
    public String toString() {
        return String.format("Reloc32 %s", super.toString());
    }
}

