/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx.interpreter;

import java.util.LinkedList;
import java.util.List;
import jpcsp.format.rco.vsmx.VSMX;
import jpcsp.format.rco.vsmx.interpreter.VSMXInterpreter;
import jpcsp.format.rco.vsmx.interpreter.VSMXObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXString;
import jpcsp.format.rco.vsmx.interpreter.VSMXUndefined;
import org.apache.log4j.Logger;

public abstract class VSMXBaseObject {
    public static final Logger log = VSMX.log;
    protected static final String lengthName = "length";
    protected static final String prototypeName = "prototype";
    protected static final String callName = "call";
    protected VSMXInterpreter interpreter;

    public VSMXBaseObject(VSMXInterpreter interpreter) {
        this.setInterpreter(interpreter);
    }

    protected void setInterpreter(VSMXInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public VSMXInterpreter getInterpreter() {
        return this.interpreter;
    }

    public VSMXBaseObject getValue() {
        return this;
    }

    public VSMXBaseObject getValueWithArguments(int numberOfArguments) {
        return this.getValue();
    }

    public float getFloatValue() {
        return 0.0f;
    }

    public int getIntValue() {
        return (int)this.getFloatValue();
    }

    public boolean getBooleanValue() {
        return this.getFloatValue() != 0.0f;
    }

    public String getStringValue() {
        return this.toString();
    }

    public boolean equals(VSMXBaseObject value) {
        return this.getFloatValue() == value.getFloatValue();
    }

    public boolean identity(VSMXBaseObject value) {
        return this == value;
    }

    public VSMXBaseObject getPropertyValue(String name) {
        VSMXObject prototype;
        if (prototypeName.equals(name) && (prototype = this.getPrototype()) != null) {
            return prototype;
        }
        return VSMXUndefined.singleton;
    }

    public VSMXBaseObject getPropertyValue(int index) {
        return this.getPropertyValue(Integer.toString(index));
    }

    public void setPropertyValue(String name, VSMXBaseObject value) {
    }

    public void setPropertyValue(int index, VSMXBaseObject value) {
        this.setPropertyValue(Integer.toString(index), value);
    }

    public void deletePropertyValue(String name) {
        this.setPropertyValue(name, (VSMXBaseObject)VSMXUndefined.singleton);
    }

    public void deletePropertyValue(int index) {
        this.deletePropertyValue(Integer.toString(index));
    }

    public boolean hasPropertyValue(String name) {
        return !VSMXUndefined.singleton.equals(this.getPropertyValue(name));
    }

    public List<String> getPropertyNames() {
        return new LinkedList<String>();
    }

    public void setFloatValue(float value) {
    }

    public abstract String typeOf();

    public abstract String getClassName();

    protected VSMXObject getPrototype() {
        String className = this.getClassName();
        if (className == null) {
            return null;
        }
        if (!this.interpreter.getGlobalVariables().hasPropertyValue(className)) {
            return null;
        }
        VSMXObject classObject = this.interpreter.getGlobalVariables().getPropertyValue(className).getPrototype();
        if (!(classObject instanceof VSMXObject)) {
            classObject = new VSMXObject(this.interpreter, className);
            this.interpreter.getGlobalVariables().setPropertyValue(className, (VSMXBaseObject)classObject);
        }
        return classObject;
    }

    public VSMXBaseObject toString(VSMXBaseObject object) {
        return new VSMXString(this.getInterpreter(), this.getStringValue());
    }

    public VSMXBaseObject toString(VSMXBaseObject object, VSMXBaseObject radix) {
        String s = Integer.toString(this.getIntValue(), radix.getIntValue());
        return new VSMXString(this.getInterpreter(), s);
    }

    public String toString() {
        if (this.getFloatValue() == (float)this.getIntValue()) {
            return Integer.toString(this.getIntValue());
        }
        return Float.toString(this.getFloatValue());
    }
}

