/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import com.xuggle.mediatool.IMediaListener;
import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.MediaListenerAdapter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.mediatool.event.IVideoPictureEvent;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.pspUsbCamSetupMicExParam;
import jpcsp.HLE.kernel.types.pspUsbCamSetupMicParam;
import jpcsp.HLE.kernel.types.pspUsbCamSetupStillExParam;
import jpcsp.HLE.kernel.types.pspUsbCamSetupStillParam;
import jpcsp.HLE.kernel.types.pspUsbCamSetupVideoExParam;
import jpcsp.HLE.kernel.types.pspUsbCamSetupVideoParam;
import jpcsp.HLE.modules.sceJpeg;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryWriter;
import org.apache.log4j.Logger;

public class sceUsbCam
extends HLEModule {
    public static Logger log = Modules.getLogger("sceUsbCam");
    private static final boolean dumpJpeg = false;
    public static final int PSP_USBCAM_PID = 642;
    public static final String PSP_USBCAM_DRIVERNAME = "USBCamDriver";
    public static final String PSP_USBCAMMIC_DRIVERNAME = "USBCamMicDriver";
    public static final int PSP_USBCAM_RESOLUTION_160_120 = 0;
    public static final int PSP_USBCAM_RESOLUTION_176_144 = 1;
    public static final int PSP_USBCAM_RESOLUTION_320_240 = 2;
    public static final int PSP_USBCAM_RESOLUTION_352_288 = 3;
    public static final int PSP_USBCAM_RESOLUTION_640_480 = 4;
    public static final int PSP_USBCAM_RESOLUTION_1024_768 = 5;
    public static final int PSP_USBCAM_RESOLUTION_1280_960 = 6;
    public static final int PSP_USBCAM_RESOLUTION_480_272 = 7;
    public static final int PSP_USBCAM_RESOLUTION_360_272 = 8;
    protected static final int[] resolutionWidth = new int[]{160, 176, 320, 352, 640, 1024, 1280, 480, 360};
    protected static final int[] resolutionHeight = new int[]{120, 144, 240, 288, 480, 768, 960, 272, 272};
    public static final int PSP_USBCAM_RESOLUTION_EX_160_120 = 0;
    public static final int PSP_USBCAM_RESOLUTION_EX_176_144 = 1;
    public static final int PSP_USBCAM_RESOLUTION_EX_320_240 = 2;
    public static final int PSP_USBCAM_RESOLUTION_EX_352_288 = 3;
    public static final int PSP_USBCAM_RESOLUTION_EX_360_272 = 4;
    public static final int PSP_USBCAM_RESOLUTION_EX_480_272 = 5;
    public static final int PSP_USBCAM_RESOLUTION_EX_640_480 = 6;
    public static final int PSP_USBCAM_RESOLUTION_EX_1024_768 = 7;
    public static final int PSP_USBCAM_RESOLUTION_EX_1280_960 = 8;
    public static final int PSP_USBCAM_FLIP = 1;
    public static final int PSP_USBCAM_MIRROR = 256;
    public static final int PSP_USBCAM_NODELAY = 0;
    public static final int PSP_USBCAM_DELAY_10SEC = 1;
    public static final int PSP_USBCAM_DELAY_20SEC = 2;
    public static final int PSP_USBCAM_DELAY_30SEC = 3;
    public static final int PSP_USBCAM_FRAMERATE_3_75_FPS = 0;
    public static final int PSP_USBCAM_FRAMERATE_5_FPS = 1;
    public static final int PSP_USBCAM_FRAMERATE_7_5_FPS = 2;
    public static final int PSP_USBCAM_FRAMERATE_10_FPS = 3;
    public static final int PSP_USBCAM_FRAMERATE_15_FPS = 4;
    public static final int PSP_USBCAM_FRAMERATE_20_FPS = 5;
    public static final int PSP_USBCAM_FRAMERATE_30_FPS = 6;
    public static final int PSP_USBCAM_FRAMERATE_60_FPS = 7;
    public static final int PSP_USBCAM_WB_AUTO = 0;
    public static final int PSP_USBCAM_WB_DAYLIGHT = 1;
    public static final int PSP_USBCAM_WB_FLUORESCENT = 2;
    public static final int PSP_USBCAM_WB_INCADESCENT = 3;
    public static final int PSP_USBCAM_EFFECTMODE_NORMAL = 0;
    public static final int PSP_USBCAM_EFFECTMODE_NEGATIVE = 1;
    public static final int PSP_USBCAM_EFFECTMODE_BLACKWHITE = 2;
    public static final int PSP_USBCAM_EFFECTMODE_SEPIA = 3;
    public static final int PSP_USBCAM_EFFECTMODE_BLUE = 4;
    public static final int PSP_USBCAM_EFFECTMODE_RED = 5;
    public static final int PSP_USBCAM_EFFECTMODE_GREEN = 6;
    public static final int PSP_USBCAM_EVLEVEL_2_0_POSITIVE = 0;
    public static final int PSP_USBCAM_EVLEVEL_1_7_POSITIVE = 1;
    public static final int PSP_USBCAM_EVLEVEL_1_5_POSITIVE = 2;
    public static final int PSP_USBCAM_EVLEVEL_1_3_POSITIVE = 3;
    public static final int PSP_USBCAM_EVLEVEL_1_0_POSITIVE = 4;
    public static final int PSP_USBCAM_EVLEVEL_0_7_POSITIVE = 5;
    public static final int PSP_USBCAM_EVLEVEL_0_5_POSITIVE = 6;
    public static final int PSP_USBCAM_EVLEVEL_0_3_POSITIVE = 7;
    public static final int PSP_USBCAM_EVLEVEL_0_0 = 8;
    public static final int PSP_USBCAM_EVLEVEL_0_3_NEGATIVE = 9;
    public static final int PSP_USBCAM_EVLEVEL_0_5_NEGATIVE = 10;
    public static final int PSP_USBCAM_EVLEVEL_0_7_NEGATIVE = 11;
    public static final int PSP_USBCAM_EVLEVEL_1_0_NEGATIVE = 12;
    public static final int PSP_USBCAM_EVLEVEL_1_3_NEGATIVE = 13;
    public static final int PSP_USBCAM_EVLEVEL_1_5_NEGATIVE = 14;
    public static final int PSP_USBCAM_EVLEVEL_1_7_NEGATIVE = 15;
    public static final int PSP_USBCAM_EVLEVEL_2_0_NEGATIVE = 16;
    protected int workArea;
    protected int workAreaSize;
    protected TPointer jpegBuffer;
    protected int jpegBufferSize;
    protected BufferedImage currentVideoImage;
    protected byte[] currentVideoImageBytes;
    protected int currentVideoFrameCount;
    protected int lastVideoFrameCount;
    protected VideoListener videoListener;
    protected int resolution;
    protected int frameRate;
    protected int whiteBalance;
    protected int frameSize;
    protected int saturation;
    protected int brightness;
    protected int contrast;
    protected int sharpness;
    protected int imageEffectMode;
    protected int evLevel;
    protected boolean flip;
    protected boolean mirror;
    protected int zoom;
    protected boolean autoImageReverseSW;
    protected boolean lensDirectionAtYou;
    protected int micFrequency;
    protected int micGain;
    protected TPointer readMicBuffer;
    protected int readMicBufferSize;
    protected long lastVideoFrameMillis;
    protected static final int[] framerateFrameDurationMillis = new int[]{267, 200, 133, 100, 67, 50, 33, 17};

    protected static int convertYUVtoRGB(int y, int u, int v) {
        int c = y - 16;
        int d = u - 128;
        int e = v - 128;
        int r = sceJpeg.clamp8bit(298 * c + 409 * e + 128 >> 8);
        int g = sceJpeg.clamp8bit(298 * c - 100 * d - 208 * e + 128 >> 8);
        int b = sceJpeg.clamp8bit(298 * c + 516 * d + 128 >> 8);
        return r << 16 | g << 8 | b;
    }

    protected BufferedImage convertYUYV422toRGB(int width, int height, ByteBuffer buffer) {
        byte[] input = new byte[width * height * 2];
        buffer.get(input);
        int[] output = new int[width * height];
        int i = 0;
        int j = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; x += 2) {
                int y0 = input[i++] & 0xFF;
                int u = input[i++] & 0xFF;
                int y1 = input[i++] & 0xFF;
                int v = input[i++] & 0xFF;
                output[j++] = sceUsbCam.convertYUVtoRGB(y0, u, v);
                output[j++] = sceUsbCam.convertYUVtoRGB(y1, u, v);
            }
        }
        BufferedImage image = new BufferedImage(width, height, 1);
        image.setRGB(0, 0, width, height, output, 0, width);
        if (this.currentVideoFrameCount % 30 == 0) {
            int imageIndex = this.currentVideoFrameCount / 30;
            try {
                FileOutputStream os = new FileOutputStream(String.format("tmp/UsbCam-%d.yuyv422", imageIndex));
                ((OutputStream)os).write(input);
                ((OutputStream)os).close();
            }
            catch (IOException e) {
                log.error((Object)"dumping yuyv422 image", (Throwable)e);
            }
        }
        return image;
    }

    protected int convertResolutionExToResolution(int resolutionEx) {
        switch (resolutionEx) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 6;
            }
        }
        return resolutionEx;
    }

    protected int getFramerateFrameDurationMillis() {
        if (this.frameRate < 0 || this.frameRate > 7) {
            return framerateFrameDurationMillis[7];
        }
        return framerateFrameDurationMillis[this.frameRate];
    }

    private void stopVideo() {
        if (this.videoListener != null) {
            this.videoListener.stop();
            this.videoListener = null;
        }
    }

    @Override
    public void stop() {
        this.stopVideo();
        super.stop();
    }

    protected static int getResolutionWidth(int resolution) {
        if (resolution < 0 || resolution >= resolutionWidth.length) {
            return 0;
        }
        return resolutionWidth[resolution];
    }

    protected static int getResolutionHeight(int resolution) {
        if (resolution < 0 || resolution >= resolutionHeight.length) {
            return 0;
        }
        return resolutionHeight[resolution];
    }

    protected boolean setupVideo() {
        if (this.videoListener != null) {
            return true;
        }
        IContainer container = IContainer.make();
        IContainerFormat format = IContainerFormat.make();
        int ret = format.setInputFormat("vfwcap");
        if (ret < 0) {
            container.close();
            format.delete();
            log.error((Object)String.format("USB Cam: cannot open WebCam ('vfwcap' device)", new Object[0]));
            return false;
        }
        ret = container.open("0", IContainer.Type.READ, format);
        if (ret < 0) {
            container.close();
            format.delete();
            log.error((Object)String.format("USB Cam: cannot open WebCam ('0')", new Object[0]));
            return false;
        }
        IMediaReader reader = ToolFactory.makeReader((IContainer)container);
        this.videoListener = new VideoListener(reader, sceUsbCam.getResolutionWidth(this.resolution), sceUsbCam.getResolutionHeight(this.resolution));
        reader.addListener((IMediaListener)this.videoListener);
        return true;
    }

    protected void setCurrentVideoImage(BufferedImage image) {
        byte[] newVideoImageBytes = null;
        if (image != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(this.jpegBufferSize);
            try {
                if (ImageIO.write((RenderedImage)image, "jpeg", outputStream)) {
                    outputStream.close();
                    newVideoImageBytes = outputStream.toByteArray();
                }
            }
            catch (IOException e) {
                log.error((Object)"setCurrentVideoImage", (Throwable)e);
            }
            ++this.currentVideoFrameCount;
        }
        this.currentVideoImage = image;
        this.currentVideoImageBytes = newVideoImageBytes;
    }

    public BufferedImage getCurrentVideoImage() {
        return this.currentVideoImage;
    }

    private int getCurrentVideoImageSize() {
        if (this.currentVideoImageBytes == null) {
            return this.jpegBufferSize;
        }
        return this.currentVideoImageBytes.length;
    }

    public int writeCurrentVideoImage(TPointer jpegBuffer, int jpegBufferSize) {
        this.lastVideoFrameCount = this.currentVideoFrameCount;
        if (this.currentVideoImageBytes == null) {
            if (jpegBuffer == null) {
                return 0;
            }
            jpegBuffer.clear(jpegBufferSize);
            return jpegBufferSize;
        }
        int length = Math.min(this.currentVideoImageBytes.length, jpegBufferSize);
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(jpegBuffer.getAddress(), length, 1);
        for (int i = 0; i < length; ++i) {
            memoryWriter.writeNext(this.currentVideoImageBytes[i] & 0xFF);
        }
        memoryWriter.flush();
        return length;
    }

    private void waitForNextVideoFrame() {
        long now = Emulator.getClock().currentTimeMillis();
        int millisSinceLastFrame = (int)(now - this.lastVideoFrameMillis);
        int frameDurationMillis = this.getFramerateFrameDurationMillis();
        if (millisSinceLastFrame >= 0 && millisSinceLastFrame < frameDurationMillis) {
            int delayMillis = frameDurationMillis - millisSinceLastFrame;
            Modules.ThreadManForUserModule.hleKernelDelayThread(delayMillis * 1000, false);
            this.lastVideoFrameMillis = now + (long)delayMillis;
        } else {
            this.lastVideoFrameMillis = now;
        }
    }

    @HLEUnimplemented
    @HLEFunction(nid=402109179, version=271)
    public int sceUsbCamSetupVideo(pspUsbCamSetupVideoParam usbCamSetupVideoParam, TPointer workArea, int workAreaSize) {
        this.workArea = workArea.getAddress();
        this.workAreaSize = workAreaSize;
        this.resolution = usbCamSetupVideoParam.resolution;
        this.frameRate = usbCamSetupVideoParam.framerate;
        this.whiteBalance = usbCamSetupVideoParam.wb;
        this.saturation = usbCamSetupVideoParam.saturation;
        this.brightness = usbCamSetupVideoParam.brightness;
        this.contrast = usbCamSetupVideoParam.contrast;
        this.sharpness = usbCamSetupVideoParam.sharpness;
        this.imageEffectMode = usbCamSetupVideoParam.effectmode;
        this.frameSize = usbCamSetupVideoParam.framesize;
        this.evLevel = usbCamSetupVideoParam.evlevel;
        if (!this.setupVideo()) {
            log.warn((Object)String.format("Cannot find webcam", new Object[0]));
            return -2145109758;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-113490327, version=271)
    public int sceUsbCamAutoImageReverseSW(boolean on) {
        this.autoImageReverseSW = on;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1464503359, version=271)
    public int sceUsbCamStartVideo() {
        if (!this.setupVideo()) {
            log.warn((Object)String.format("Cannot find webcam", new Object[0]));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1827876025, version=271)
    public int sceUsbCamStopVideo() {
        this.stopVideo();
        return 0;
    }

    @HLEFunction(nid=65895042, version=271)
    public int sceUsbCamSetupMic(pspUsbCamSetupMicParam camSetupMicParam, TPointer workArea, int workAreaSize) {
        this.micFrequency = camSetupMicParam.frequency;
        this.micGain = camSetupMicParam.gain;
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=-2103033808, version=271)
    public int sceUsbCamStartMic() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2108427377, version=271)
    public int sceUsbCamReadVideoFrameBlocking(TPointer jpegBuffer, int jpegBufferSize) {
        this.jpegBuffer = jpegBuffer;
        this.jpegBufferSize = jpegBufferSize;
        this.waitForNextVideoFrame();
        return this.writeCurrentVideoImage(jpegBuffer, jpegBufferSize);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1713872255, version=271)
    public int sceUsbCamReadVideoFrame(TPointer jpegBuffer, int jpegBufferSize) {
        this.jpegBuffer = jpegBuffer;
        this.jpegBufferSize = jpegBufferSize;
        return this.writeCurrentVideoImage(jpegBuffer, jpegBufferSize);
    }

    @HLEUnimplemented
    @HLEFunction(nid=1105673877, version=271)
    public int sceUsbCamPollReadVideoFrameEnd() {
        if (this.jpegBuffer == null || this.jpegBuffer.isNull()) {
            return -2145109748;
        }
        if (this.currentVideoFrameCount <= this.lastVideoFrameCount) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceUsbCamPollReadVideoFrameEnd not frame end (%d - %d)", this.currentVideoFrameCount, this.lastVideoFrameCount));
            }
            return -2145109746;
        }
        return this.writeCurrentVideoImage(this.jpegBuffer, this.jpegBufferSize);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-116710765, version=271)
    public int sceUsbCamWaitReadVideoFrameEnd() {
        this.waitForNextVideoFrame();
        return this.getCurrentVideoImageSize();
    }

    @HLEUnimplemented
    @HLEFunction(nid=1278539091, version=271)
    public boolean sceUsbCamGetLensDirection() {
        return this.lensDirectionAtYou;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1057813129, version=271)
    public int sceUsbCamSetupStill(pspUsbCamSetupStillParam usbCamSetupStillParam) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=172073624, version=271)
    public int sceUsbCamSetupStillEx(pspUsbCamSetupStillExParam usbCamSetupStillExParam) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1639865516, version=271)
    public int sceUsbCamStillInputBlocking(TPointer buffer, int size) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-83202979, version=271)
    public int sceUsbCamStillInput(TPointer buffer, int size) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1969467297, version=271)
    public int sceUsbCamStillWaitInputEnd() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=440848359, version=271)
    public int sceUsbCamStillPollInputEnd() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1491037316, version=271)
    public int sceUsbCamStillCancelInput() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-443179978, version=271)
    public int sceUsbCamStillGetInputLength() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-806753895, version=271)
    public int sceUsbCamSetupVideoEx(pspUsbCamSetupVideoExParam usbCamSetupVideoExParam, TPointer workArea, int workAreaSize) {
        this.workArea = workArea.getAddress();
        this.workAreaSize = workAreaSize;
        this.resolution = this.convertResolutionExToResolution(usbCamSetupVideoExParam.resolution);
        this.frameRate = usbCamSetupVideoExParam.framerate;
        this.whiteBalance = usbCamSetupVideoExParam.wb;
        this.saturation = usbCamSetupVideoExParam.saturation;
        this.brightness = usbCamSetupVideoExParam.brightness;
        this.contrast = usbCamSetupVideoExParam.contrast;
        this.sharpness = usbCamSetupVideoExParam.sharpness;
        this.imageEffectMode = usbCamSetupVideoExParam.effectmode;
        this.frameSize = usbCamSetupVideoExParam.framesize;
        this.evLevel = usbCamSetupVideoExParam.evlevel;
        if (!this.setupVideo()) {
            log.warn((Object)String.format("Cannot find webcam", new Object[0]));
            return -2145109758;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-543355758, version=271)
    public int sceUsbCamGetReadVideoFrameSize() {
        return this.jpegBufferSize;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1847613812, version=271)
    public int sceUsbCamSetSaturation(int saturation) {
        this.saturation = saturation;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1329431765, version=271)
    public int sceUsbCamSetBrightness(int brightness) {
        this.brightness = brightness;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=163736702, version=271)
    public int sceUsbCamSetContrast(int contrast) {
        this.contrast = contrast;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1647281100, version=271)
    public int sceUsbCamSetSharpness(int sharpness) {
        this.sharpness = sharpness;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-729325197, version=271)
    public int sceUsbCamSetImageEffectMode(int imageEffectMode) {
        this.imageEffectMode = imageEffectMode;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=493381744, version=271)
    public int sceUsbCamSetEvLevel(int evLevel) {
        this.evLevel = evLevel;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1793331723, version=271)
    public int sceUsbCamSetReverseMode(int reverseMode) {
        this.flip = (reverseMode & 1) != 0;
        this.mirror = (reverseMode & 0x100) != 0;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-997945313, version=271)
    public int sceUsbCamSetZoom(int zoom) {
        this.zoom = zoom;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=943628200, version=271)
    public int sceUsbCamGetSaturation(TPointer32 saturationAddr) {
        saturationAddr.setValue(this.saturation);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1895113413, version=271)
    public int sceUsbCamGetBrightness(TPointer32 brightnessAddr) {
        brightnessAddr.setValue(this.brightness);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1604081321, version=271)
    public int sceUsbCamGetContrast(TPointer32 contrastAddr) {
        contrastAddr.setValue(this.contrast);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-38368221, version=271)
    public int sceUsbCamGetSharpness(TPointer32 sharpnessAddr) {
        sharpnessAddr.setValue(this.sharpness);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1723567648, version=271)
    public int sceUsbCamGetImageEffectMode(TPointer32 imageEffectModeAddr) {
        imageEffectModeAddr.setValue(this.imageEffectMode);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=734875840, version=271)
    public int sceUsbCamGetEvLevel(TPointer32 evLevelAddr) {
        evLevelAddr.setValue(this.evLevel);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-718826695, version=271)
    public int sceUsbCamGetReverseMode(TPointer32 reverseModeAddr) {
        int reverseMode = 0;
        if (this.mirror) {
            reverseMode |= 0x100;
        }
        if (this.flip) {
            reverseMode |= 1;
        }
        reverseModeAddr.setValue(reverseMode);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1635078259, version=271)
    public int sceUsbCamGetZoom(TPointer32 zoomAddr) {
        zoomAddr.setValue(this.zoom);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=295825704, version=271)
    public boolean sceUsbCamGetAutoImageReverseState() {
        return this.autoImageReverseSW;
    }

    @HLEUnimplemented
    @HLEFunction(nid=145680778, version=271)
    public int sceUsbCamSetMicGain() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=781386340, version=271)
    public int sceUsbCamSetupMicEx(pspUsbCamSetupMicExParam camSetupMicExParam, TPointer workArea, int workAreaSize) {
        this.micFrequency = camSetupMicExParam.frequency;
        this.micGain = camSetupMicExParam.gain;
        return 0;
    }

    @HLEFunction(nid=912484645, version=271)
    public int sceUsbCamReadMicBlocking(TPointer buffer, int bufferSize) {
        return Modules.sceAudioModule.hleAudioInputBlocking(bufferSize >> 1, this.micFrequency, buffer);
    }

    @HLEUnimplemented
    @HLEFunction(nid=1035995278, version=271)
    public int sceUsbCamReadMic(TPointer buffer, int bufferSize) {
        this.readMicBuffer = buffer;
        this.readMicBufferSize = bufferSize;
        buffer.clear(bufferSize);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1106151319, version=271)
    public int sceUsbCamUnregisterLensRotationCallback() {
        return 0;
    }

    @HLEFunction(nid=1363510922, version=271)
    public int sceUsbCamStopMic() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1467528274, version=271)
    public int sceUsbCamGetMicDataLength() {
        return this.readMicBufferSize;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1736763048, version=271)
    public int sceUsbCamSetAntiFlicker() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1434610502, version=271)
    public int sceUsbCamGetAntiFlicker() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1337416067, version=271)
    public int sceUsbCamWaitReadMicEnd() {
        return Modules.sceAudioModule.hleAudioInputBlocking(this.readMicBufferSize >> 1, this.micFrequency, this.readMicBuffer);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-762076928, version=271)
    public int sceUsbCamRegisterLensRotationCallback() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-125534368, version=271)
    public int sceUsbCamPollReadMicEnd() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=513114440, version=271)
    public int sceUsbCamIoctl() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=6495494, version=271)
    public int sceUsbCam_00631D06() {
        return 0;
    }

    protected class VideoReaderThread
    extends Thread {
        private IMediaReader reader;
        private volatile boolean end;

        public VideoReaderThread(IMediaReader reader) {
            this.reader = reader;
        }

        public void end() {
            this.end = true;
        }

        @Override
        public void run() {
            while (!this.end) {
                this.reader.readPacket();
            }
            this.reader.close();
        }
    }

    protected class VideoListener
    extends MediaListenerAdapter {
        IMediaReader reader;
        int videoStream;
        IStreamCoder videoCoder;
        IConverter videoConverter;
        IVideoResampler videoResampler;
        IVideoPicture videoPicture;
        VideoReaderThread videoReaderThread;

        public VideoListener(IMediaReader reader, int width, int height) {
            this.reader = reader;
            IContainer container = reader.getContainer();
            int numStreams = container.getNumStreams();
            for (int i = 0; i < numStreams; ++i) {
                IStream stream = container.getStream((long)i);
                IStreamCoder coder = stream.getStreamCoder();
                if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
                this.videoStream = i;
                this.videoCoder = coder;
            }
            if (this.videoCoder != null) {
                this.videoConverter = ConverterFactory.createConverter((String)"XUGGLER-BGR-24", (IPixelFormat.Type)this.videoCoder.getPixelType(), (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight());
                this.videoPicture = IVideoPicture.make((IPixelFormat.Type)this.videoCoder.getPixelType(), (int)width, (int)height);
                this.videoResampler = IVideoResampler.make((int)width, (int)height, (IPixelFormat.Type)this.videoCoder.getPixelType(), (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight(), (IPixelFormat.Type)this.videoCoder.getPixelType());
            }
            this.videoReaderThread = new VideoReaderThread(reader);
            this.videoReaderThread.setName("Video Reader Thread");
            this.videoReaderThread.setDaemon(true);
            this.videoReaderThread.start();
        }

        public void stop() {
            this.videoReaderThread.end();
        }

        public void onVideoPicture(IVideoPictureEvent event) {
            BufferedImage image = event.getImage();
            if (image == null && this.videoConverter != null) {
                IVideoPicture eventPicture = event.getPicture();
                this.videoResampler.resample(this.videoPicture, eventPicture);
                try {
                    image = this.videoConverter.toImage(this.videoPicture);
                }
                catch (RuntimeException e) {
                    if (this.videoPicture.getPixelType() == IPixelFormat.Type.YUYV422) {
                        image = sceUsbCam.this.convertYUYV422toRGB(this.videoPicture.getWidth(), this.videoPicture.getHeight(), this.videoPicture.getByteBuffer());
                    }
                    log.error((Object)String.format("VideoListener.onVideoPicture: %s", this.videoPicture), (Throwable)e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("onVideoPicture event=%s, image=%s", event, image));
            }
            if (image != null) {
                sceUsbCam.this.setCurrentVideoImage(image);
            }
        }
    }
}

