/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.protocols;

import java.io.EOFException;
import jpcsp.network.protocols.NetPacket;
import jpcsp.util.Utilities;

public class DNS {
    public static final int DNS_RESOURCE_RECORD_CLASS_IN = 1;
    public static final int DNS_RESOURCE_RECORD_TYPE_A = 1;
    public static final int DNS_RESPONSE_CODE_NO_ERROR = 0;
    public static final int DNS_RESPONSE_CODE_NAME_ERROR = 3;
    public int identifier;
    public boolean isResponseFlag;
    public int opcode;
    public boolean authoritativeAnswer;
    public boolean truncationFlag;
    public boolean recursionDesired;
    public boolean recursionAvailable;
    public int zero;
    public int responseCode;
    public int questionCount;
    public int answerRecordCount;
    public int authorityRecordCount;
    public int additionalRecordCount;
    public DNSRecord[] questions;
    public DNSAnswerRecord[] answerRecords;
    public DNSAnswerRecord[] authorityRecords;
    public DNSAnswerRecord[] additionalRecords;

    public DNS() {
    }

    public DNS(DNS dns) {
        this.identifier = dns.identifier;
        this.isResponseFlag = dns.isResponseFlag;
        this.opcode = dns.opcode;
        this.authoritativeAnswer = dns.authoritativeAnswer;
        this.truncationFlag = dns.truncationFlag;
        this.recursionDesired = dns.recursionDesired;
        this.recursionAvailable = dns.recursionAvailable;
        this.zero = dns.zero;
        this.responseCode = dns.responseCode;
        this.questionCount = dns.questionCount;
        this.answerRecordCount = dns.answerRecordCount;
        this.authorityRecordCount = dns.authorityRecordCount;
        this.additionalRecordCount = dns.additionalRecordCount;
        this.questions = dns.questions;
        this.answerRecords = dns.answerRecords;
        this.authorityRecords = dns.authorityRecords;
        this.additionalRecords = dns.additionalRecords;
    }

    private DNSRecord[] readRecords(NetPacket packet, int count) throws EOFException {
        DNSRecord[] records = new DNSRecord[count];
        for (int i = 0; i < count; ++i) {
            records[i] = new DNSRecord();
            records[i].read(packet);
        }
        return records;
    }

    private DNSAnswerRecord[] readAnswerRecords(NetPacket packet, int count) throws EOFException {
        DNSAnswerRecord[] records = new DNSAnswerRecord[count];
        for (int i = 0; i < count; ++i) {
            records[i] = new DNSAnswerRecord();
            records[i].read(packet);
        }
        return records;
    }

    public void read(NetPacket packet) throws EOFException {
        this.identifier = packet.read16();
        this.isResponseFlag = packet.readBoolean();
        this.opcode = packet.readBits(4);
        this.authoritativeAnswer = packet.readBoolean();
        this.truncationFlag = packet.readBoolean();
        this.recursionDesired = packet.readBoolean();
        this.recursionAvailable = packet.readBoolean();
        this.zero = packet.readBits(3);
        this.responseCode = packet.readBits(4);
        this.questionCount = packet.read16();
        this.answerRecordCount = packet.read16();
        this.authorityRecordCount = packet.read16();
        this.additionalRecordCount = packet.read16();
        this.questions = this.readRecords(packet, this.questionCount);
        this.answerRecords = this.readAnswerRecords(packet, this.answerRecordCount);
        this.authorityRecords = this.readAnswerRecords(packet, this.authorityRecordCount);
        this.additionalRecords = this.readAnswerRecords(packet, this.additionalRecordCount);
    }

    private void writeRecords(NetPacket packet, int recordsCount, DNSRecord[] records) throws EOFException {
        for (int i = 0; i < recordsCount; ++i) {
            records[i].write(packet);
        }
    }

    public NetPacket write(NetPacket packet) throws EOFException {
        packet.write16(this.identifier);
        packet.writeBoolean(this.isResponseFlag);
        packet.writeBits(this.opcode, 4);
        packet.writeBoolean(this.authoritativeAnswer);
        packet.writeBoolean(this.truncationFlag);
        packet.writeBoolean(this.recursionDesired);
        packet.writeBoolean(this.recursionAvailable);
        packet.writeBits(this.zero, 3);
        packet.writeBits(this.responseCode, 4);
        packet.write16(this.questionCount);
        packet.write16(this.answerRecordCount);
        packet.write16(this.authorityRecordCount);
        packet.write16(this.additionalRecordCount);
        this.writeRecords(packet, this.questionCount, this.questions);
        this.writeRecords(packet, this.answerRecordCount, this.answerRecords);
        this.writeRecords(packet, this.authorityRecordCount, this.authorityRecords);
        this.writeRecords(packet, this.additionalRecordCount, this.additionalRecords);
        return packet;
    }

    public NetPacket write() throws EOFException {
        return this.write(new NetPacket(this.sizeOf()));
    }

    private int sizeOf(int recordsCount, DNSRecord[] records) {
        int size = 0;
        for (int i = 0; i < recordsCount; ++i) {
            size += records[i].sizeOf();
        }
        return size;
    }

    public int sizeOf() {
        int size = 12;
        size += this.sizeOf(this.questionCount, this.questions);
        size += this.sizeOf(this.answerRecordCount, this.answerRecords);
        size += this.sizeOf(this.authorityRecordCount, this.authorityRecords);
        return size += this.sizeOf(this.additionalRecordCount, this.additionalRecords);
    }

    private void toString(StringBuilder s, String prefix, int recordsCount, DNSRecord[] records) {
        for (int i = 0; i < recordsCount; ++i) {
            s.append(String.format(", %s#%d[%s]", prefix, i, records[i]));
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(String.format("identifier=0x%04X, isResponseFlag=%b, opcode=0x%X, authoritativeAnswer=%b, truncationFlag=%b, recursionDesired=%b, recursionAvailable=%b, zero=0x%X, responseCode=0x%X, questionCount=%d, answerRecordCount=%d, authorityRecordCount=%d, additionalRecordCount=%d", this.identifier, this.isResponseFlag, this.opcode, this.authoritativeAnswer, this.truncationFlag, this.recursionDesired, this.recursionAvailable, this.zero, this.responseCode, this.questionCount, this.answerRecordCount, this.authorityRecordCount, this.additionalRecordCount));
        this.toString(s, "question", this.questionCount, this.questions);
        this.toString(s, "answerRecord", this.answerRecordCount, this.answerRecords);
        this.toString(s, "authorityRecord", this.authorityRecordCount, this.authorityRecords);
        this.toString(s, "additionalRecord", this.additionalRecordCount, this.additionalRecords);
        return s.toString();
    }

    public static class DNSAnswerRecord
    extends DNSRecord {
        public int ttl;
        public int dataLength;
        public byte[] data;

        @Override
        public void read(NetPacket packet) throws EOFException {
            super.read(packet);
            this.ttl = packet.read32();
            this.dataLength = packet.read16();
            this.data = packet.readBytes(this.dataLength);
        }

        @Override
        public NetPacket write(NetPacket packet) throws EOFException {
            super.write(packet);
            packet.write32(this.ttl);
            packet.write16(this.dataLength);
            packet.writeBytes(this.data, 0, this.dataLength);
            return packet;
        }

        @Override
        public int sizeOf() {
            return super.sizeOf() + 6 + this.dataLength;
        }

        @Override
        public String toString() {
            return String.format("%s, ttl=0x%X, dataLength=0x%X, data=%s", super.toString(), this.ttl, this.dataLength, Utilities.getMemoryDump(this.data, 0, this.dataLength));
        }
    }

    public static class DNSRecord {
        public String recordName;
        public int recordType;
        public int recordClass;

        public void read(NetPacket packet) throws EOFException {
            this.recordName = packet.readDnsNameNotation();
            this.recordType = packet.read16();
            this.recordClass = packet.read16();
        }

        public NetPacket write(NetPacket packet) throws EOFException {
            packet.writeDnsNameNotation(this.recordName);
            packet.write16(this.recordType);
            packet.write16(this.recordClass);
            return packet;
        }

        public int sizeOf() {
            if (this.recordName == null || this.recordName.length() == 0) {
                return 5;
            }
            return this.recordName.length() + 6;
        }

        public String toString() {
            return String.format("recordName='%s', recordType=0x%X, recordClass=0x%X", this.recordName, this.recordType, this.recordClass);
        }
    }
}

