/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceMd5
extends HLEModule {
    public static Logger log = Modules.getLogger("sceMd5");
    protected MessageDigest md5;

    @Override
    public void start() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Cannot find MD5", (Throwable)e);
        }
        super.start();
    }

    @Override
    public void stop() {
        this.md5 = null;
        super.stop();
    }

    protected static byte[] getMemoryBytes(int address, int size) {
        byte[] bytes = new byte[size];
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, size, 1);
        for (int i = 0; i < size; ++i) {
            bytes[i] = (byte)memoryReader.readNext();
        }
        return bytes;
    }

    protected static void writeMd5Digest(int address, byte[] digest) {
        int i;
        int digestLength = 16;
        int size = digest == null ? 0 : Math.min(digest.length, 16);
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(address, 16, 1);
        for (i = 0; i < size; ++i) {
            memoryWriter.writeNext(digest[i] & 0xFF);
        }
        for (i = size; i < 16; ++i) {
            memoryWriter.writeNext(0);
        }
        memoryWriter.flush();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("return MD5 digest: %s", Utilities.getMemoryDump(address, 16)));
        }
    }

    @HLELogging(level="info")
    @HLEFunction(nid=428362261, version=150)
    public int sceMd5BlockInit(TPointer contextAddr) {
        this.md5.reset();
        contextAddr.setValue32(0, 1732584193);
        contextAddr.setValue32(4, -271733879);
        contextAddr.setValue32(8, -1732584194);
        contextAddr.setValue32(12, 271733878);
        contextAddr.setValue16(20, (short)0);
        contextAddr.setValue16(22, (short)0);
        contextAddr.setValue32(24, 0);
        contextAddr.setValue32(28, 0);
        return 0;
    }

    @HLEFunction(nid=-1560148286, version=150)
    public int sceMd5BlockUpdate(TPointer contextAddr, TPointer sourceAddr, int size) {
        byte[] source = sceMd5.getMemoryBytes(sourceAddr.getAddress(), size);
        this.md5.update(source);
        return 0;
    }

    @HLEFunction(nid=1215737855, version=150)
    public int sceMd5BlockResult(TPointer contextAddr, TPointer resultAddr) {
        byte[] result = this.md5.digest();
        sceMd5.writeMd5Digest(resultAddr.getAddress(), result);
        return 0;
    }

    @HLEFunction(nid=-1729946978, version=150)
    public int sceMd5Digest(TPointer sourceAddr, int size, TPointer resultAddr) {
        byte[] source = sceMd5.getMemoryBytes(sourceAddr.getAddress(), size);
        this.md5.reset();
        byte[] result = this.md5.digest(source);
        sceMd5.writeMd5Digest(resultAddr.getAddress(), result);
        return 0;
    }
}

