/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.modules.sceI2c;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.memory.mmio.cy27040.CY27040;
import jpcsp.memory.mmio.wm1801.WM1801;
import jpcsp.memory.mmio.wm8750.WM8750;
import jpcsp.scheduler.Scheduler;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MMIOHandlerI2c
extends MMIOHandlerBase {
    public static Logger log = sceI2c.log;
    private static final int STATE_VERSION = 0;
    public static final int PSP_CY27040_I2C_ADDR = 210;
    public static final int PSP_WM8750_I2C_ADDR = 52;
    public static final int PSP_WM1801_I2C_ADDR = 148;
    private static final int INTERRUPT_FLAG = 1;
    private int i2cAddress;
    private int dataLength;
    private int[] transmitData = new int[16];
    private int[] receiveData = new int[16];
    private int dataIndex = -1;
    private int interrupt;
    private final IAction completeCommandAction = new CompleteCommandAction();

    public MMIOHandlerI2c(int baseAddress) {
        super(baseAddress);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.i2cAddress = stream.readInt();
        this.dataLength = stream.readInt();
        this.dataIndex = stream.readInt();
        this.interrupt = stream.readInt();
        stream.readInts(this.transmitData);
        stream.readInts(this.receiveData);
        CY27040.getInstance().read(stream);
        WM8750.getInstance().read(stream);
        WM1801.getInstance().read(stream);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.i2cAddress);
        stream.writeInt(this.dataLength);
        stream.writeInt(this.dataIndex);
        stream.writeInt(this.interrupt);
        stream.writeInts(this.transmitData);
        stream.writeInts(this.receiveData);
        CY27040.getInstance().write(stream);
        WM8750.getInstance().write(stream);
        WM1801.getInstance().write(stream);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.i2cAddress = 0;
        this.dataLength = 0;
        this.dataIndex = -1;
        this.interrupt = 0;
        Arrays.fill(this.transmitData, 0);
        Arrays.fill(this.receiveData, 0);
        CY27040.getInstance().reset();
        WM8750.getInstance().reset();
        WM1801.getInstance().reset();
    }

    private void writeData(int value) {
        if (this.dataIndex < 0) {
            this.i2cAddress = value;
        } else {
            this.transmitData[this.dataIndex] = value & 0xFF;
        }
        ++this.dataIndex;
    }

    private int readData() {
        ++this.dataIndex;
        int value = this.receiveData[this.dataIndex];
        return value;
    }

    private void writeDataLength(int value) {
        this.dataLength = value;
        this.dataIndex = -1;
    }

    private void checkInterrupt() {
        if (Utilities.hasFlag(this.interrupt, 1)) {
            RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 12);
        } else {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), 12);
        }
    }

    private void completeCommand() {
        this.interrupt = Utilities.setFlag(this.interrupt, 1);
        this.checkInterrupt();
    }

    private void clearInterrupt(int value) {
        this.interrupt = Utilities.clearFlag(this.interrupt, value);
        this.checkInterrupt();
    }

    private void startCommand(int command) {
        int delayCompleteCommand = 0;
        block0 : switch (command) {
            case 133: {
                break;
            }
            case 138: {
                switch (this.i2cAddress ^ 1) {
                    case 210: {
                        CY27040.getInstance().executeTransmitReceiveCommand(this.transmitData, this.receiveData);
                        delayCompleteCommand = 10000;
                        break block0;
                    }
                    case 52: {
                        WM8750.getInstance().executeTransmitReceiveCommand(this.transmitData, this.receiveData);
                        break block0;
                    }
                    case 148: {
                        WM1801.getInstance().executeTransmitReceiveCommand(this.transmitData, this.receiveData);
                        break block0;
                    }
                }
                log.error((Object)String.format("MMIOHandlerI2c.startCommand 0x%X unknown i2cAddress=0x%X", command, this.i2cAddress));
                return;
            }
            case 135: {
                switch (this.i2cAddress) {
                    case 210: {
                        CY27040.getInstance().executeTransmitCommand(this.transmitData);
                        break block0;
                    }
                    case 52: {
                        WM8750.getInstance().executeTransmitCommand(this.transmitData);
                        break block0;
                    }
                    case 148: {
                        WM1801.getInstance().executeTransmitCommand(this.transmitData);
                        break block0;
                    }
                }
                log.error((Object)String.format("MMIOHandlerI2c.startCommand 0x%X unknown i2cAddress=0x%X", command, this.i2cAddress));
                return;
            }
            default: {
                log.error((Object)String.format("MMIOHandlerI2c.startCommand unknown command=0x%X", command));
                return;
            }
        }
        if (delayCompleteCommand > 0) {
            Scheduler.getInstance().addAction(Scheduler.getNow() + (long)delayCompleteCommand, this.completeCommandAction);
        } else {
            this.completeCommand();
        }
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = 0;
                break;
            }
            case 4: {
                value = 0;
                break;
            }
            case 8: {
                value = this.dataLength;
                break;
            }
            case 12: {
                value = this.readData();
                break;
            }
            case 16: {
                value = 0;
                break;
            }
            case 20: {
                value = 0;
                break;
            }
            case 28: {
                value = 0;
                break;
            }
            case 40: {
                value = this.interrupt;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 4: {
                this.startCommand(value);
                break;
            }
            case 8: {
                this.writeDataLength(value);
                break;
            }
            case 12: {
                this.writeData(value);
                break;
            }
            case 16: {
                break;
            }
            case 20: {
                break;
            }
            case 28: {
                break;
            }
            case 40: {
                this.clearInterrupt(value);
                break;
            }
            case 44: {
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    @Override
    public String toString() {
        return String.format("i2cAddress=0x%X", this.i2cAddress);
    }

    private class CompleteCommandAction
    implements IAction {
        private CompleteCommandAction() {
        }

        @Override
        public void execute() {
            MMIOHandlerI2c.this.completeCommand();
        }
    }
}

