/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.Iterator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelMutexInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import org.apache.log4j.Logger;

public class MutexManager {
    public static Logger log = ThreadManForUser.log;
    private HashMap<Integer, SceKernelMutexInfo> mutexMap;
    private MutexWaitStateChecker mutexWaitStateChecker;
    public static final int PSP_MUTEX_ATTR_FIFO = 0;
    public static final int PSP_MUTEX_ATTR_PRIORITY = 256;
    private static final int PSP_MUTEX_ATTR_ALLOW_RECURSIVE = 512;
    public static final MutexManager singleton = new MutexManager();

    public void reset() {
        this.mutexMap = new HashMap();
        this.mutexWaitStateChecker = new MutexWaitStateChecker();
    }

    private boolean removeWaitingThread(SceKernelThreadInfo thread) {
        SceKernelMutexInfo info = this.mutexMap.get(thread.wait.Mutex_id);
        if (info == null) {
            return false;
        }
        info.threadWaitingList.removeWaitingThread(thread);
        return true;
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352152;
        } else {
            log.warn((Object)"Mutex deleted while we were waiting for it! (timeout expired)");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352150;
        } else {
            log.warn((Object)"EventFlag deleted while we were waiting for it!");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        if (thread.isWaitingForType(12)) {
            this.removeWaitingThread(thread);
        }
        for (SceKernelMutexInfo info : this.mutexMap.values()) {
            if (info.threadid != thread.uid) continue;
            log.info((Object)String.format("onThreadDeleted: thread %s owning mutex %s", thread, info));
        }
    }

    private void onMutexDeletedCancelled(int mid, int result) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingFor(12, mid)) continue;
            thread.cpuContext._v0 = result;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onMutexDeleted(int mid) {
        this.onMutexDeletedCancelled(mid, -2147352139);
    }

    private void onMutexCancelled(int mid) {
        this.onMutexDeletedCancelled(mid, -2147352151);
    }

    private void onMutexModified(SceKernelMutexInfo info) {
        SceKernelThreadInfo thread;
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        SceKernelThreadInfo checkedThread = null;
        while ((thread = info.threadWaitingList.getNextWaitingThread(checkedThread)) != null) {
            if (this.tryLockMutex(info, thread.wait.Mutex_count, thread)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("onMutexModified waking thread %s", thread));
                }
                info.threadWaitingList.removeWaitingThread(thread);
                thread.cpuContext._v0 = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
                continue;
            }
            checkedThread = thread;
        }
        if (reschedule) {
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        }
    }

    private boolean tryLockMutex(SceKernelMutexInfo info, int count, SceKernelThreadInfo thread) {
        if (info.lockedCount == 0) {
            info.threadid = thread.uid;
            info.lockedCount += count;
            return true;
        }
        if (info.threadid == thread.uid && (info.attr & 0x200) == 512) {
            info.lockedCount += count;
            return true;
        }
        return false;
    }

    public int sceKernelCreateMutex(PspString name, int attr, int count, int option_addr) {
        if (count < 0 || count > 1 && (attr & 0x200) == 0) {
            return -2147352131;
        }
        SceKernelMutexInfo info = new SceKernelMutexInfo(name.getString(), count, attr);
        this.mutexMap.put(info.uid, info);
        return info.uid;
    }

    public int sceKernelDeleteMutex(int uid) {
        SceKernelMutexInfo info = this.mutexMap.remove(uid);
        if (info == null) {
            log.warn((Object)("sceKernelDeleteMutex unknown UID " + Integer.toHexString(uid)));
            return -2147352125;
        }
        this.onMutexDeleted(uid);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int hleKernelLockMutex(int uid, int count, int timeout_addr, boolean wait, boolean doCallbacks) {
        SceKernelMutexInfo info = this.mutexMap.get(uid);
        if (info == null) {
            log.warn((Object)String.format("hleKernelLockMutex uid=%d, count=%d, timeout_addr=0x%08X, wait=%b, doCallbacks=%b - unknown UID", uid, count, timeout_addr, wait, doCallbacks));
            return -2147352125;
        }
        if (count <= 0) {
            log.warn((Object)String.format("hleKernelLockMutex uid=%d, count=%d, timeout_addr=0x%08X, wait=%b, doCallbacks=%b - illegal count", uid, count, timeout_addr, wait, doCallbacks));
            return -2147352131;
        }
        if (count > 1 && (info.attr & 0x200) == 0) {
            log.warn((Object)String.format("hleKernelLockMutex uid=%d, count=%d, timeout_addr=0x%08X, wait=%b, doCallbacks=%b - illegal count", uid, count, timeout_addr, wait, doCallbacks));
            return -2147352131;
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
        if (this.tryLockMutex(info, count, currentThread)) {
            if (!log.isDebugEnabled()) return 0;
            log.debug((Object)String.format("hleKernelLockMutex %s, count=%d, timeout_addr=0x%08X, wait=%b, doCallbacks=%b - fast check succeeded", info.toString(), count, timeout_addr, wait, doCallbacks));
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelLockMutex %s, count=%d, timeout_addr=0x%08X, wait=%b, doCallbacks=%b - fast check failed", info.toString(), count, timeout_addr, wait, doCallbacks));
        }
        if (wait && info.threadid != currentThread.uid) {
            info.threadWaitingList.addWaitingThread(currentThread);
            currentThread.wait.Mutex_id = uid;
            currentThread.wait.Mutex_count = count;
            threadMan.hleKernelThreadEnterWaitState(12, uid, this.mutexWaitStateChecker, timeout_addr, doCallbacks);
            return 0;
        }
        if ((info.attr & 0x200) == 512) return -2147352124;
        return -2147352120;
    }

    public int sceKernelLockMutex(int uid, int count, int timeout_addr) {
        return this.hleKernelLockMutex(uid, count, timeout_addr, true, false);
    }

    public int sceKernelLockMutexCB(int uid, int count, int timeout_addr) {
        return this.hleKernelLockMutex(uid, count, timeout_addr, true, true);
    }

    public int sceKernelTryLockMutex(int uid, int count) {
        return this.hleKernelLockMutex(uid, count, 0, false, false);
    }

    public int sceKernelUnlockMutex(int uid, int count) {
        SceKernelMutexInfo info = this.mutexMap.get(uid);
        if (info == null) {
            log.warn((Object)"sceKernelUnlockMutex unknown uid");
            return -2147352125;
        }
        if (info.lockedCount == 0) {
            log.debug((Object)"sceKernelUnlockMutex not locked");
            return -2147352123;
        }
        if (info.lockedCount - count < 0) {
            log.warn((Object)"sceKernelUnlockMutex underflow");
            return -2147352121;
        }
        info.lockedCount -= count;
        if (info.lockedCount == 0) {
            info.threadid = -1;
            this.onMutexModified(info);
        }
        return 0;
    }

    public int sceKernelCancelMutex(int uid, int newcount, TPointer32 numWaitThreadAddr) {
        SceKernelMutexInfo info = this.mutexMap.get(uid);
        if (info == null) {
            log.warn((Object)("sceKernelCancelMutex unknown UID " + Integer.toHexString(uid)));
            return -2147352125;
        }
        if (info.lockedCount == 0) {
            log.warn((Object)("sceKernelCancelMutex UID " + Integer.toHexString(uid) + " not locked"));
            return -1;
        }
        if (newcount < 0) {
            newcount = info.initCount;
        }
        if (newcount > 1 && (info.attr & 0x200) == 0) {
            log.warn((Object)String.format("sceKernelCancelMutex uid=%d, newcount=%d - illegal count", uid, newcount));
            return -2147352131;
        }
        numWaitThreadAddr.setValue(info.getNumWaitingThreads());
        info.threadWaitingList.removeAllWaitingThreads();
        info.lockedCount = newcount;
        this.onMutexCancelled(uid);
        return 0;
    }

    public int sceKernelReferMutexStatus(int uid, TPointer addr) {
        SceKernelMutexInfo info = this.mutexMap.get(uid);
        if (info == null) {
            log.warn((Object)("sceKernelReferMutexStatus unknown UID " + Integer.toHexString(uid)));
            return -2147352125;
        }
        info.write(addr);
        return 0;
    }

    private MutexManager() {
    }

    private class MutexWaitStateChecker
    implements IWaitStateChecker {
        private MutexWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelMutexInfo info = (SceKernelMutexInfo)MutexManager.this.mutexMap.get(wait.Mutex_id);
            if (info == null) {
                thread.cpuContext._v0 = -2147352125;
                return false;
            }
            if (MutexManager.this.tryLockMutex(info, wait.Mutex_count, thread)) {
                info.threadWaitingList.removeWaitingThread(thread);
                thread.cpuContext._v0 = 0;
                return false;
            }
            return true;
        }
    }
}

