/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.fat;

import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.VFS.fat.FatFileInfo;
import jpcsp.HLE.VFS.fat.FatUtils;
import jpcsp.HLE.VFS.fat.FatVirtualFile;
import jpcsp.util.Utilities;

public class Fat12VirtualFile
extends FatVirtualFile {
    private static final int numberOfRootDirectoryEntries = 512;

    public Fat12VirtualFile(String deviceName, IVirtualFileSystem vfs, int totalSectors) {
        super(deviceName, vfs, totalSectors);
        this.setFsInfoSectorNumber(-1);
    }

    @Override
    protected int getClusterMask() {
        return 4095;
    }

    @Override
    protected int getFatEOC() {
        return 4088;
    }

    @Override
    protected String getOEMName() {
        return "6600-FAT";
    }

    @Override
    protected int getSectorsPerCluster() {
        return 32;
    }

    @Override
    protected int getFatSectors(int totalSectors, int sectorsPerCluster) {
        return 32;
    }

    @Override
    protected void readBIOSParameterBlock() {
        FatUtils.storeSectorInt16(this.currentSector, 11, 512);
        FatUtils.storeSectorInt8(this.currentSector, 13, this.getSectorsPerCluster());
        FatUtils.storeSectorInt16(this.currentSector, 14, 32);
        FatUtils.storeSectorInt8(this.currentSector, 16, 2);
        FatUtils.storeSectorInt16(this.currentSector, 17, 512);
        if (this.totalSectors < 65536) {
            FatUtils.storeSectorInt16(this.currentSector, 19, this.totalSectors);
        } else {
            FatUtils.storeSectorInt16(this.currentSector, 19, 0);
        }
        FatUtils.storeSectorInt8(this.currentSector, 21, 248);
        int fatSectors = this.getFatSectors(this.totalSectors, this.getSectorsPerCluster());
        FatUtils.storeSectorInt16(this.currentSector, 22, fatSectors);
        FatUtils.storeSectorInt16(this.currentSector, 24, 32);
        FatUtils.storeSectorInt16(this.currentSector, 26, 64);
        FatUtils.storeSectorInt32(this.currentSector, 28, 0);
        if (this.totalSectors < 65536) {
            FatUtils.storeSectorInt32(this.currentSector, 32, 4);
        } else {
            FatUtils.storeSectorInt32(this.currentSector, 32, this.totalSectors);
        }
        FatUtils.storeSectorInt8(this.currentSector, 36, 128);
        FatUtils.storeSectorInt8(this.currentSector, 37, 0);
        FatUtils.storeSectorInt8(this.currentSector, 38, 41);
        FatUtils.storeSectorInt32(this.currentSector, 39, 0x6060002);
        FatUtils.storeSectorString(this.currentSector, 43, "NO NAME", 11);
        FatUtils.storeSectorString(this.currentSector, 54, "FAT12", 8);
    }

    private void storeFatByte(int offset, int value) {
        if (offset >= 0 && offset < 512) {
            FatUtils.storeSectorInt8(this.currentSector, offset, value & 0xFF);
        }
    }

    @Override
    protected void readFatSector(int fatIndex) {
        int startIndex;
        this.readEmptySector();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Fat12VirtualFile.readFatSector fatIndex=0x%X", fatIndex));
        }
        int offset = fatIndex * 512 / 3 * 2;
        int i = startIndex = offset / 2 * 3 - fatIndex * 512;
        int j = 0;
        while (i < 512) {
            int value = 0;
            if (offset + j < this.fatClusterMap.length) {
                value = this.fatClusterMap[offset + j];
                if (offset + j + 1 < this.fatClusterMap.length) {
                    value |= this.fatClusterMap[offset + j + 1] << 12;
                }
            }
            this.storeFatByte(i, value);
            this.storeFatByte(++i, value >> 8);
            this.storeFatByte(++i, value >> 16);
            ++i;
            j += 2;
        }
    }

    private int readFatEntry0(int offset) {
        return FatUtils.readSectorInt8(this.currentSector, offset) | (FatUtils.readSectorInt8(this.currentSector, offset + 1) & 0xF) << 8;
    }

    private int readFatEntry1(int offset) {
        return FatUtils.readSectorInt8(this.currentSector, offset + 1) >> 4 | FatUtils.readSectorInt8(this.currentSector, offset + 2) << 4;
    }

    @Override
    protected void writeFatSector(int fatIndex) {
        int index = Utilities.alignDown(fatIndex * 512 * 2 / 3, 1);
        int offset = index / 2 * 3 - fatIndex * 512;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Fat12VirtualFile.writeFatSector fatIndex=0x%X, index=0x%X, offset=0x%X", fatIndex, index, offset));
        }
        while (offset < 512 && index < this.fatClusterMap.length) {
            int fatEntry;
            if (offset >= 0 && offset + 1 < 512 && index < this.fatClusterMap.length && (fatEntry = this.readFatEntry0(offset)) != this.fatClusterMap[index]) {
                this.writeFatSectorEntry(index, fatEntry);
            }
            if (offset >= -1 && offset + 2 < 512 && ++index < this.fatClusterMap.length && (fatEntry = this.readFatEntry1(offset)) != this.fatClusterMap[index]) {
                this.writeFatSectorEntry(index, fatEntry);
            }
            ++index;
            offset += 3;
        }
    }

    @Override
    protected int getFirstDataClusterOffset() {
        return 32;
    }

    @Override
    protected void setRootDirectory(FatFileInfo rootDirectory) {
        this.rootDirectoryStartSectorNumber = this.getFatSectorNumber() + 2 * this.fatSectors;
        this.rootDirectoryEndSectorNumber = this.rootDirectoryStartSectorNumber + this.getFirstDataClusterOffset() - 1;
        this.rootDirectory = rootDirectory;
    }
}

