/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.type;

import java.awt.image.BufferedImage;
import jpcsp.format.rco.RCOContext;
import jpcsp.format.rco.object.BaseObject;
import jpcsp.format.rco.object.BasePositionObject;
import jpcsp.format.rco.type.BaseType;

public class BaseReferenceType
extends BaseType {
    protected static final int REFERENCE_TYPE_NONE = 65535;
    protected static final int REFERENCE_TYPE_EVENT = 1024;
    protected static final int REFERENCE_TYPE_TEXT = 1025;
    protected static final int REFERENCE_TYPE_IMAGE = 1026;
    protected static final int REFERENCE_TYPE_MODEL = 1027;
    protected static final int REFERENCE_TYPE_FONT = 1029;
    protected static final int REFERENCE_TYPE_OBJECT = 1031;
    protected static final int REFERENCE_TYPE_ANIM = 1032;
    protected static final int REFERENCE_TYPE_POSITION_OBJECT = 1033;
    public int referenceType;
    public int unknownShort;
    protected String event;
    protected BaseObject object;
    protected BufferedImage image;

    @Override
    public int size() {
        return 8;
    }

    @Override
    public void read(RCOContext context) {
        this.referenceType = this.read16(context);
        this.unknownShort = this.read16(context);
        super.read(context);
    }

    @Override
    public void init(RCOContext context) {
        switch (this.referenceType) {
            case 65535: {
                break;
            }
            case 1024: {
                this.event = context.events.get(this.value);
                break;
            }
            case 1031: 
            case 1032: 
            case 1033: {
                this.object = context.objects.get(this.value);
                break;
            }
            case 1026: {
                this.image = context.images.get(this.value);
                break;
            }
            default: {
                log.warn((Object)String.format("BaseReferenceType: unknown referenceType 0x%X(%s)", this.referenceType, BaseReferenceType.getReferenceTypeString(this.referenceType)));
            }
        }
        super.init(context);
    }

    private static String getReferenceTypeString(int referenceType) {
        switch (referenceType) {
            case 65535: {
                return "NONE";
            }
            case 1024: {
                return "EVENT";
            }
            case 1025: {
                return "TEXT";
            }
            case 1026: {
                return "IMAGE";
            }
            case 1027: {
                return "MODEL";
            }
            case 1029: {
                return "FONT";
            }
            case 1031: {
                return "OBJECT";
            }
            case 1032: {
                return "ANIM";
            }
            case 1033: {
                return "POSITION_OBJECT";
            }
        }
        return "UNKNOWN";
    }

    public String getEvent() {
        return this.event;
    }

    public BaseObject getObject() {
        return this.object;
    }

    public BasePositionObject getPositionObject() {
        if (this.object instanceof BasePositionObject) {
            return (BasePositionObject)this.object;
        }
        return null;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(String.format("referenceType=0x%X(%s), short1=0x%X, value=0x%X", this.referenceType, BaseReferenceType.getReferenceTypeString(this.referenceType), this.unknownShort, this.value));
        if (this.event != null) {
            s.append(String.format(", event='%s'", this.event));
        }
        if (this.object != null) {
            s.append(String.format(", object='%s'", this.object.getName()));
        }
        if (this.image != null) {
            s.append(String.format(", image=%dx%d", this.image.getWidth(), this.image.getHeight()));
        }
        return s.toString();
    }
}

