/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.crypto;

import jpcsp.HLE.VFS.BufferedVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.crypto.PGDBlockVirtualFile;

public class PGDVirtualFile
extends BufferedVirtualFile {
    private boolean isValid;
    private boolean isHeaderPresent;

    public PGDVirtualFile(byte[] key, IVirtualFile pgdFile) {
        this.init(key, pgdFile, 0);
    }

    public PGDVirtualFile(byte[] key, IVirtualFile pgdFile, int dataOffset) {
        this.init(key, pgdFile, dataOffset);
    }

    private void init(byte[] key, IVirtualFile pgdFile, int dataOffset) {
        this.isValid = false;
        long position = pgdFile.getPosition();
        if (this.isHeaderValid(pgdFile)) {
            PGDBlockVirtualFile pgdBlockFile = new PGDBlockVirtualFile(pgdFile, key, dataOffset);
            this.isHeaderPresent = pgdBlockFile.isHeaderPresent();
            if (pgdBlockFile.isHeaderValid()) {
                this.setBufferedVirtualFile(pgdBlockFile, pgdBlockFile.getBlockSize());
                this.isValid = true;
            }
        }
        if (!this.isValid) {
            pgdFile.ioLseek(position);
            this.setBufferedVirtualFile(pgdFile, 4096);
        }
    }

    protected boolean isHeaderValid(IVirtualFile pgdFile) {
        return true;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isHeaderPresent() {
        return this.isHeaderPresent;
    }
}

