/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.util.Utilities;

public class SceNpTicket
extends pspAbstractMemoryMappedStructure {
    public static final int NUMBER_PARAMETERS = 12;
    public int version;
    public int size;
    public int unknown;
    public int sizeParams;
    public List<TicketParam> parameters = new LinkedList<TicketParam>();
    public byte[] unknownBytes;

    @Override
    protected void read() {
        this.version = this.read32();
        this.size = this.endianSwap32(this.read32());
        this.unknown = this.endianSwap16((short)this.read16());
        this.sizeParams = this.endianSwap16((short)this.read16());
        this.parameters.clear();
        for (int i = 0; i < 12; ++i) {
            int type = this.endianSwap16((short)this.read16());
            int length = this.endianSwap16((short)this.read16());
            byte[] value = new byte[length];
            this.read8Array(value);
            TicketParam ticketParam = new TicketParam(type, value);
            this.parameters.add(ticketParam);
        }
        this.unknownBytes = new byte[this.size - this.getOffset() + 8];
        this.read8Array(this.unknownBytes);
    }

    @Override
    protected void write() {
        this.write32(this.version);
        this.write32(this.endianSwap32(this.size));
        this.write16((short)this.endianSwap16((short)this.unknown));
        this.write16((short)this.endianSwap16((short)this.sizeParams));
        for (TicketParam ticketParam : this.parameters) {
            this.write16((short)this.endianSwap16((short)ticketParam.getType()));
            byte[] value = ticketParam.getBytesValue();
            this.write16((short)this.endianSwap16((short)value.length));
            this.write8Array(value);
        }
        this.write8Array(this.unknownBytes);
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.sizeof()];
        ByteBuffer b = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        b.putInt(this.version);
        b.putInt(this.endianSwap32(this.size));
        b.putShort((short)this.endianSwap16((short)this.unknown));
        b.putShort((short)this.endianSwap16((short)this.sizeParams));
        for (TicketParam ticketParam : this.parameters) {
            b.putShort((short)this.endianSwap16((short)ticketParam.getType()));
            byte[] value = ticketParam.getBytesValue();
            b.putShort((short)this.endianSwap16((short)value.length));
            b.put(value);
        }
        b.put(this.unknownBytes);
        return bytes;
    }

    public void read(byte[] bytes, int offset, int length) {
        ByteBuffer b = ByteBuffer.wrap(bytes, offset, length).order(ByteOrder.LITTLE_ENDIAN);
        this.version = b.getInt();
        this.size = this.endianSwap32(b.getInt());
        this.unknown = this.endianSwap16(b.getShort());
        this.sizeParams = this.endianSwap16(b.getShort());
        int readSize = 12;
        this.parameters.clear();
        for (int i = 0; i < 12; ++i) {
            int type = this.endianSwap16(b.getShort());
            int valueLength = this.endianSwap16(b.getShort());
            byte[] value = new byte[valueLength];
            b.get(value);
            readSize += 4 + valueLength;
            TicketParam ticketParam = new TicketParam(type, value);
            this.parameters.add(ticketParam);
        }
        this.unknownBytes = new byte[this.size - readSize + 8];
        b.get(this.unknownBytes);
    }

    @Override
    public int sizeof() {
        return this.size + 8;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(String.format("version=0x%08X", this.version));
        s.append(String.format(", size=0x%X", this.size));
        s.append(String.format(", unknown=0x%X", this.unknown));
        for (int i = 0; i < this.parameters.size(); ++i) {
            TicketParam param = this.parameters.get(i);
            s.append(String.format(", param#%d=%s", i, param));
        }
        s.append(String.format(", unknownBytes: %s", Utilities.getMemoryDump(this.unknownBytes, 0, this.unknownBytes.length)));
        return s.toString();
    }

    public static class TicketParam {
        public static final int PARAM_TYPE_NULL = 0;
        public static final int PARAM_TYPE_INT = 1;
        public static final int PARAM_TYPE_LONG = 2;
        public static final int PARAM_TYPE_STRING = 4;
        public static final int PARAM_TYPE_DATE = 7;
        public static final int PARAM_TYPE_STRING_ASCII = 8;
        public int type;
        private byte[] value;

        public TicketParam(int type, byte[] value) {
            this.type = type;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        private int getIntValue(int offset) {
            return Utilities.endianSwap32(Utilities.readUnaligned32(this.value, offset));
        }

        public int getIntValue() {
            return this.getIntValue(0);
        }

        public long getLongValue() {
            return (long)this.getIntValue(0) << 32 | (long)this.getIntValue(4) & 0xFFFFFFFFL;
        }

        public String getStringValue() {
            int length = this.value.length;
            for (int i = 0; i < this.value.length; ++i) {
                if (this.value[i] != 0) continue;
                length = i;
                break;
            }
            return new String(this.value, 0, length);
        }

        public byte[] getBytesValue() {
            return this.value;
        }

        public Date getDateValue() {
            return new Date(this.getLongValue());
        }

        public void writeForPSP(TPointer buffer) {
            switch (this.type) {
                case 1: {
                    buffer.setValue32(this.getIntValue());
                    break;
                }
                case 2: 
                case 7: {
                    buffer.setValue64(this.getLongValue());
                    break;
                }
                case 4: 
                case 8: {
                    int length = this.value.length;
                    if (length >= 256) {
                        length = 255;
                    }
                    Utilities.writeBytes(buffer.getAddress(), length, this.value, 0);
                    buffer.setValue8(length, (byte)0);
                    break;
                }
            }
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return String.format("0x%X", this.getIntValue());
                }
                case 4: 
                case 8: {
                    return this.getStringValue();
                }
                case 7: {
                    return this.getDateValue().toString();
                }
                case 0: {
                    return "null";
                }
                case 2: {
                    return String.format("0x%16X", this.getLongValue());
                }
            }
            return String.format("type=%d, value=%s", this.type, Utilities.getMemoryDump(this.value, 0, this.value.length));
        }
    }
}

