/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.aac;

import jpcsp.media.codec.aac.AacDecoder;
import org.apache.log4j.Logger;

public class Lpc {
    private static Logger log = AacDecoder.log;

    public static int computeLpcCoefs(float[] autoc, int maxOrder, float[] lpc, int lpcStride, boolean fail, boolean normalize) {
        int lpcOffset;
        float err = 0.0f;
        int autocOffset = 0;
        int lpcLast = lpcOffset = 0;
        if (!normalize && fail) {
            log.error((Object)String.format("computeLpcCoefs invalid parameters", new Object[0]));
        }
        if (normalize) {
            err = autoc[autocOffset++];
        }
        if (fail && (autoc[autocOffset + maxOrder - 1] == 0.0f || err <= 0.0f)) {
            return -1;
        }
        for (int i = 0; i < maxOrder; ++i) {
            int j;
            float r = -autoc[autocOffset + i];
            if (normalize) {
                for (j = 0; j < i; ++j) {
                    r -= lpc[lpcLast + j] * autoc[autocOffset + i - j - 1];
                }
                err *= 1.0f - (r /= err) * r;
            }
            lpc[lpcOffset + i] = r;
            for (j = 0; j < i + 1 >> 1; ++j) {
                float f = lpc[lpcLast + j];
                float b = lpc[lpcLast + i - 1 - j];
                lpc[lpcOffset + j] = f + r * b;
                lpc[lpcOffset + i - 1 - j] = b + r * f;
            }
            if (fail && err < 0.0f) {
                return -1;
            }
            lpcLast = lpcOffset;
            lpcOffset += lpcStride;
        }
        return 0;
    }
}

