/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.proonline;

import jpcsp.HLE.modules.sceNet;
import jpcsp.network.adhoc.AdhocMatchingEventMessage;
import jpcsp.network.adhoc.MatchingObject;
import jpcsp.network.proonline.ProOnlineNetworkAdapter;
import org.apache.log4j.Logger;

public class ProOnlineAdhocMatchingEventMessage
extends AdhocMatchingEventMessage {
    protected static Logger log = ProOnlineNetworkAdapter.log;
    protected static final int HEADER_SIZE = 5;
    private int packetOpcode;

    public ProOnlineAdhocMatchingEventMessage(MatchingObject matchingObject, int event, int packetOpcode) {
        super(matchingObject, event);
        this.packetOpcode = packetOpcode;
    }

    public ProOnlineAdhocMatchingEventMessage(MatchingObject matchingObject, int event, int packetOpcode, int address, int length, byte[] toMacAddress) {
        super(matchingObject, event, address, length, toMacAddress);
        this.packetOpcode = packetOpcode;
    }

    public ProOnlineAdhocMatchingEventMessage(MatchingObject matchingObject, int event, byte[] message, int length) {
        super(matchingObject, message, length);
        this.setEvent(event);
    }

    @Override
    public byte[] getMessage() {
        byte[] message = new byte[this.getMessageLength()];
        this.offset = 0;
        this.addToBytes(message, (byte)this.getPacketOpcode());
        this.addInt32ToBytes(message, this.getDataLength());
        this.addToBytes(message, this.data);
        return message;
    }

    @Override
    public void setMessage(byte[] message, int length) {
        if (length >= 5) {
            this.offset = 0;
            this.clearId();
            this.setPacketOpcode(this.copyByteFromBytes(message));
            int dataLength = this.copyInt32FromBytes(message);
            this.data = new byte[Math.min(dataLength, length - 5)];
            this.copyFromBytes(message, this.data);
        }
    }

    protected int getPacketOpcode() {
        return this.packetOpcode;
    }

    protected void setPacketOpcode(int packetOpcode) {
        this.packetOpcode = packetOpcode;
    }

    @Override
    public int getMessageLength() {
        return super.getMessageLength() + 5;
    }

    @Override
    public String toString() {
        return String.format("%s[fromMacAddress=%s, toMacAddress=%s, dataLength=%d, event=%d, packetOpcode=%d]", this.getClass().getSimpleName(), sceNet.convertMacAddressToString(this.fromMacAddress), sceNet.convertMacAddressToString(this.toMacAddress), this.getDataLength(), this.getEvent(), this.getPacketOpcode());
    }
}

