/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.crypto;

import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.crypto.PGDVirtualFile;

public class EDATVirtualFile
extends PGDVirtualFile {
    private static final int edatHeaderSize = 144;

    public EDATVirtualFile(IVirtualFile pgdFile) {
        super(null, pgdFile, 144);
    }

    @Override
    protected boolean isHeaderValid(IVirtualFile pgdFile) {
        byte[] header = new byte[144];
        long position = pgdFile.getPosition();
        int length = pgdFile.ioRead(header, 0, 144);
        pgdFile.ioLseek(position);
        if (length != 144) {
            return false;
        }
        if (header[0] != 0 || header[1] != 80 || header[2] != 83 || header[3] != 80 || header[4] != 69 || header[5] != 68 || header[6] != 65 || header[7] != 84) {
            log.warn((Object)"PSPEDAT header not found!");
            return false;
        }
        return super.isHeaderValid(pgdFile);
    }
}

