/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.compiler.nativeCode.AbstractNativeCodeSequence;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class SysclibForKernel
extends HLEModule {
    public static Logger log = Modules.getLogger("SysclibForKernel");
    private static final String validNumberCharactersUpperCase = "0123456789ABCDEF";
    private static final String validNumberCharactersLowerCase = "0123456789abcdef";

    @HLEFunction(nid=284408673, version=150)
    public int memset(@CanBeNull TPointer destAddr, int data, int size) {
        if (destAddr.isNotNull()) {
            destAddr.memset((byte)data, size);
        }
        return 0;
    }

    @HLEFunction(nid=-328262414, version=150)
    public int strcpy(@CanBeNull TPointer destAddr, @CanBeNull TPointer srcAddr) {
        if (destAddr.isNotNull() && srcAddr.isNotNull()) {
            AbstractNativeCodeSequence.strcpy(destAddr.getAddress(), srcAddr.getAddress());
        }
        return 0;
    }

    @HLEFunction(nid=-1062500046, version=150)
    public int strcmp(@CanBeNull TPointer src1Addr, @CanBeNull TPointer src2Addr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("strcmp '%s', '%s'", Utilities.readStringZ(src1Addr.getAddress()), Utilities.readStringZ(src2Addr.getAddress())));
        }
        return AbstractNativeCodeSequence.strcmp(src1Addr.getAddress(), src2Addr.getAddress());
    }

    @HLEFunction(nid=1390352748, version=150)
    public int strlen(@CanBeNull TPointer srcAddr) {
        return AbstractNativeCodeSequence.getStrlen(srcAddr.getAddress());
    }

    @HLEFunction(nid=-2117021193, version=150)
    public int memcmp(TPointer src1Addr, TPointer src2Addr, int size) {
        int result = 0;
        if (size > 0) {
            IMemoryReader memoryReader1 = MemoryReader.getMemoryReader(src1Addr.getAddress(), size, 1);
            IMemoryReader memoryReader2 = MemoryReader.getMemoryReader(src2Addr.getAddress(), size, 1);
            for (int i = 0; i < size; ++i) {
                int c2;
                int c1 = memoryReader1.readNext();
                if (c1 == (c2 = memoryReader2.readNext())) continue;
                result = c1 < c2 ? -1 : 1;
                break;
            }
        }
        return result;
    }

    @HLEFunction(nid=-1418358017, version=150)
    public int memcpy(@CanBeNull TPointer destAddr, TPointer srcAddr, int size) {
        if (destAddr.isNotNull() && destAddr.getAddress() != srcAddr.getAddress()) {
            destAddr.getMemory().memcpyWithVideoCheck(destAddr.getAddress(), srcAddr.getAddress(), size);
        }
        return destAddr.getAddress();
    }

    @HLEFunction(nid=2058572308, version=150)
    public int strncmp(@CanBeNull TPointer src1Addr, TPointer src2Addr, int size) {
        int result = 0;
        if (size > 0) {
            IMemoryReader memoryReader1 = MemoryReader.getMemoryReader(src1Addr.getAddress(), size, 1);
            IMemoryReader memoryReader2 = MemoryReader.getMemoryReader(src2Addr.getAddress(), size, 1);
            if (memoryReader1 != null && memoryReader2 != null) {
                for (int i = 0; i < size; ++i) {
                    int c2;
                    int c1 = memoryReader1.readNext();
                    if (c1 != (c2 = memoryReader2.readNext())) {
                        result = c1 - c2;
                        break;
                    }
                    if (c1 == 0) break;
                }
            }
        }
        return result;
    }

    @HLEFunction(nid=-1534253678, version=150)
    public int memmove(@CanBeNull TPointer destAddr, TPointer srcAddr, int size) {
        if (destAddr.isNotNull() && destAddr.getAddress() != srcAddr.getAddress()) {
            destAddr.getMemory().memmove(destAddr.getAddress(), srcAddr.getAddress(), size);
        }
        return 0;
    }

    @HLEFunction(nid=1986127656, version=150)
    public int sprintf(CpuState cpu, TPointer buffer, String format) {
        String formattedString = Modules.SysMemUserForUserModule.hleKernelSprintf(cpu, format, 6);
        Utilities.writeStringZ(buffer.getMemory(), buffer.getAddress(), formattedString);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sprintf returning '%s'", formattedString));
        }
        return formattedString.length();
    }

    @HLEFunction(nid=219711064, version=150)
    public int strstr(PspString s1, PspString s2) {
        int index = s1.getString().indexOf(s2.getString());
        if (index < 0) {
            return 0;
        }
        return s1.getAddress() + index;
    }

    @HLEFunction(nid=1198512458, version=150)
    public int strcat(@CanBeNull TPointer destAddr, @CanBeNull TPointer srcAddr) {
        if (destAddr.isNull() || srcAddr.isNull()) {
            return 0;
        }
        int dstLength = AbstractNativeCodeSequence.getStrlen(destAddr.getAddress());
        int srcLength = AbstractNativeCodeSequence.getStrlen(srcAddr.getAddress());
        destAddr.memcpy(dstLength, srcAddr.getAddress(), srcLength + 1);
        return destAddr.getAddress();
    }

    @HLEFunction(nid=-1038852480, version=150)
    public int snprintf(CpuState cpu, TPointer buffer, int n, String format) {
        String formattedString = Modules.SysMemUserForUserModule.hleKernelSprintf(cpu, format, 7);
        if (formattedString.length() >= n) {
            formattedString = formattedString.substring(0, n - 1);
        }
        Utilities.writeStringZ(buffer.getMemory(), buffer.getAddress(), formattedString);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("snprintf returning '%s'", formattedString));
        }
        return formattedString.length();
    }

    private boolean isNumberValidCharacter(int c, int base) {
        if (base > validNumberCharactersUpperCase.length()) {
            base = validNumberCharactersUpperCase.length();
        }
        if (validNumberCharactersUpperCase.substring(0, base).indexOf(c) >= 0) {
            return true;
        }
        return validNumberCharactersLowerCase.substring(0, base).indexOf(c) >= 0;
    }

    @HLEFunction(nid=1205703501, version=150)
    public int strtol(@CanBeNull PspString string, @CanBeNull TPointer32 endString, int base) {
        if (base == 0) {
            base = 10;
        }
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(string.getAddress(), 1);
        String s = string.getString();
        if (base == 16 && (s.startsWith("0x") || s.startsWith("0X"))) {
            memoryReader.skip(2);
            s = s.substring(2);
        }
        int i = 0;
        while (true) {
            int c;
            if ((c = memoryReader.readNext()) == 0 || !this.isNumberValidCharacter(c, base)) break;
            ++i;
        }
        endString.setValue(string.getAddress() + i);
        s = s.substring(0, i);
        int result = s.length() == 0 ? 0 : Integer.parseInt(s, base);
        if (log.isDebugEnabled()) {
            if (base == 10) {
                log.debug((Object)String.format("strtol on '%s' returning %d", s, result));
            } else {
                log.debug((Object)String.format("strtol on '%s' returning 0x%X", s, result));
            }
        }
        return result;
    }

    @HLEFunction(nid=1786314977, version=150)
    public int strtoul(@CanBeNull PspString string, @CanBeNull TPointer32 endString, int base) {
        return this.strtol(string, endString, base);
    }

    @HLEFunction(nid=-1264945513, version=150)
    public int strncpy(@CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextNextParameter, usage=BufferInfo.Usage.out) TPointer destAddr, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer srcAddr, int size) {
        int srcLength = AbstractNativeCodeSequence.getStrlen(srcAddr.getAddress());
        if (srcLength < size) {
            destAddr.memcpy(srcAddr.getAddress(), srcLength + 1);
            destAddr.clear(srcLength + 1, size - srcLength - 1);
        } else {
            destAddr.memcpy(srcAddr.getAddress(), size);
        }
        return destAddr.getAddress();
    }

    @HLEFunction(nid=2112754910, version=150)
    public long __udivdi3(long a, long b) {
        return a / b;
    }

    @HLEFunction(nid=1586388802, version=150)
    public long __umoddi3(long a, long b) {
        return a % b;
    }

    @HLEFunction(nid=-1310971160, version=150)
    public int strchr(PspString string, int c) {
        int index = string.getString().indexOf(c);
        if (index < 0) {
            return 0;
        }
        return string.getAddress() + index;
    }

    @HLEFunction(nid=851929074, version=150)
    public int look_ctype_table(int c) {
        return Modules.sceNetModule.sceNetLook_ctype_table(c);
    }

    @HLEFunction(nid=1053146102, version=150)
    public int tolower(int c) {
        return Modules.sceNetModule.sceNetTolower(c);
    }

    @HLEFunction(nid=-835750777, version=150)
    public int toupper(int c) {
        return Modules.sceNetModule.sceNetToupper(c);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2016964682, version=150)
    public int prnt() {
        return 0;
    }

    @HLEFunction(nid=1275986548, version=150)
    public int strrchr(PspString string, int c) {
        int index = string.getString().lastIndexOf(c);
        if (index < 0) {
            return 0;
        }
        return string.getAddress() + index;
    }

    @HLEFunction(nid=-2030109463, version=150)
    public void bzero(@CanBeNull TPointer destAddr, int size) {
        this.memset(destAddr, 0, size);
    }

    @HLEFunction(nid=-1866115267, version=150)
    public int strnlen(@CanBeNull TPointer srcAddr, int size) {
        if (srcAddr.isNull() || size == 0) {
            return 0;
        }
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(srcAddr.getAddress(), size, 1);
        for (int i = 0; i < size; ++i) {
            int c = memoryReader.readNext();
            if (c != 0) continue;
            return i;
        }
        return size;
    }
}

