/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ArrowKeyNavigationSupport {
    private int[] _keyCode = new int[]{37, 39, 38, 40};
    private Class[] _componentTypes;
    public static final String CLIENT_PROPERTY_ARROWKEY_NAVIGATION_SUPPORT = "ArrowKeyNavigationSupport.previousAction";

    public ArrowKeyNavigationSupport() {
    }

    public ArrowKeyNavigationSupport(Class[] classArray) {
        this._componentTypes = classArray;
    }

    public ArrowKeyNavigationSupport(int[] nArray) {
        this._keyCode = nArray;
    }

    public ArrowKeyNavigationSupport(Class[] classArray, int[] nArray) {
        this._keyCode = nArray;
        this._componentTypes = classArray;
    }

    public void install(JComponent jComponent) {
        for (int n : this._keyCode) {
            KeyStroke keyStroke;
            InputMap inputMap = jComponent.getInputMap(1);
            Object object = inputMap.get(keyStroke = KeyStroke.getKeyStroke(n, 0));
            if (object != null) {
                jComponent.putClientProperty(CLIENT_PROPERTY_ARROWKEY_NAVIGATION_SUPPORT, object);
            }
            jComponent.registerKeyboardAction(new NavigationAction(jComponent, n), "ArrowKeyNavigation " + n, keyStroke, 1);
        }
    }

    public void uninstall(JComponent jComponent) {
        for (int n : this._keyCode) {
            Object object = jComponent.getClientProperty(CLIENT_PROPERTY_ARROWKEY_NAVIGATION_SUPPORT);
            if (object != null) {
                InputMap inputMap = jComponent.getInputMap(1);
                KeyStroke keyStroke = KeyStroke.getKeyStroke(n, 0);
                inputMap.put(keyStroke, object);
                continue;
            }
            jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(n, 0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NavigationAction
    implements ActionListener {
        private JComponent _parent;
        private int _keyCode;

        public NavigationAction(JComponent jComponent, int n) {
            this._parent = jComponent;
            this._keyCode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
            final ArrayList<Component> arrayList2 = new ArrayList<Component>();
            JideSwingUtilities.setRecursively(this._parent, new JideSwingUtilities.Handler(){

                public void postAction(Component component) {
                }

                public void action(Component component) {
                    if (ArrowKeyNavigationSupport.this._componentTypes != null) {
                        boolean bl = false;
                        for (Class clazz : ArrowKeyNavigationSupport.this._componentTypes) {
                            if (!clazz.isAssignableFrom(component.getClass())) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            return;
                        }
                    }
                    Rectangle rectangle = component.getBounds();
                    arrayList.add(SwingUtilities.convertRectangle(component, rectangle, NavigationAction.this._parent));
                    arrayList2.add(component);
                }

                public boolean condition(Component component) {
                    return component.isVisible() && component.isDisplayable() && component.isFocusable() && component.isEnabled();
                }
            });
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            Component component2 = null;
            switch (this._keyCode) {
                case 39: {
                    component2 = this.findComponentToRight(component, arrayList, arrayList2);
                    break;
                }
                case 37: {
                    component2 = this.findComponentToLeft(component, arrayList, arrayList2);
                    break;
                }
                case 38: {
                    component2 = this.findComponentToAbove(component, arrayList, arrayList2);
                    break;
                }
                case 40: {
                    component2 = this.findComponentToBelow(component, arrayList, arrayList2);
                }
            }
            if (component2 != null) {
                component2.requestFocusInWindow();
            }
        }

        private Component findComponentToRight(Component component, List<Rectangle> list, List<Component> list2) {
            int n = Integer.MAX_VALUE;
            Component component2 = null;
            Rectangle rectangle = SwingUtilities.convertRectangle(component, component.getBounds(), this._parent);
            for (int i = 0; i < list.size(); ++i) {
                int n2;
                Rectangle rectangle2 = list.get(i);
                if (rectangle2.x <= rectangle.x + rectangle.width || rectangle2.y + rectangle2.height < rectangle.y || rectangle2.y > rectangle.y + rectangle.height || (n2 = rectangle2.x - rectangle.x - rectangle.width) >= n) continue;
                n = n2;
                component2 = list2.get(i);
            }
            return component2;
        }

        private Component findComponentToBelow(Component component, List<Rectangle> list, List<Component> list2) {
            int n = Integer.MAX_VALUE;
            Component component2 = null;
            Rectangle rectangle = SwingUtilities.convertRectangle(component, component.getBounds(), this._parent);
            for (int i = 0; i < list.size(); ++i) {
                int n2;
                Rectangle rectangle2 = list.get(i);
                if (rectangle2.y <= rectangle.y + rectangle.height || rectangle2.x + rectangle2.width < rectangle.x || rectangle2.x > rectangle.x + rectangle.width || (n2 = rectangle2.y - rectangle.y - rectangle.height) >= n) continue;
                n = n2;
                component2 = list2.get(i);
            }
            return component2;
        }

        private Component findComponentToLeft(Component component, List<Rectangle> list, List<Component> list2) {
            int n = Integer.MAX_VALUE;
            Component component2 = null;
            Rectangle rectangle = SwingUtilities.convertRectangle(component, component.getBounds(), this._parent);
            for (int i = 0; i < list.size(); ++i) {
                int n2;
                Rectangle rectangle2 = list.get(i);
                if (rectangle2.x + rectangle2.width >= rectangle.x || rectangle2.y + rectangle2.height < rectangle.y || rectangle2.y > rectangle.y + rectangle.height || (n2 = rectangle.x - rectangle2.x - rectangle2.width) >= n) continue;
                n = n2;
                component2 = list2.get(i);
            }
            return component2;
        }

        private Component findComponentToAbove(Component component, List<Rectangle> list, List<Component> list2) {
            int n = Integer.MAX_VALUE;
            Component component2 = null;
            Rectangle rectangle = SwingUtilities.convertRectangle(component, component.getBounds(), this._parent);
            for (int i = 0; i < list.size(); ++i) {
                int n2;
                Rectangle rectangle2 = list.get(i);
                if (rectangle2.y + rectangle2.height >= rectangle.y || rectangle2.x + rectangle2.width < rectangle.x || rectangle2.x > rectangle.x + rectangle.width || (n2 = rectangle.y - rectangle2.y - rectangle2.height) >= n) continue;
                n = n2;
                component2 = list2.get(i);
            }
            return component2;
        }
    }
}

