/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.arm.ARMInterpreter;
import jpcsp.arm.ARMMemory;
import jpcsp.arm.ARMProcessor;
import jpcsp.hardware.Model;
import jpcsp.memory.mmio.wlan.WlanEmulator;
import jpcsp.util.LWJGLFixer;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class ARMTest {
    public static Logger log;

    public static void main(String[] args) {
        LWJGLFixer.fixOnce();
        DOMConfigurator.configure((String)"LogSettings.xml");
        log = ARMProcessor.log;
        RuntimeContext.setLog4jMDC();
        new ARMTest().testFirmware();
    }

    public void testFirmware() {
        int model = 1;
        Model.setModel(model);
        File inputFile = new File(String.format("wlanfirm_%02dg.prx", Model.getGeneration()));
        byte[] buffer = new byte[(int)inputFile.length()];
        int length = buffer.length;
        try {
            FileInputStream is = new FileInputStream(inputFile);
            length = ((InputStream)is).read(buffer);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        int countFound = 0;
        int bootCodeOffset = 0;
        int bootCodeSize = 0;
        int dataOffset = 0;
        int dataSize = 0;
        int elfOffset = 0;
        int offset = 0;
        while (offset < length & countFound < 5) {
            int opcode = Utilities.readUnaligned32(buffer, offset);
            if ((opcode & Short.MIN_VALUE) == 666730496) {
                elfOffset = offset;
                ++countFound;
            } else if ((opcode & 0xFC1F0000) == 0x24040000 && (opcode & 0x3E00000) != 0) {
                bootCodeOffset = opcode & 0xFFFF;
                ++countFound;
            } else if ((opcode & 0xFFFF0000) == 604307456) {
                bootCodeSize = opcode & 0xFFFF;
                ++countFound;
            } else if ((opcode & 0xFC1F0000) == 604372992) {
                dataOffset = opcode & 0xFFFF;
                ++countFound;
            } else if ((opcode & 0xFC1F0000) == 872873984) {
                dataSize = opcode & 0xFFFF;
                dataSize += 65536;
                ++countFound;
            }
            offset += 4;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Reading '%s', elfOffset=0x%X, bootCodeOffset=0x%X, bootCodeSize=0x%X, dataOffset=0x%X, dataSize=0x%X", inputFile, elfOffset, bootCodeOffset, bootCodeSize, dataOffset, dataSize));
        }
        byte[] data = new byte[dataSize];
        System.arraycopy(buffer, elfOffset + dataOffset, data, 0, dataSize);
        ARMMemory mem = WlanEmulator.getInstance().getMemory();
        int baseAddress = 0;
        for (int i = 0; i < bootCodeSize; i += 4) {
            mem.write32(baseAddress + i, Utilities.readUnaligned32(buffer, elfOffset + bootCodeOffset + i));
        }
        mem.getHandlerWlanFirmware().setData(data, data.length);
        ARMProcessor processor = WlanEmulator.getInstance().getProcessor();
        ARMInterpreter interpreter = processor.interpreter;
        RuntimeContext.debugCodeBlockCalls = true;
        Emulator.run = true;
        WlanEmulator.getInstance().bootFromThread();
    }
}

