/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import jpcsp.HLE.VFS.MemoryVirtualFile;
import jpcsp.HLE.modules.sceMp3;
import jpcsp.Memory;
import jpcsp.format.psmf.PsmfAudioDemuxVirtualFile;
import jpcsp.media.codec.CodecFactory;
import jpcsp.media.codec.ICodec;
import jpcsp.media.codec.atrac3plus.Atrac3plusDecoder;
import jpcsp.media.codec.mp3.Mp3Decoder;
import jpcsp.media.codec.mp3.Mp3Header;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class CodecTest {
    private static Logger log = Atrac3plusDecoder.log;
    private static final boolean dumpRawAudio = false;

    private static void write(Memory mem, int addr, byte[] data, int offset, int length) {
        length = Math.min(length, data.length - offset);
        for (int i = 0; i < length; ++i) {
            mem.write8(addr + i, data[offset + i]);
        }
    }

    private static void write(Memory mem, int addr, byte[] data) {
        CodecTest.write(mem, addr, data, 0, data.length);
    }

    public static void main(String[] args) {
        DOMConfigurator.configure((String)"LogSettings.xml");
        Memory mem = Memory.getInstance();
        try {
            String fileName = "sample.at3";
            if (args != null && args.length > 0) {
                fileName = args[0];
            }
            File file = new File(fileName);
            log.info((Object)String.format("Reading file %s", file));
            int length = (int)file.length();
            FileInputStream in = new FileInputStream(file);
            byte[] buffer = new byte[length];
            ((InputStream)in).read(buffer);
            ((InputStream)in).close();
            int samplesAddr = 0x8800000;
            int inputAddr = 0x8810000;
            CodecTest.write(mem, inputAddr, buffer);
            int channels = 2;
            int codecType = -1;
            int bytesPerFrame = 0;
            int codingMode = 0;
            int dataOffset = 0;
            if (mem.read32(inputAddr) == 1179011410) {
                int scanOffset = 12;
                while (dataOffset <= 0) {
                    int chunkMagic = mem.read32(inputAddr + scanOffset);
                    int chunkLength = mem.read32(inputAddr + scanOffset + 4);
                    scanOffset += 8;
                    switch (chunkMagic) {
                        case 544501094: {
                            switch (mem.read16(inputAddr + scanOffset + 0)) {
                                case 65534: {
                                    codecType = 4096;
                                    break;
                                }
                                case 624: {
                                    codecType = 4097;
                                }
                            }
                            channels = mem.read16(inputAddr + scanOffset + 2);
                            bytesPerFrame = mem.read16(inputAddr + scanOffset + 12);
                            int extraDataSize = mem.read16(inputAddr + scanOffset + 16);
                            if (extraDataSize != 14) break;
                            codingMode = mem.read16(inputAddr + scanOffset + 18 + 6);
                            break;
                        }
                        case 1635017060: {
                            dataOffset = scanOffset;
                        }
                    }
                    scanOffset += chunkLength;
                }
            } else if (mem.read32(inputAddr + 0) == 1179472720) {
                int mpegOffset = Utilities.endianSwap32(mem.read32(inputAddr + 8));
                MemoryVirtualFile vFile = new MemoryVirtualFile(inputAddr, length);
                PsmfAudioDemuxVirtualFile demux = new PsmfAudioDemuxVirtualFile(vFile, mpegOffset, -1);
                byte[] audioData = Utilities.readCompleteFile(demux);
                bytesPerFrame = ((audioData[2] & 3) << 8 | (audioData[3] & 0xFF) << 3) + 8;
                int headerLength = 8;
                length = 0;
                for (int i = 0; i < audioData.length; i += headerLength + bytesPerFrame) {
                    CodecTest.write(mem, inputAddr + length, audioData, i + headerLength, bytesPerFrame);
                    length += bytesPerFrame;
                }
                codecType = 4096;
            } else if (mem.read32(inputAddr) == 36914249 || mem.read32(inputAddr) == 0x3334449 || mem.read32(inputAddr) == 0x4334449) {
                int headerLength = 0;
                for (int i = 0; i < 4; ++i) {
                    headerLength = (headerLength << 7) + (mem.read8(inputAddr + 6 + i) & 0x7F);
                }
                if (sceMp3.isMp3Magic(Utilities.readUnaligned16(mem, inputAddr + 10 + headerLength))) {
                    dataOffset = headerLength + 10;
                    codecType = 4098;
                }
            } else if (sceMp3.isMp3Magic(mem.read16(inputAddr))) {
                Mp3Header mp3Header = new Mp3Header();
                if (Mp3Decoder.decodeHeader(mp3Header, Integer.reverseBytes(mem.read32(inputAddr))) == 0) {
                    dataOffset = mp3Header.frameSize;
                }
                codecType = 4098;
            } else if ((Utilities.endianSwap16(mem.read16(inputAddr)) & 0xFFF0) == 65520 || file.getName().endsWith(".aac")) {
                codecType = 4099;
            } else {
                log.error((Object)String.format("File '%s' not in RIFF format", file));
                return;
            }
            AudioFormat audioFormat = new AudioFormat(44100.0f, 16, channels, true, false);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            SourceDataLine mLine = (SourceDataLine)AudioSystem.getLine(info);
            mLine.open(audioFormat);
            mLine.start();
            ICodec codec = CodecFactory.getCodec(codecType);
            codec.init(bytesPerFrame, channels, channels, codingMode);
            inputAddr += dataOffset;
            length -= dataOffset;
            OutputStream os = null;
            int frameNbr = 0;
            while (true) {
                int result;
                if ((result = codec.decode(mem, inputAddr, length, mem, samplesAddr)) < 0) {
                    log.error((Object)String.format("Frame #%d, result 0x%08X", frameNbr, result));
                    break;
                }
                if (result == 0) break;
                int consumedBytes = bytesPerFrame;
                if (result < bytesPerFrame - 2 || result > bytesPerFrame) {
                    if (bytesPerFrame == 0) {
                        consumedBytes = result;
                    } else {
                        log.warn((Object)String.format("Frame #%d, result 0x%X, expected 0x%X", frameNbr, result, bytesPerFrame));
                    }
                }
                inputAddr += consumedBytes;
                length -= consumedBytes;
                byte[] bytes = new byte[codec.getNumberOfSamples() * 2 * channels];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = (byte)mem.read8(samplesAddr + i);
                }
                mLine.write(bytes, 0, bytes.length);
                ++frameNbr;
            }
            mLine.drain();
            mLine.close();
            if (os != null) {
                os.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }
}

