/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool.demos;

import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.ToolFactory;
import java.io.File;

public class TranscodeAudioAndVideo {
    public static void main(String[] args) {
        File source;
        if (args.length < 2) {
            System.out.println("To perform a simple media transcode.  The destination format will be guessed from the file extention.");
            System.out.println("");
            System.out.println("   TranscodeAudioAndVideo <source-file> <destination-file>");
            System.out.println("");
            System.out.println("The destination type will be guess from the supplied file extsion.");
            System.exit(0);
        }
        if (!(source = new File(args[0])).exists()) {
            System.out.println("Source file does not exist: " + source);
            System.exit(0);
        }
        TranscodeAudioAndVideo.transcode(args[0], args[1]);
    }

    public static void transcode(String sourceUrl, String destinationUrl) {
        System.out.printf("transcode %s -> %s\n", sourceUrl, destinationUrl);
        IMediaReader reader = ToolFactory.makeReader(sourceUrl);
        reader.addListener(ToolFactory.makeViewer(true));
        reader.addListener(ToolFactory.makeWriter(destinationUrl, reader));
        while (reader.readPacket() == null) {
        }
    }
}

