/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractProxyVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;

public class PartialVirtualFile
extends AbstractProxyVirtualFile {
    private long startPosition;
    private long length;

    public PartialVirtualFile(IVirtualFile vFile, long startPosition, long length) {
        super(vFile);
        this.startPosition = startPosition;
        this.length = length;
        vFile.ioLseek(startPosition);
    }

    private int getRestLength() {
        long restLength = this.length() - this.getPosition();
        if (restLength > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)restLength;
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        outputLength = Math.min(outputLength, this.getRestLength());
        return this.vFile.ioRead(outputPointer, outputLength);
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        outputLength = Math.min(outputLength, this.getRestLength());
        return this.vFile.ioRead(outputBuffer, outputOffset, outputLength);
    }

    @Override
    public long ioLseek(long offset) {
        if (offset > this.length()) {
            return -1L;
        }
        long result = this.vFile.ioLseek(this.startPosition + offset);
        if (result == -1L) {
            return result;
        }
        return result - this.startPosition;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public long getPosition() {
        return this.vFile.getPosition() - this.startPosition;
    }

    @Override
    public IVirtualFile duplicate() {
        IVirtualFile vFileDuplicate = this.vFile.duplicate();
        if (vFileDuplicate == null) {
            return null;
        }
        return new PartialVirtualFile(vFileDuplicate, this.startPosition, this.length);
    }

    @Override
    public String toString() {
        return String.format("PartialVirtualFile[%s, startPosition=0x%X, length=0x%X]", this.vFile, this.startPosition, this.length);
    }
}

