/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.util.Random;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.hardware.Wlan;
import jpcsp.util.Utilities;

public class pspNetMacAddress
extends pspAbstractMemoryMappedStructure {
    public final byte[] macAddress = new byte[6];

    public pspNetMacAddress() {
    }

    public pspNetMacAddress(byte[] macAddress) {
        this.setMacAddress(macAddress);
    }

    public pspNetMacAddress(byte[] macAddress, int offset) {
        this.setMacAddress(macAddress, offset);
    }

    @Override
    protected void read() {
        for (int i = 0; i < 6; ++i) {
            this.macAddress[i] = (byte)this.read8();
        }
    }

    @Override
    protected void write() {
        for (int i = 0; i < 6; ++i) {
            this.write8(this.macAddress[i]);
        }
    }

    public void setMacAddress(byte[] macAddress) {
        this.setMacAddress(macAddress, 0);
    }

    public void setMacAddress(byte[] macAddress, int offset) {
        System.arraycopy(macAddress, offset, this.macAddress, 0, 6);
    }

    @Override
    public int sizeof() {
        return 6;
    }

    public boolean isAnyMacAddress() {
        return pspNetMacAddress.isAnyMacAddress(this.macAddress);
    }

    public static boolean isAnyMacAddress(byte[] macAddress) {
        return pspNetMacAddress.isAnyMacAddress(macAddress, 0);
    }

    public static boolean isAnyMacAddress(byte[] macAddress, int offset) {
        for (int i = 0; i < 6; ++i) {
            if (macAddress[offset + i] == -1) continue;
            return false;
        }
        return true;
    }

    public boolean isEmptyMacAddress() {
        return pspNetMacAddress.isEmptyMacAddress(this.macAddress);
    }

    public static boolean isEmptyMacAddress(byte[] macAddress) {
        return pspNetMacAddress.isEmptyMacAddress(macAddress, 0);
    }

    public static boolean isEmptyMacAddress(byte[] macAddress, int offset) {
        for (int i = 0; i < 6; ++i) {
            if (macAddress[offset + i] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isMulticastMacAddress() {
        return pspNetMacAddress.isMulticastMacAddress(this.macAddress);
    }

    public static boolean isMulticastMacAddress(byte[] macAddress) {
        return pspNetMacAddress.isMulticastMacAddress(macAddress, 0);
    }

    public static boolean isMulticastMacAddress(byte[] macAddress, int offset) {
        return Utilities.hasBit(macAddress[offset], 0);
    }

    public boolean isMyMacAddress() {
        return pspNetMacAddress.isMyMacAddress(this.macAddress);
    }

    public static boolean isMyMacAddress(byte[] macAddress) {
        return pspNetMacAddress.isMyMacAddress(macAddress, 0);
    }

    public static boolean isMyMacAddress(byte[] macAddress, int offset) {
        return pspNetMacAddress.equals(Wlan.getMacAddress(), 0, macAddress, offset);
    }

    public boolean equals(Object object) {
        if (object instanceof pspNetMacAddress) {
            pspNetMacAddress macAddress = (pspNetMacAddress)object;
            return this.equals(macAddress.macAddress);
        }
        return super.equals(object);
    }

    public boolean equals(byte[] macAddress) {
        return pspNetMacAddress.equals(macAddress, this.macAddress);
    }

    public static boolean equals(byte[] macAddress1, byte[] macAddress2) {
        return pspNetMacAddress.equals(macAddress1, 0, macAddress2, 0);
    }

    public static boolean equals(byte[] macAddress1, int offset1, byte[] macAddress2, int offset2) {
        if (macAddress1 == null) {
            return macAddress2 == null;
        }
        if (macAddress2 == null) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (macAddress1[offset1 + i] == macAddress2[offset2 + i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] getRandomMacAddress() {
        byte[] macAddress = new byte[6];
        Random random = new Random();
        byte[] oui = Wlan.validMacAddressOUIs[random.nextInt(Wlan.validMacAddressOUIs.length)];
        macAddress[0] = oui[0];
        macAddress[1] = oui[1];
        macAddress[2] = oui[2];
        for (int i = 3; i < 6; ++i) {
            macAddress[i] = (byte)random.nextInt(256);
        }
        macAddress[0] = (byte)(macAddress[0] & 0xFC);
        return macAddress;
    }

    public static String toString(byte[] macAddress) {
        return pspNetMacAddress.toString(macAddress, 0);
    }

    public static String toString(byte[] macAddress, int offset) {
        return String.format("%02x:%02x:%02x:%02x:%02x:%02x", macAddress[offset + 0], macAddress[offset + 1], macAddress[offset + 2], macAddress[offset + 3], macAddress[offset + 4], macAddress[offset + 5]);
    }

    @Override
    public String toString() {
        if (this.getBaseAddress() == 0) {
            return pspNetMacAddress.toString(this.macAddress);
        }
        if (this.isEmptyMacAddress()) {
            return super.toString();
        }
        return String.format("%s(%s)", super.toString(), pspNetMacAddress.toString(this.macAddress));
    }
}

