/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.HashMap;
import java.util.Map;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer16;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.pspBaseCallback;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceNpMatching2
extends HLEModule {
    public static Logger log = Modules.getLogger("sceNpMatching2");
    private static final String idContextPurpose = "sceNpMatching2Context";
    protected int defaultRequestCallbackFunction;
    protected int defaultRequestCallbackArgument;
    protected int defaultRequestTimeout;
    protected int defaultRequestAppReqId;
    protected int defaultRoomEventCallbackFunction;
    protected int defaultRoomEventCallbackArgument;
    protected int defaultRoomMessageCallbackFunction;
    protected int defaultRoomMessageCallbackArgument;
    protected int signalingCallbackFunction;
    protected int signalingCallbackArgument;
    protected Map<Integer, MatchingContext> contextMap = new HashMap<Integer, MatchingContext>();
    protected SysMemUserForUser.SysMemInfo dataBuffer;

    private void notifyRequestCallback(int ctxId) {
        MatchingContext context = this.contextMap.get(ctxId);
        if (context == null || !context.isStarted() || this.defaultRequestCallbackFunction == 0) {
            return;
        }
        pspBaseCallback requestCallback = Modules.ThreadManForUserModule.hleKernelCreateCallback(this.defaultRequestCallbackFunction, 6);
        if (Modules.ThreadManForUserModule.hleKernelRegisterCallback(7, requestCallback)) {
            if (this.dataBuffer == null) {
                this.dataBuffer = Modules.SysMemUserForUserModule.malloc(1, "sceNpMatching2-DataBuffer", 0, 128, 0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNpMatching2.notifyRequestCallback allocated dataBuffer %s", this.dataBuffer));
                }
            }
            Memory mem = Emulator.getMemory();
            mem.memset(this.dataBuffer.addr, (byte)0, this.dataBuffer.size);
            int reqId = 69905;
            int event = 8738;
            int data = this.dataBuffer.addr;
            int errorCode = 0;
            switch (reqId >>> 16) {
                case 0: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 16: {
                    data = 0;
                    break;
                }
                case 1: {
                    mem.write16(data, (short)13107);
                    mem.write8(data + 2, (byte)68);
                    break;
                }
                case 2: {
                    int ptr = data + 8;
                    mem.write32(data, ptr);
                    mem.write32(data + 4, 0);
                    mem.write32(ptr, 0);
                    for (int i = 4; i < 64; i += 4) {
                        mem.write32(ptr + i, 305419776 + i);
                    }
                    break;
                }
                case 3: {
                    mem.write32(data + 0, 0x33333333);
                    mem.write32(data + 4, 0x44444444);
                    mem.write32(data + 8, 0x55555555);
                    mem.write32(data + 12, 0x66666666);
                    break;
                }
                case 4: 
                case 5: {
                    int ptr = data + 4;
                    mem.write32(data, ptr);
                    mem.write16(ptr, (short)13107);
                    for (int i = 4; i < 64; i += 4) {
                        mem.write32(ptr + i, 305419776 + i);
                    }
                    int ptr2 = ptr + 64;
                    mem.write32(ptr + 44, ptr2);
                    mem.write16(ptr2 + 56, (short)17476);
                    break;
                }
                case 8: {
                    mem.write32(data, 1);
                    break;
                }
                case 12: 
                case 14: 
                case 15: {
                    mem.write32(data + 0, 305419896);
                    mem.write32(data + 4, -1698898192);
                }
            }
            requestCallback.setArgument(0, ctxId);
            requestCallback.setArgument(1, reqId);
            requestCallback.setArgument(2, event);
            requestCallback.setArgument(3, errorCode);
            requestCallback.setArgument(4, data);
            requestCallback.setArgument(5, this.defaultRequestCallbackArgument);
            Modules.ThreadManForUserModule.hleKernelNotifyCallback(7, requestCallback);
        }
    }

    private void notifySignalingCallback(int ctxId) {
        MatchingContext context = this.contextMap.get(ctxId);
        if (context == null || !context.isStarted() || this.signalingCallbackFunction == 0) {
            return;
        }
        pspBaseCallback signalingCallback = Modules.ThreadManForUserModule.hleKernelCreateCallback(this.signalingCallbackFunction, 8);
        if (Modules.ThreadManForUserModule.hleKernelRegisterCallback(7, signalingCallback)) {
            long roomId = 1311768467463790320L;
            int peerMemberId = 4369;
            int event = 20737;
            int errorCode = 0;
            signalingCallback.setArgument(0, ctxId);
            signalingCallback.setArgument(2, (int)roomId);
            signalingCallback.setArgument(3, (int)(roomId >>> 32));
            signalingCallback.setArgument(4, peerMemberId);
            signalingCallback.setArgument(5, event);
            signalingCallback.setArgument(6, errorCode);
            signalingCallback.setArgument(7, this.signalingCallbackArgument);
            Modules.ThreadManForUserModule.hleKernelNotifyCallback(7, signalingCallback);
        }
    }

    private void notifyRoomEventCallback(int ctxId) {
        MatchingContext context = this.contextMap.get(ctxId);
        if (context == null || !context.isStarted() || this.defaultRoomEventCallbackFunction == 0) {
            return;
        }
        pspBaseCallback roomEventCallback = Modules.ThreadManForUserModule.hleKernelCreateCallback(this.defaultRoomEventCallbackFunction, 7);
        if (Modules.ThreadManForUserModule.hleKernelRegisterCallback(7, roomEventCallback)) {
            long roomId = 1311768467463790320L;
            int event = 4353;
            int errorCode = 0;
            roomEventCallback.setArgument(0, ctxId);
            roomEventCallback.setArgument(2, (int)roomId);
            roomEventCallback.setArgument(3, (int)(roomId >>> 32));
            roomEventCallback.setArgument(4, event);
            roomEventCallback.setArgument(5, errorCode);
            roomEventCallback.setArgument(6, this.defaultRoomEventCallbackArgument);
            Modules.ThreadManForUserModule.hleKernelNotifyCallback(7, roomEventCallback);
        }
    }

    private void notifyRoomMessageCallback(int ctxId) {
        MatchingContext context = this.contextMap.get(ctxId);
        if (context == null || !context.isStarted() || this.defaultRoomMessageCallbackFunction == 0) {
            return;
        }
        pspBaseCallback roomMessageCallback = Modules.ThreadManForUserModule.hleKernelCreateCallback(this.defaultRoomMessageCallbackFunction, 8);
        if (Modules.ThreadManForUserModule.hleKernelRegisterCallback(7, roomMessageCallback)) {
            if (this.dataBuffer == null) {
                this.dataBuffer = Modules.SysMemUserForUserModule.malloc(1, "sceNpMatching2-DataBuffer", 0, 128, 0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNpMatching2.notifyRoomMessageCallback allocated dataBuffer %s", this.dataBuffer));
                }
            }
            Memory mem = Emulator.getMemory();
            mem.memset(this.dataBuffer.addr, (byte)0, this.dataBuffer.size);
            long roomId = 1311768467463790320L;
            int srcMemberId = 4369;
            int event = 8449;
            int data = this.dataBuffer.addr;
            String dummyString = "Hello, world!";
            int stringData = data + 24;
            mem.write32(data + 12, stringData);
            mem.write32(data + 16, dummyString.length());
            mem.write32(data + 20, 1);
            Utilities.writeStringZ(mem, stringData, dummyString);
            roomMessageCallback.setArgument(0, ctxId);
            roomMessageCallback.setArgument(2, (int)roomId);
            roomMessageCallback.setArgument(3, (int)(roomId >>> 32));
            roomMessageCallback.setArgument(4, srcMemberId);
            roomMessageCallback.setArgument(5, event);
            roomMessageCallback.setArgument(6, data);
            roomMessageCallback.setArgument(7, this.defaultRoomMessageCallbackArgument);
            Modules.ThreadManForUserModule.hleKernelNotifyCallback(7, roomMessageCallback);
        }
    }

    @HLEUnimplemented
    @HLEFunction(nid=778172129, version=150)
    public int sceNpMatching2Init(int poolSize, int threadPriority, int cpuAffinityMask, int threadStackSize) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1946976884, version=150)
    public int sceNpMatching2Term() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=314941713, version=150)
    public int sceNpMatching2GetRoomDataExternalList() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=337727819, version=150)
    public int sceNpMatching2SetDefaultRoomEventOptParam(int ctxId, TPointer optParam) {
        boolean unknownFlag4;
        int callbackFunction = optParam.getValue32(0);
        int callbackArgument = optParam.getValue32(4);
        boolean unknownFlag1 = optParam.getValue32(8) != 0;
        boolean unknownFlag2 = optParam.getValue32(12) != 0;
        boolean unknownFlag3 = optParam.getValue32(16) != 0;
        boolean bl = unknownFlag4 = optParam.getValue32(20) != 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNpMatching2SetDefaultRoomEventOptParam callbackFunction=0x%08X, callbackArgument=0x%X, unknownFlag1=%b, unknownFlag2=%b, unknownFlag3=%b, unknownFlag4=%b", callbackFunction, callbackArgument, unknownFlag1, unknownFlag2, unknownFlag3, unknownFlag4));
        }
        this.defaultRoomEventCallbackFunction = callbackFunction;
        this.defaultRoomEventCallbackArgument = callbackArgument;
        this.notifyRoomEventCallback(ctxId);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=420477187, version=150)
    public int sceNpMatching2ContextStart(int ctxId) {
        MatchingContext context = this.contextMap.get(ctxId);
        if (context == null) {
            return -1;
        }
        context.setStarted(true);
        this.notifyRequestCallback(ctxId);
        this.notifySignalingCallback(ctxId);
        this.notifyRoomEventCallback(ctxId);
        this.notifyRoomMessageCallback(ctxId);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=586386863, version=150)
    public int sceNpMatching2GetMemoryStat() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=725127932, version=150)
    public int sceNpMatching2ContextStop(int ctxId) {
        MatchingContext context = this.contextMap.get(ctxId);
        if (context == null) {
            return -1;
        }
        context.setStarted(false);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=949152166, version=150)
    public int sceNpMatching2SignalingGetConnectionInfo() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1038549569, version=150)
    public int sceNpMatching2DestroyContext(int ctxId) {
        if (this.dataBuffer != null) {
            Modules.SysMemUserForUserModule.free(this.dataBuffer);
            this.dataBuffer = null;
        }
        if (!SceUidManager.releaseId(ctxId, idContextPurpose)) {
            return -1;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1230935997, version=150)
    public int sceNpMatching2GrantRoomOwner() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1323542764, version=150)
    public int sceNpMatching2GetServerInfo(int ctxId, TPointer16 serverIdAddr, TPointer32 unknown1, TPointer32 unknown2) {
        int serverId = serverIdAddr.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNpMatching2GetServerInfo serverId=0x%X, unknown1: %s, unknown2: %s", serverId, Utilities.getMemoryDump(unknown1.getAddress(), 16), Utilities.getMemoryDump(unknown2.getAddress(), 20)));
        }
        unknown2.setValue(65536);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1345375315, version=150)
    public int sceNpMatching2CreateContext(TPointer communicationId, TPointer passPhrase, TPointer16 ctxId, int unknown) {
        int uid;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNpMatching2CreateContext communicationId=%s, passPhrase=%s", Utilities.getMemoryDump(communicationId.getAddress(), 12), Utilities.getMemoryDump(passPhrase.getAddress(), 128)));
        }
        if ((uid = SceUidManager.getNewId(idContextPurpose, 1, 7)) == Integer.MIN_VALUE) {
            return -1;
        }
        this.contextMap.put(uid, new MatchingContext());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNpMatching2CreateContext returning 0x%X", uid));
        }
        ctxId.setValue(uid);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1442284415, version=150)
    public int sceNpMatching2SendRoomChatMessage() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1551742628, version=150)
    public int sceNpMatching2GetRoomMemberDataInternalList() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1662419660, version=150)
    public int sceNpMatching2SetDefaultRequestOptParam(int ctxId, TPointer optParam) {
        int callbackFunction = optParam.getValue32(0);
        int callbackArgument = optParam.getValue32(4);
        int timeout = optParam.getValue32(8);
        short appReqId = optParam.getValue16(12);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNpMatching2SetDefaultRequestOptParam callbackFunction=0x%08X, callbackArgument=0x%X, timeout=0x%X, appReqId=0x%X", callbackFunction, callbackArgument, timeout, (int)appReqId));
        }
        this.defaultRequestCallbackFunction = callbackFunction;
        this.defaultRequestCallbackArgument = callbackArgument;
        this.defaultRequestTimeout = timeout;
        this.defaultRequestAppReqId = appReqId;
        this.notifyRequestCallback(ctxId);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1835863157, version=150)
    public int sceNpMatching2SignalingGetConnectionStatus() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2076165159, version=150)
    public int sceNpMatching2JoinRoom() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2099076958, version=150)
    public int sceNpMatching2SetUserInfo() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2108328592, version=150)
    public int sceNpMatching2SetRoomMemberDataInternal() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2131356328, version=150)
    public int sceNpMatching2GetRoomMemberIdListLocal() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2118042003, version=150)
    public int sceNpMatching2SearchRoom() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1932457497, version=150)
    public int sceNpMatching2SignalingGetPeerNetInfo() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1805467558, version=150)
    public int sceNpMatching2SignalingCancelPeerNetInfo() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1756193076, version=150)
    public int sceNpMatching2KickoutRoomMember() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1704462896, version=150)
    public int sceNpMatching2SetSignalingOptParam() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1547527983, version=150)
    public int sceNpMatching2RegisterSignalingCallback(int ctxId, TPointer callbackFunction, int callbackArgument) {
        this.signalingCallbackFunction = callbackFunction.getAddress();
        this.signalingCallbackArgument = callbackArgument;
        this.notifySignalingCallback(ctxId);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1522631575, version=150)
    public int sceNpMatching2GetWorldInfoList(int ctxId, TPointer16 serverIdAddr, @CanBeNull TPointer optParam, TPointer32 assignedReqId) {
        if (optParam.isNotNull()) {
            int callbackFunction = optParam.getValue32(0);
            int callbackArgument = optParam.getValue32(4);
            int timeout = optParam.getValue32(8);
            short appReqId = optParam.getValue16(12);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNpMatching2GetWorldInfoList callbackFunction=0x%08X, callbackArgument=0x%X, timeout=0x%X, appReqId=0x%X", callbackFunction, callbackArgument, timeout, (int)appReqId));
            }
        }
        int serverId = serverIdAddr.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNpMatching2GetWorldInfoList serverId=0x%X", serverId));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1518903873, version=150)
    public int sceNpMatching2GetRoomMemberDataInternal() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1429171094, version=150)
    public int sceNpMatching2CreateJoinRoom() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-941150523, version=150)
    public int sceNpMatching2GetSignalingOptParamLocal() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-932162726, version=150)
    public int sceNpMatching2LeaveRoom() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-922985151, version=150)
    public int sceNpMatching2GetUserInfoList() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-785083989, version=150)
    public int sceNpMatching2SetDefaultRoomMessageOptParam(int ctxId, TPointer optParam) {
        int callbackFunction = optParam.getValue32(0);
        int callbackArgument = optParam.getValue32(4);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNpMatching2SetDefaultRoomMessageOptParam callbackFunction=0x%08X, callbackArgument=0x%X", callbackFunction, callbackArgument));
        }
        this.defaultRoomMessageCallbackFunction = callbackFunction;
        this.defaultRoomMessageCallbackArgument = callbackArgument;
        this.notifyRoomMessageCallback(ctxId);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-673927502, version=150)
    public int sceNpMatching2SetRoomDataExternal() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-538069438, version=150)
    public int sceNpMatching2SignalingGetPeerNetInfoResult() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-485235322, version=150)
    public int sceNpMatching2GetRoomDataInternal() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-423019075, version=150)
    public int sceNpMatching2SetRoomDataInternal() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-278380721, version=150)
    public int sceNpMatching2GetRoomDataInternalLocal() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-231965988, version=150)
    public int sceNpMatching2GetRoomMemberDataInternalLocal() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-193772804, version=150)
    public int sceNpMatching2GetServerIdListLocal(int ctxId, TPointer16 serverIds, int maxServerIds) {
        for (int i = 0; i < maxServerIds; ++i) {
            serverIds.setValue(i * 2, i + 4660);
        }
        return maxServerIds;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-147210606, version=150)
    public int sceNpMatching2GetRoomPasswordLocal() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-113190483, version=150)
    public int sceNpMatching2SendRoomMessage() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-86267429, version=150)
    public int sceNpMatching2AbortRequest() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-67857216, version=150)
    public int sceNpMatching2GetRoomMemberDataExternalList() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-13440507, version=150)
    public int sceNpMatching2SignalingGetLocalNetInfo() {
        return 0;
    }

    private static class MatchingContext {
        private boolean started;

        private MatchingContext() {
        }

        public boolean isStarted() {
            return this.started;
        }

        public void setStarted(boolean started) {
            this.started = started;
        }
    }
}

