/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.jpcsp;

import java.util.LinkedList;
import jpcsp.HLE.modules.sceNet;
import jpcsp.network.BaseNetworkAdapter;
import jpcsp.network.adhoc.AdhocMatchingEventMessage;
import jpcsp.network.adhoc.MatchingObject;

public class JpcspAdhocMatchingAcceptEventMessage
extends AdhocMatchingEventMessage {
    protected static final int HEADER_SIZE = 21;
    protected LinkedList<byte[]> members;

    public JpcspAdhocMatchingAcceptEventMessage(MatchingObject matchingObject, int event, int address, int length, byte[] toMacAddress) {
        super(matchingObject, event, address, length, toMacAddress);
    }

    public JpcspAdhocMatchingAcceptEventMessage(MatchingObject matchingObject, byte[] message, int length) {
        super(matchingObject, message, length);
    }

    protected int getMemberCount() {
        if (this.getMatchingObject() == null) {
            return 0;
        }
        if (this.getMatchingObject().getMode() != 1) {
            return 0;
        }
        return this.getMatchingObject().getMembers().size();
    }

    @Override
    public byte[] getMessage() {
        byte[] message = new byte[this.getMessageLength()];
        this.offset = 0;
        this.addInt32ToBytes(message, this.getId());
        this.addToBytes(message, this.fromMacAddress);
        this.addToBytes(message, this.toMacAddress);
        this.addToBytes(message, (byte)this.getEvent());
        int memberCount = this.getMemberCount();
        this.addInt32ToBytes(message, memberCount);
        for (int i = 0; i < memberCount; ++i) {
            this.addToBytes(message, this.getMatchingObject().getMembers().get((int)i).macAddress);
        }
        this.addToBytes(message, this.data);
        return message;
    }

    @Override
    public void setMessage(byte[] message, int length) {
        if (length >= this.getMessageLength()) {
            this.offset = 0;
            this.setId(this.copyInt32FromBytes(message));
            this.copyFromBytes(message, this.fromMacAddress);
            this.copyFromBytes(message, this.toMacAddress);
            this.setEvent(this.copyByteFromBytes(message));
            int memberCount = this.copyInt32FromBytes(message);
            this.members = new LinkedList();
            for (int i = 0; i < memberCount; ++i) {
                byte[] mac = new byte[6];
                this.copyFromBytes(message, mac);
                this.members.add(mac);
                if (!BaseNetworkAdapter.log.isDebugEnabled()) continue;
                BaseNetworkAdapter.log.debug((Object)String.format("Received Member#%d: MAC %s", i, sceNet.convertMacAddressToString(mac)));
            }
            this.data = new byte[length - 21 - 6 * memberCount];
            this.copyFromBytes(message, this.data);
        }
    }

    @Override
    public int getMessageLength() {
        return 21 + 6 * this.getMemberCount() + this.getDataLength();
    }

    @Override
    public void processOnReceive(int macAddr, int optData, int optLen) {
        if (this.members != null && !this.members.isEmpty()) {
            this.getMatchingObject().clearMembers();
            for (byte[] member : this.members) {
                this.getMatchingObject().addMember(member);
            }
        }
        super.processOnReceive(macAddr, optData, optLen);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.members != null) {
            for (byte[] member : this.members) {
                if (s.length() > 0) {
                    s.append(", ");
                }
                s.append(sceNet.convertMacAddressToString(member));
            }
        }
        return String.format("%s[id=0x%X, fromMacAddress=%s, toMacAddress=%s, event=%d, members=%s]", this.getClass().getSimpleName(), this.getId(), sceNet.convertMacAddressToString(this.fromMacAddress), sceNet.convertMacAddressToString(this.toMacAddress), this.getEvent(), s);
    }
}

