/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler.nativeCode;

import jpcsp.Allegrex.compiler.nativeCode.AbstractNativeCodeSequence;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class Strcmp
extends AbstractNativeCodeSequence {
    public static void call() {
        int str1 = Strcmp.getGprA0();
        int str2 = Strcmp.getGprA1();
        if (str1 == 0 || str2 == 0) {
            if (str1 == str2) {
                Strcmp.setGprV0(0);
            }
            if (str1 != 0) {
                Strcmp.setGprV0(1);
            } else {
                Strcmp.setGprV0(-1);
            }
        } else {
            if (!Memory.isAddressGood(str1)) {
                Strcmp.getMemory(str1).invalidMemoryAddress(str1, "strcmp", 4);
                return;
            }
            if (!Memory.isAddressGood(str2)) {
                Strcmp.getMemory(str2).invalidMemoryAddress(str2, "strcmp", 4);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("strcmp src1=%s, src2=%s", Utilities.getMemoryDump(str1, Strcmp.getStrlen(str1)), Utilities.getMemoryDump(str2, Strcmp.getStrlen(str2))));
            }
            Strcmp.setGprV0(Strcmp.strcmp(str1, str2));
        }
    }

    public static void call(int valueEqual, int valueLower, int valueHigher) {
        int str1 = Strcmp.getGprA0();
        int str2 = Strcmp.getGprA1();
        if (str1 == 0 || str2 == 0) {
            if (str1 == str2) {
                Strcmp.setGprV0(valueEqual);
            }
            if (str1 != 0) {
                Strcmp.setGprV0(valueHigher);
            } else {
                Strcmp.setGprV0(valueLower);
            }
        } else {
            int cmp;
            if (!Memory.isAddressGood(str1)) {
                Strcmp.getMemory(str1).invalidMemoryAddress(str1, "strcmp", 4);
                return;
            }
            if (!Memory.isAddressGood(str2)) {
                Strcmp.getMemory(str2).invalidMemoryAddress(str2, "strcmp", 4);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("strcmp src1=%s, src2=%s", Utilities.getMemoryDump(str1, Strcmp.getStrlen(str1)), Utilities.getMemoryDump(str2, Strcmp.getStrlen(str2))));
            }
            if ((cmp = Strcmp.strcmp(str1, str2)) < 0) {
                Strcmp.setGprV0(valueLower);
            } else if (cmp > 0) {
                Strcmp.setGprV0(valueHigher);
            } else {
                Strcmp.setGprV0(valueEqual);
            }
        }
    }
}

