/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.wlan.threadx;

import jpcsp.arm.ARMInstructions;
import jpcsp.arm.ARMProcessor;
import jpcsp.memory.mmio.wlan.BaseHLECall;

public class TXJumpCall
extends BaseHLECall {
    private int register;

    public TXJumpCall(int register) {
        this.register = register;
    }

    @Override
    public void call(ARMProcessor processor, int imm) {
        int addr = processor.getRegister(this.register);
        if (log.isDebugEnabled()) {
            StringBuilder args = new StringBuilder();
            for (int i = 0; i < this.register; ++i) {
                args.append(String.format(", %s=0x%08X", ARMInstructions.getRegisterName(i), processor.getRegister(i)));
            }
            log.debug((Object)String.format("HLEJumpCall imm=0x%X, %s=0x%08X%s", imm, ARMInstructions.getRegisterName(this.register), addr, args));
        }
        this.jump(processor, addr);
    }

    @Override
    public String toString() {
        return String.format("TXJumpCall %s", ARMInstructions.getRegisterName(this.register));
    }
}

