/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedList<E>
implements List<E> {
    private Comparator<E> comparator;
    private List<E> delegate;

    public SortedList(List<E> list, Comparator comparator) {
        this.delegate = list;
        this.comparator = comparator;
    }

    @Override
    public void add(int n, E e) {
        this.add(e);
    }

    @Override
    public boolean add(E e) {
        int n = this.delegate.size();
        for (int i = 0; i < n; ++i) {
            if (this.comparator.compare(this.delegate.get(i), e) <= 0) continue;
            this.delegate.add(i, e);
            return true;
        }
        this.delegate.add(e);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.delegate.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        return this.delegate.addAll(n, collection);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.delegate.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.delegate.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        return ((Object)this.delegate).equals(object);
    }

    @Override
    public E get(int n) {
        return this.delegate.get(n);
    }

    @Override
    public int hashCode() {
        return ((Object)this.delegate).hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this.delegate.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.delegate.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return this.delegate.listIterator(n);
    }

    @Override
    public E remove(int n) {
        return this.delegate.remove(n);
    }

    @Override
    public boolean remove(Object object) {
        return this.delegate.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.delegate.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.delegate.retainAll(collection);
    }

    @Override
    public E set(int n, E e) {
        return this.delegate.set(n, e);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public List<E> subList(int n, int n2) {
        return this.delegate.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        return this.delegate.toArray(objectArray);
    }

    public static void main(String[] stringArray) {
        SortedList<String> sortedList = new SortedList<String>(new ArrayList(), new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareTo(string2);
            }
        });
        sortedList.add("test");
        sortedList.add("aaa");
        sortedList.add("ddd");
        sortedList.add("ccc");
        for (String string : sortedList) {
            System.out.println(string);
        }
    }
}

